/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.jbpm.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jbpm.services.api.query.QueryService;
import org.kie.server.remote.rest.jbpm.search.ProcessInstanceSearchResource;
import org.kie.server.remote.rest.jbpm.search.TaskSearchResource;
import org.kie.server.services.api.KieServerApplicationComponentsService;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.api.SupportedTransports;
import org.kie.server.services.jbpm.search.ProcessInstanceSearchServiceBase;
import org.kie.server.services.jbpm.search.TaskSearchServiceBase;

public class JbpmSearchRestApplicationComponentsService
implements KieServerApplicationComponentsService {
    private static final String OWNER_EXTENSION = "jBPMSearch";

    public Collection<Object> getAppComponents(String extension, SupportedTransports type, Object ... services) {
        if (!OWNER_EXTENSION.equals(extension)) {
            return Collections.emptyList();
        }
        KieServerRegistry context = null;
        QueryService queryService = null;
        for (Object object : services) {
            if (object == null) continue;
            if (QueryService.class.isAssignableFrom(object.getClass())) {
                queryService = (QueryService)object;
                continue;
            }
            if (!KieServerRegistry.class.isAssignableFrom(object.getClass())) continue;
            context = (KieServerRegistry)object;
        }
        if (queryService == null) {
            throw new IllegalStateException("No QueryService found. Unable to bootstrap jBPM TaskQuery Extension.");
        }
        ProcessInstanceSearchServiceBase processInstanceQueryServiceBase = new ProcessInstanceSearchServiceBase(queryService, context);
        TaskSearchServiceBase taskQueryServiceBase = new TaskSearchServiceBase(queryService, context);
        ArrayList<Object> components = new ArrayList<Object>(1);
        components.add(new ProcessInstanceSearchResource(processInstanceQueryServiceBase, context));
        components.add(new TaskSearchResource(taskQueryServiceBase, context));
        return components;
    }
}

