/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.jbpm.search;

import javax.ws.rs.DefaultValue;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.kie.server.api.model.instance.TaskInstanceList;
import org.kie.server.remote.rest.common.Header;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.jbpm.search.TaskSearchServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="server/tasks/instances/filtered-data")
public class TaskSearchResource {
    private static final Logger logger = LoggerFactory.getLogger(TaskSearchResource.class);
    private TaskSearchServiceBase taskQueryServiceBase;
    private KieServerRegistry context;

    public TaskSearchResource() {
    }

    public TaskSearchResource(TaskSearchServiceBase taskQueryServiceBase, KieServerRegistry context) {
        this.taskQueryServiceBase = taskQueryServiceBase;
        this.context = context;
    }

    @POST
    @Produces(value={"application/xml", "application/json"})
    public Response getHumanTasksWithFilters(@Context HttpHeaders headers, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, String payload) {
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        TaskInstanceList result = this.taskQueryServiceBase.getHumanTasksWithFilters(page, pageSize, payload, type);
        logger.debug("Returning result of task instance search: {}", (Object)result);
        return RestUtils.createCorrectVariant((Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
    }
}

