/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.jbpm.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.kie.server.remote.rest.jbpm.search.ProcessInstanceSearchResource;
import org.kie.server.remote.rest.jbpm.search.TaskSearchResource;
import org.kie.server.services.api.KieServerApplicationComponentsService;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.api.SupportedTransports;
import org.kie.server.services.jbpm.search.ProcessInstanceSearchServiceBase;
import org.kie.server.services.jbpm.search.TaskSearchServiceBase;

public class JbpmSearchRestApplicationComponentsService
implements KieServerApplicationComponentsService {
    private static final String OWNER_EXTENSION = "jBPMSearch";

    public Collection<Object> getAppComponents(String extension, SupportedTransports type, Object ... services) {
        if (!OWNER_EXTENSION.equals(extension)) {
            return Collections.emptyList();
        }
        KieServerRegistry context = null;
        ProcessInstanceSearchServiceBase processInstanceQueryServiceBase = null;
        TaskSearchServiceBase taskQueryServiceBase = null;
        for (Object object : services) {
            if (object == null) continue;
            if (ProcessInstanceSearchServiceBase.class.isAssignableFrom(object.getClass())) {
                processInstanceQueryServiceBase = (ProcessInstanceSearchServiceBase)object;
                continue;
            }
            if (TaskSearchServiceBase.class.isAssignableFrom(object.getClass())) {
                taskQueryServiceBase = (TaskSearchServiceBase)object;
                continue;
            }
            if (!KieServerRegistry.class.isAssignableFrom(object.getClass())) continue;
            context = (KieServerRegistry)object;
        }
        if (processInstanceQueryServiceBase == null || taskQueryServiceBase == null) {
            throw new IllegalStateException("No QueryService found. Unable to bootstrap jBPM TaskQuery Extension.");
        }
        ArrayList<Object> components = new ArrayList<Object>(1);
        components.add(new ProcessInstanceSearchResource(processInstanceQueryServiceBase, context));
        components.add(new TaskSearchResource(taskQueryServiceBase, context));
        return components;
    }
}

