/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.jbpm.ui;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.text.MessageFormat;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.apache.commons.lang3.StringUtils;
import org.jbpm.services.api.DeploymentNotFoundException;
import org.jbpm.services.api.ProcessDefinitionNotFoundException;
import org.jbpm.services.api.TaskNotFoundException;
import org.jbpm.services.task.exception.PermissionDeniedException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;
import org.kie.server.remote.rest.common.Header;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.jbpm.ui.FormRendererBase;
import org.kie.server.services.jbpm.ui.FormServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="Process and task forms :: BPM")
@Path(value="server/containers/{id}/forms")
public class FormResource {
    private static final Logger logger = LoggerFactory.getLogger(FormResource.class);
    private static int PRETTY_PRINT_INDENT_FACTOR = 4;
    public static final String CONTAINER_NOT_FOUND = "Could not find container \"{0}\"";
    public static final String PROCESS_DEFINITION_NOT_FOUND = "Could not find process definition \"{0}\" in container \"{1}\"";
    public static final String TASK_PERMISSION_ERROR = "User has no permission to see task instance with id \"{0}\"";
    public static final String TASK_INSTANCE_NOT_FOUND = "Could not find task instance with id \"{0}\"";
    private FormServiceBase formServiceBase;
    private FormRendererBase formRendererBase;
    private KieServerRegistry context;

    public FormResource() {
    }

    public FormResource(FormServiceBase formServiceBase, FormRendererBase formRendererBase, KieServerRegistry context) {
        this.formServiceBase = formServiceBase;
        this.formRendererBase = formRendererBase;
        this.context = context;
    }

    @ApiOperation(value="Retrieves form for process definition within a container", response=String.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process definition, form or Container Id not found")})
    @GET
    @Path(value="processes/{pId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getProcessForm(@Context HttpHeaders headers, @ApiParam(value="container id that process definition belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of process definition that form should be fetched for", required=true) @PathParam(value="pId") String processId, @ApiParam(value="optional language that the form should be found for", required=false) @QueryParam(value="lang") @DefaultValue(value="en") String language, @ApiParam(value="optional filter flag if form should be filtered or returned as is", required=false) @QueryParam(value="filter") boolean filter, @ApiParam(value="optional type of the form, defaults to ANY so system will find the most current one", required=false) @QueryParam(value="type") @DefaultValue(value="ANY") String formType, @ApiParam(value="optional marshall content flag if the content should be transformed or not, defaults to true", required=false) @QueryParam(value="marshallContent") @DefaultValue(value="true") boolean marshallContent) {
        Variant variant = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String response = this.formServiceBase.getFormDisplayProcess(containerId, processId, language, filter, formType);
            if (marshallContent) {
                response = this.marshallFormContent(response, formType, variant);
            }
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)variant, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format(CONTAINER_NOT_FOUND, containerId), (Variant)variant, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessDefinitionNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format(PROCESS_DEFINITION_NOT_FOUND, processId, containerId), (Variant)variant, (Header[])new Header[]{conversationIdHeader});
        }
        catch (IllegalStateException e) {
            return RestUtils.notFound((String)("Form for process id " + processId + " not found"), (Variant)variant, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error encountered", e.getMessage()), (Variant)variant, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retrieves form for task instance within a container", response=String.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task, form or Container Id not found")})
    @GET
    @Path(value="tasks/{tInstanceId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getTaskForm(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of task instance that form should be fetched for", required=true) @PathParam(value="tInstanceId") Long taskId, @ApiParam(value="optional language that the form should be found for", required=false) @QueryParam(value="lang") @DefaultValue(value="en") String language, @ApiParam(value="optional filter flag if form should be filtered or returned as is", required=false) @QueryParam(value="filter") boolean filter, @ApiParam(value="optional type of the form, defaults to ANY so system will find the most current one", required=false) @QueryParam(value="type") @DefaultValue(value="ANY") String formType, @ApiParam(value="optional marshall content flag if the content should be transformed or not, defaults to true", required=false) @QueryParam(value="marshallContent") @DefaultValue(value="true") boolean marshallContent) {
        Variant variant = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String response = this.formServiceBase.getFormDisplayTask(containerId, taskId.longValue(), language, filter, formType);
            if (marshallContent) {
                response = this.marshallFormContent(response, formType, variant);
            }
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)variant, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (PermissionDeniedException e) {
            return RestUtils.permissionDenied((String)MessageFormat.format(TASK_PERMISSION_ERROR, taskId), (Variant)variant, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format(TASK_INSTANCE_NOT_FOUND, taskId), (Variant)variant, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format(CONTAINER_NOT_FOUND, containerId), (Variant)variant, (Header[])new Header[]{conversationIdHeader});
        }
        catch (IllegalStateException e) {
            return RestUtils.notFound((String)("Form for task id " + taskId + " not found"), (Variant)variant, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error encountered", e.getMessage()), (Variant)variant, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retrieves form for process definition within a container that is completely rendered and ready for use", response=String.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process, form or Container Id not found")})
    @GET
    @Path(value="processes/{pId}/content")
    @Produces(value={"text/html"})
    public Response getProcessRenderedForm(@Context HttpHeaders headers, @ApiParam(value="container id that process definition belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of process definition that form should be fetched for", required=true) @PathParam(value="pId") String processId, @ApiParam(value="optional renderer name that the form should be rendered with", required=false) @QueryParam(value="renderer") @DefaultValue(value="patternfly") String renderer) {
        Variant variant = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String renderedForm = this.formRendererBase.getProcessRenderedForm(renderer, containerId, processId);
            if (renderedForm == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.ok().entity((Object)renderedForm).build();
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format(CONTAINER_NOT_FOUND, containerId), (Variant)variant, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessDefinitionNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format(PROCESS_DEFINITION_NOT_FOUND, processId, containerId), (Variant)variant, (Header[])new Header[]{conversationIdHeader});
        }
        catch (IllegalArgumentException e) {
            return RestUtils.notFound((String)e.getMessage(), (Variant)variant, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error encountered", e.getMessage()), (Variant)variant, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retrieves form for task instance within a container that is completely rendered and ready for use", response=String.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task, form or Container Id not found")})
    @GET
    @Path(value="tasks/{tInstanceId}/content")
    @Produces(value={"text/html"})
    public Response getTaskRenderedForm(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of task instance that form should be fetched for", required=true) @PathParam(value="tInstanceId") Long taskId, @ApiParam(value="optional renderer name that the form should be rendered with", required=false) @QueryParam(value="renderer") @DefaultValue(value="patternfly") String renderer) {
        Variant variant = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String renderedForm = this.formRendererBase.getTaskRenderedForm(renderer, containerId, taskId.longValue());
            if (renderedForm == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.ok().entity((Object)renderedForm).build();
        }
        catch (PermissionDeniedException e) {
            return RestUtils.permissionDenied((String)MessageFormat.format(TASK_PERMISSION_ERROR, taskId), (Variant)variant, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format(TASK_INSTANCE_NOT_FOUND, taskId), (Variant)variant, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format(CONTAINER_NOT_FOUND, containerId), (Variant)variant, (Header[])new Header[]{conversationIdHeader});
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            return RestUtils.notFound((String)e.getMessage(), (Variant)variant, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error encountered", e.getMessage()), (Variant)variant, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Retrieves form for case definition within a container that is completely rendered and ready for use", response=String.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Case, form or Container Id not found")})
    @GET
    @Path(value="cases/{caseDefId}/content")
    @Produces(value={"text/html"})
    public Response getCaseRenderedForm(@Context HttpHeaders headers, @ApiParam(value="container id that case definition belongs to", required=true) @PathParam(value="id") String containerId, @ApiParam(value="identifier of case definition that form should be fetched for", required=true) @PathParam(value="caseDefId") String caseDefId, @ApiParam(value="optional renderer name that the form should be rendered with", required=false) @QueryParam(value="renderer") @DefaultValue(value="patternfly") String renderer) {
        Variant variant = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String renderedForm = this.formRendererBase.getCaseRenderedForm(renderer, containerId, caseDefId);
            if (renderedForm == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.ok().entity((Object)renderedForm).build();
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format(CONTAINER_NOT_FOUND, containerId), (Variant)variant, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessDefinitionNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format(PROCESS_DEFINITION_NOT_FOUND, caseDefId, containerId), (Variant)variant, (Header[])new Header[]{conversationIdHeader});
        }
        catch (IllegalArgumentException e) {
            return RestUtils.notFound((String)e.getMessage(), (Variant)variant, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error encountered", e.getMessage()), (Variant)variant, (Header[])new Header[]{conversationIdHeader});
        }
    }

    protected String marshallFormContent(String formContent, String formType, Variant variant) throws Exception {
        if (StringUtils.isEmpty((CharSequence)formContent)) {
            return formContent;
        }
        FormServiceBase.FormType actualFormType = FormServiceBase.FormType.fromName((String)formType);
        String actualContentType = actualFormType.getContentType();
        if (actualContentType == null) {
            actualContentType = this.getMediaTypeForFormContent(formContent);
        }
        if (variant.getMediaType().equals((Object)MediaType.APPLICATION_JSON_TYPE) && !MediaType.APPLICATION_JSON_TYPE.getSubtype().equals(actualContentType)) {
            JSONObject json = XML.toJSONObject((String)formContent);
            this.formatJSONResponse(json);
            formContent = json.toString(PRETTY_PRINT_INDENT_FACTOR);
        } else if (variant.getMediaType().equals((Object)MediaType.APPLICATION_XML_TYPE) && !MediaType.APPLICATION_XML_TYPE.getSubtype().equals(actualContentType)) {
            Object json = this.parseToJSON(formContent);
            formContent = XML.toString((Object)json);
        }
        return formContent;
    }

    protected String getMediaTypeForFormContent(String contentType) {
        if (contentType != null) {
            if (contentType.startsWith("{") || contentType.startsWith("[")) {
                return MediaType.APPLICATION_JSON_TYPE.getSubtype();
            }
            if (contentType.startsWith("<")) {
                return MediaType.APPLICATION_XML_TYPE.getSubtype();
            }
        }
        return null;
    }

    private void formatJSONResponse(JSONObject json) {
        try {
            JSONObject form = json.getJSONObject("form");
            this.putPropertyArrayToObject(form);
            Object fields = form.get("field");
            if (fields instanceof JSONArray) {
                for (int i = 0; i < ((JSONArray)fields).length(); ++i) {
                    JSONObject field = ((JSONArray)fields).getJSONObject(i);
                    this.putPropertyArrayToObject(field);
                }
            } else {
                this.putPropertyArrayToObject((JSONObject)fields);
            }
        }
        catch (JSONException e) {
            logger.debug("exception while formatting :: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void putPropertyArrayToObject(JSONObject obj) throws JSONException {
        JSONArray properties = obj.getJSONArray("property");
        for (int j = 0; j < properties.length(); ++j) {
            JSONObject property = properties.getJSONObject(j);
            obj.put(property.getString("name"), property.get("value"));
        }
        obj.remove("property");
    }

    private Object parseToJSON(String content) throws JSONException {
        try {
            return new JSONArray(content);
        }
        catch (JSONException e) {
            return new JSONObject(content);
        }
    }
}

