/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.jbpm.ui;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.io.IOUtils;
import org.kie.server.services.jbpm.ui.FormRendererBase;

@Api(value="Static files endpoint :: BPM")
@Path(value="server/files")
public class StaticFilesResource {
    private FormRendererBase formRendererBase;

    public StaticFilesResource(FormRendererBase formRendererBase) {
        this.formRendererBase = formRendererBase;
    }

    @ApiOperation(value="Retrieves given resource/file based on the type and file name", response=String.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="resource/file not found")})
    @GET
    @Path(value="{type}/{file}")
    public Response getSharedContent(@ApiParam(value="Type of the resource e.g. js, css, etc", required=true) @PathParam(value="type") String type, @ApiParam(value="Name of the resource to look up", required=true) @PathParam(value="file") String file) {
        final InputStream resourceStream = this.formRendererBase.readResources("/" + type + "/" + file);
        if (resourceStream == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        StreamingOutput entity = new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                IOUtils.copy((InputStream)resourceStream, (OutputStream)output);
            }
        };
        Response.ResponseBuilder builder = Response.ok().entity((Object)entity);
        this.setHeaders(builder);
        return builder.header("Content-Type", (Object)this.getContentType(file)).build();
    }

    @ApiOperation(value="Retrieves given resource/file based on the type and file name managed by given provider", response=String.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="resource/file not found")})
    @GET
    @Path(value="{provider}/{type}/{file}")
    public Response getProviderSpecificContent(@ApiParam(value="Name of the provider that manages given resource", required=true) @PathParam(value="provider") String provider, @ApiParam(value="Type of the resource e.g. js, css, etc", required=true) @PathParam(value="type") String type, @ApiParam(value="Name of the resource to look up", required=true) @PathParam(value="file") String file) {
        final InputStream resourceStream = this.formRendererBase.readResources("/" + provider + "/" + type + "/" + file);
        if (resourceStream == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        StreamingOutput entity = new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                IOUtils.copy((InputStream)resourceStream, (OutputStream)output);
            }
        };
        Response.ResponseBuilder builder = Response.ok().entity((Object)entity);
        this.setHeaders(builder);
        return builder.header("Content-Type", (Object)this.getContentType(file)).build();
    }

    protected void setHeaders(Response.ResponseBuilder builder) {
        builder.header("Access-Control-Allow-Origin", (Object)"*").header("Access-Control-Allow-Methods", (Object)"GET, POST, OPTIONS, PUT").header("Access-Control-Allow-Headers", (Object)"accept, authorization, content-type, x-requested-with").header("Access-Control-Allow-Credentials", (Object)"true").header("Access-Control-Max-Age", (Object)"1");
    }

    protected String getContentType(String file) {
        if (file.toLowerCase().endsWith(".js")) {
            return "application/javascript";
        }
        if (file.toLowerCase().endsWith(".css")) {
            return "text/css";
        }
        return "application/octet-stream";
    }
}

