/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.jbpm;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.jbpm.services.api.DefinitionService;
import org.jbpm.services.api.model.ProcessDefinition;
import org.kie.server.api.model.definition.AssociatedEntitiesDefinition;
import org.kie.server.api.model.definition.ServiceTasksDefinition;
import org.kie.server.api.model.definition.SubProcessesDefinition;
import org.kie.server.api.model.definition.TaskInputsDefinition;
import org.kie.server.api.model.definition.TaskOutputsDefinition;
import org.kie.server.api.model.definition.UserTaskDefinition;
import org.kie.server.api.model.definition.UserTaskDefinitionList;
import org.kie.server.api.model.definition.VariablesDefinition;
import org.kie.server.remote.rest.common.exception.ExecutionServerRestOperationException;
import org.kie.server.remote.rest.common.util.RestUtils;

@Path(value="/server")
public class DefinitionResource {
    private DefinitionService definitionService;

    public DefinitionResource(DefinitionService definitionService) {
        this.definitionService = definitionService;
    }

    @GET
    @Path(value="containers/{id}/process/definition/{pId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getProcessDefinition(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="pId") String processId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            ProcessDefinition procDef = this.findProcessDefinition(containerId, processId, v);
            org.kie.server.api.model.definition.ProcessDefinition responseObject = org.kie.server.api.model.definition.ProcessDefinition.builder().id(procDef.getId()).name(procDef.getName()).version(procDef.getVersion()).packageName(procDef.getPackageName()).containerId(procDef.getDeploymentId()).entitiesAsCollection(procDef.getAssociatedEntities()).serviceTasks(procDef.getServiceTasks()).subprocesses(procDef.getReusableSubProcesses()).variables(procDef.getProcessVariables()).build();
            return RestUtils.createCorrectVariant((Object)responseObject, (HttpHeaders)headers, (Response.Status)Response.Status.OK);
        }
        catch (Exception e) {
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Path(value="containers/{id}/process/definition/{pId}/subprocesses")
    @Produces(value={"application/xml", "application/json"})
    public Response getReusableSubProcesses(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="pId") String processId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            this.findProcessDefinition(containerId, processId, v);
            Collection reusableSubProcesses = this.definitionService.getReusableSubProcesses(containerId, processId);
            return RestUtils.createCorrectVariant((Object)new SubProcessesDefinition(reusableSubProcesses), (HttpHeaders)headers, (Response.Status)Response.Status.OK);
        }
        catch (Exception e) {
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Path(value="containers/{id}/process/definition/{pId}/variables")
    @Produces(value={"application/xml", "application/json"})
    public Response getProcessVariables(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="pId") String processId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            this.findProcessDefinition(containerId, processId, v);
            Map processVariables = this.definitionService.getProcessVariables(containerId, processId);
            return RestUtils.createCorrectVariant((Object)new VariablesDefinition(processVariables), (HttpHeaders)headers, (Response.Status)Response.Status.OK);
        }
        catch (Exception e) {
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Path(value="containers/{id}/process/definition/{pId}/tasks/service")
    @Produces(value={"application/xml", "application/json"})
    public Response getServiceTasks(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="pId") String processId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            this.findProcessDefinition(containerId, processId, v);
            Map serviceTasks = this.definitionService.getServiceTasks(containerId, processId);
            return RestUtils.createCorrectVariant((Object)new ServiceTasksDefinition(serviceTasks), (HttpHeaders)headers, (Response.Status)Response.Status.OK);
        }
        catch (Exception e) {
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Path(value="containers/{id}/process/definition/{pId}/entities")
    @Produces(value={"application/xml", "application/json"})
    public Response getAssociatedEntities(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="pId") String processId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            this.findProcessDefinition(containerId, processId, v);
            Map entities = this.definitionService.getAssociatedEntities(containerId, processId);
            return RestUtils.createCorrectVariant((Object)AssociatedEntitiesDefinition.from((Map)entities), (HttpHeaders)headers, (Response.Status)Response.Status.OK);
        }
        catch (Exception e) {
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Path(value="containers/{id}/process/definition/{pId}/tasks/user")
    @Produces(value={"application/xml", "application/json"})
    public Response getTasksDefinitions(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="pId") String processId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            this.findProcessDefinition(containerId, processId, v);
            Collection userTaskDefinitions = this.definitionService.getTasksDefinitions(containerId, processId);
            return RestUtils.createCorrectVariant((Object)this.convert(userTaskDefinitions), (HttpHeaders)headers, (Response.Status)Response.Status.OK);
        }
        catch (Exception e) {
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Path(value="containers/{id}/process/definition/{pId}/tasks/user/{taskName}/inputs")
    @Produces(value={"application/xml", "application/json"})
    public Response getTaskInputMappings(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="pId") String processId, @PathParam(value="taskName") String taskName) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            this.findProcessDefinition(containerId, processId, v);
            Map taskInputs = this.definitionService.getTaskInputMappings(containerId, processId, taskName);
            return RestUtils.createCorrectVariant((Object)new TaskInputsDefinition(taskInputs), (HttpHeaders)headers, (Response.Status)Response.Status.OK);
        }
        catch (Exception e) {
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Path(value="containers/{id}/process/definition/{pId}/tasks/user/{taskName}/outputs")
    @Produces(value={"application/xml", "application/json"})
    public Response getTaskOutputMappings(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="pId") String processId, @PathParam(value="taskName") String taskName) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            this.findProcessDefinition(containerId, processId, v);
            Map taskOutputs = this.definitionService.getTaskOutputMappings(containerId, processId, taskName);
            return RestUtils.createCorrectVariant((Object)new TaskOutputsDefinition(taskOutputs), (HttpHeaders)headers, (Response.Status)Response.Status.OK);
        }
        catch (Exception e) {
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    protected ProcessDefinition findProcessDefinition(String containerId, String processId, Variant v) {
        try {
            ProcessDefinition procDef = this.definitionService.getProcessDefinition(containerId, processId);
            if (procDef == null) {
                throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find process definition \"{0}\" in container \"{1}\"", processId, containerId), (Variant)v);
            }
            return procDef;
        }
        catch (IllegalStateException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find process definition \"{0}\" in container \"{1}\"", processId, containerId), (Variant)v);
        }
    }

    protected UserTaskDefinitionList convert(Collection<org.jbpm.services.api.model.UserTaskDefinition> taskDefinitions) {
        UserTaskDefinition[] userTaskDefinitions = new UserTaskDefinition[taskDefinitions.size()];
        int i = 0;
        for (org.jbpm.services.api.model.UserTaskDefinition orig : taskDefinitions) {
            UserTaskDefinition definition;
            userTaskDefinitions[i] = definition = UserTaskDefinition.builder().name(orig.getName()).comment(orig.getComment()).createdBy(orig.getCreatedBy()).priority(orig.getPriority().intValue()).skippable(orig.isSkippable()).entities(orig.getAssociatedEntities().toArray(new String[orig.getAssociatedEntities().size()])).taskInputs(orig.getTaskInputMappings()).taskOutputs(orig.getTaskOutputMappings()).build();
            ++i;
        }
        return new UserTaskDefinitionList(userTaskDefinitions);
    }
}

