/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.jbpm;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.model.NodeInstanceDesc;
import org.jbpm.services.api.model.ProcessDefinition;
import org.jbpm.services.api.model.ProcessInstanceDesc;
import org.jbpm.services.api.model.UserTaskInstanceDesc;
import org.jbpm.services.api.model.VariableDesc;
import org.kie.api.task.model.Status;
import org.kie.internal.KieInternalServices;
import org.kie.internal.identity.IdentityProvider;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.process.CorrelationKeyFactory;
import org.kie.internal.query.QueryContext;
import org.kie.internal.query.QueryFilter;
import org.kie.internal.task.api.AuditTask;
import org.kie.internal.task.api.model.TaskEvent;
import org.kie.server.api.model.definition.ProcessDefinitionList;
import org.kie.server.api.model.instance.NodeInstance;
import org.kie.server.api.model.instance.NodeInstanceList;
import org.kie.server.api.model.instance.ProcessInstance;
import org.kie.server.api.model.instance.ProcessInstanceList;
import org.kie.server.api.model.instance.TaskEventInstance;
import org.kie.server.api.model.instance.TaskEventInstanceList;
import org.kie.server.api.model.instance.TaskInstance;
import org.kie.server.api.model.instance.TaskSummary;
import org.kie.server.api.model.instance.TaskSummaryList;
import org.kie.server.api.model.instance.VariableInstance;
import org.kie.server.api.model.instance.VariableInstanceList;
import org.kie.server.remote.rest.common.exception.ExecutionServerRestOperationException;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.api.KieServerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/server")
public class RuntimeDataResource {
    public static final Logger logger = LoggerFactory.getLogger(RuntimeDataResource.class);
    private static final Boolean BYPASS_AUTH_USER = Boolean.parseBoolean(System.getProperty("org.kie.server.bypass.auth.user", "false"));
    private RuntimeDataService runtimeDataService;
    private IdentityProvider identityProvider;
    private CorrelationKeyFactory correlationKeyFactory = KieInternalServices.Factory.get().newCorrelationKeyFactory();

    public RuntimeDataResource(RuntimeDataService delegate, KieServerRegistry context) {
        this.runtimeDataService = delegate;
        this.identityProvider = context.getIdentityProvider();
    }

    protected String getUser(String queryParamUser) {
        if (BYPASS_AUTH_USER.booleanValue()) {
            return queryParamUser;
        }
        return this.identityProvider.getName();
    }

    @GET
    @Path(value="process/instances")
    @Produces(value={"application/xml", "application/json"})
    public Response getProcessInstances(@Context HttpHeaders headers, @QueryParam(value="status") List<Integer> status, @QueryParam(value="initiator") String initiator, @QueryParam(value="processName") String processName, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        if (status == null || status.isEmpty()) {
            status = new ArrayList<Integer>();
            status.add(1);
        }
        Collection instances = null;
        if (processName != null && !processName.isEmpty()) {
            logger.debug("About to search for process instances with process name '{}' with page {} and page size {}", new Object[]{processName, page, pageSize});
            instances = this.runtimeDataService.getProcessInstancesByProcessName(status, processName, initiator, this.buildQueryContext(page, pageSize));
            logger.debug("Found {} process instances for process name '{}', statuses '{}'", new Object[]{instances.size(), processName, status});
        } else {
            logger.debug("About to search for process instances with page {} and page size {}", (Object)page, (Object)pageSize);
            instances = this.runtimeDataService.getProcessInstances(status, initiator, this.buildQueryContext(page, pageSize));
            logger.debug("Found {} process instances '{}', statuses '{}'", (Object)instances.size(), status);
        }
        ProcessInstanceList processInstanceList = this.convertToProcessInstanceList(instances);
        logger.debug("Returning result of process instance search: {}", (Object)processInstanceList);
        return RestUtils.createCorrectVariant((Object)processInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK);
    }

    @GET
    @Path(value="process/{pId}/instances")
    @Produces(value={"application/xml", "application/json"})
    public Response getProcessInstancesByProcessId(@Context HttpHeaders headers, @PathParam(value="pId") String processId, @QueryParam(value="status") List<Integer> status, @QueryParam(value="initiator") String initiator, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        if (status == null || status.isEmpty()) {
            status = new ArrayList<Integer>();
            status.add(1);
        }
        logger.debug("About to search for process instances with process id '{}' with page {} and page size {}", new Object[]{processId, page, pageSize});
        Collection instances = this.runtimeDataService.getProcessInstancesByProcessId(status, processId, initiator, this.buildQueryContext(page, pageSize));
        logger.debug("Found {} process instance for process id '{}', statuses '{}'", new Object[]{instances.size(), processId, status});
        ProcessInstanceList processInstanceList = this.convertToProcessInstanceList(instances);
        logger.debug("Returning result of process instance search: {}", (Object)processInstanceList);
        return RestUtils.createCorrectVariant((Object)processInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK);
    }

    @GET
    @Path(value="containers/{id}/process/instances")
    @Produces(value={"application/xml", "application/json"})
    public Response getProcessInstancesByDeploymentId(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @QueryParam(value="status") List<Integer> status, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        if (status == null || status.isEmpty()) {
            status = new ArrayList<Integer>();
            status.add(1);
        }
        logger.debug("About to search for process instance belonging to container '{}' with page {} and page size {}", new Object[]{containerId, page, pageSize});
        Collection instances = this.runtimeDataService.getProcessInstancesByDeploymentId(containerId, status, this.buildQueryContext(page, pageSize));
        logger.debug("Found {} process instance for container '{}', statuses '{}'", new Object[]{instances.size(), containerId, status});
        ProcessInstanceList processInstanceList = this.convertToProcessInstanceList(instances);
        logger.debug("Returning result of process instance search: {}", (Object)processInstanceList);
        return RestUtils.createCorrectVariant((Object)processInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK);
    }

    @GET
    @Path(value="process/instances/correlation/{correlationKey}")
    @Produces(value={"application/xml", "application/json"})
    public Response getProcessInstanceByCorrelationKey(@Context HttpHeaders headers, @PathParam(value="correlationKey") String correlationKey) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String[] correlationProperties = correlationKey.split(":");
        CorrelationKey actualCorrelationKey = this.correlationKeyFactory.newCorrelationKey(Arrays.asList(correlationProperties));
        ProcessInstanceDesc processInstanceDesc = this.runtimeDataService.getProcessInstanceByCorrelationKey(actualCorrelationKey);
        if (processInstanceDesc == null) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", correlationKey), (Variant)v);
        }
        return RestUtils.createCorrectVariant((Object)this.convertToProcessInstance(processInstanceDesc), (HttpHeaders)headers, (Response.Status)Response.Status.OK);
    }

    @GET
    @Path(value="process/instances/{pInstanceId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getProcessInstanceById(@Context HttpHeaders headers, @PathParam(value="pInstanceId") long processInstanceId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        ProcessInstanceDesc processInstanceDesc = this.runtimeDataService.getProcessInstanceById(processInstanceId);
        if (processInstanceDesc == null) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v);
        }
        return RestUtils.createCorrectVariant((Object)this.convertToProcessInstance(processInstanceDesc), (HttpHeaders)headers, (Response.Status)Response.Status.OK);
    }

    @GET
    @Path(value="process/instances/{pInstanceId}/wi-nodes/instances/{workItemId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getNodeInstanceForWorkItem(@Context HttpHeaders headers, @PathParam(value="pInstanceId") long processInstanceId, @PathParam(value="workItemId") Long workItemId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        NodeInstanceDesc nodeInstanceDesc = this.runtimeDataService.getNodeInstanceForWorkItem(workItemId);
        if (nodeInstanceDesc == null) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find node instance with id \"{0}\" within process instance with id \"{1}\"", workItemId, processInstanceId), (Variant)v);
        }
        return RestUtils.createCorrectVariant((Object)this.convertToNodeInstance(nodeInstanceDesc), (HttpHeaders)headers, (Response.Status)Response.Status.OK);
    }

    @GET
    @Path(value="process/instances/{pInstanceId}/nodes/instances")
    @Produces(value={"application/xml", "application/json"})
    public Response getProcessInstanceHistory(@Context HttpHeaders headers, @PathParam(value="pInstanceId") long processInstanceId, @QueryParam(value="activeOnly") Boolean active, @QueryParam(value="completedOnly") Boolean completed, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        Collection result;
        logger.debug("About to search for node instances with page {} and page size {}", (Object)page, (Object)pageSize);
        if (Boolean.TRUE.equals(active)) {
            logger.debug("Searching for active node instances for process instance with id {}", (Object)processInstanceId);
            result = this.runtimeDataService.getProcessInstanceHistoryActive(processInstanceId, this.buildQueryContext(page, pageSize));
        } else if (Boolean.TRUE.equals(completed)) {
            logger.debug("Searching for completed node instances for process instance with id {}", (Object)processInstanceId);
            result = this.runtimeDataService.getProcessInstanceHistoryCompleted(processInstanceId, this.buildQueryContext(page, pageSize));
        } else {
            logger.debug("Searching for active and completed node instances for process instance with id {}", (Object)processInstanceId);
            result = this.runtimeDataService.getProcessInstanceFullHistory(processInstanceId, this.buildQueryContext(page, pageSize));
        }
        NodeInstanceList nodeInstanceList = this.convertToNodeInstanceList(result);
        logger.debug("Returning result of node instances search: {}", (Object)nodeInstanceList);
        return RestUtils.createCorrectVariant((Object)nodeInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK);
    }

    @GET
    @Path(value="process/instances/{pInstanceId}/variables/instances")
    @Produces(value={"application/xml", "application/json"})
    public Response getVariablesCurrentState(@Context HttpHeaders headers, @PathParam(value="pInstanceId") long processInstanceId) {
        logger.debug("About to search for variables within process instance  '{}'", (Object)processInstanceId);
        Collection variableDescs = this.runtimeDataService.getVariablesCurrentState(processInstanceId);
        logger.debug("Found {} variables within process instance '{}'", (Object)variableDescs.size(), (Object)processInstanceId);
        VariableInstanceList variableInstanceList = this.convertToVariablesList(variableDescs);
        logger.debug("Returning result of variables search: {}", (Object)variableInstanceList);
        return RestUtils.createCorrectVariant((Object)variableInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK);
    }

    @GET
    @Path(value="process/instances/{pInstanceId}/variables/instances/{varName}")
    @Produces(value={"application/xml", "application/json"})
    public Response getVariableHistory(@Context HttpHeaders headers, @PathParam(value="pInstanceId") long processInstanceId, @PathParam(value="varName") String variableName, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        logger.debug("About to search for variable '{}; history within process instance '{}' with page {} and page size {}", new Object[]{variableName, processInstanceId, page, pageSize});
        Collection variableDescs = this.runtimeDataService.getVariableHistory(processInstanceId, variableName, this.buildQueryContext(page, pageSize));
        logger.debug("Found {} variable {} history entries within process instance '{}'", new Object[]{variableDescs.size(), variableName, processInstanceId});
        VariableInstanceList variableInstanceList = this.convertToVariablesList(variableDescs);
        logger.debug("Returning result of variable '{}; history search: {}", (Object)variableName, (Object)variableInstanceList);
        return RestUtils.createCorrectVariant((Object)variableInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK);
    }

    @GET
    @Path(value="containers/{id}/process/definitions")
    @Produces(value={"application/xml", "application/json"})
    public Response getProcessesByDeploymentId(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        logger.debug("About to search for process definitions within container '{}' with page {} and page size {}", new Object[]{containerId, page, pageSize});
        Collection definitions = this.runtimeDataService.getProcessesByDeploymentId(containerId, this.buildQueryContext(page, pageSize));
        logger.debug("Found {} process definitions within container '{}'", (Object)definitions.size(), (Object)containerId);
        ProcessDefinitionList processDefinitionList = this.convertToProcessList(definitions);
        logger.debug("Returning result of process definition search: {}", (Object)processDefinitionList);
        return RestUtils.createCorrectVariant((Object)processDefinitionList, (HttpHeaders)headers, (Response.Status)Response.Status.OK);
    }

    @GET
    @Path(value="process/definitions")
    @Produces(value={"application/xml", "application/json"})
    public Response getProcessesByFilter(@Context HttpHeaders headers, @QueryParam(value="filter") String filter, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        Collection definitions;
        if (filter != null && !filter.isEmpty()) {
            logger.debug("About to search for process definitions with filter '{}' with page {} and page size {}", new Object[]{filter, page, pageSize});
            definitions = this.runtimeDataService.getProcessesByFilter(filter, this.buildQueryContext(page, pageSize));
            logger.debug("Found {} process definitions with filter '{}'", (Object)definitions.size(), (Object)filter);
        } else {
            logger.debug("About to search for process definitions with page {} and page size {}", (Object)page, (Object)pageSize);
            definitions = this.runtimeDataService.getProcesses(this.buildQueryContext(page, pageSize));
            logger.debug("Found {} process definitions", (Object)definitions.size(), (Object)filter);
        }
        ProcessDefinitionList processDefinitionList = this.convertToProcessList(definitions);
        logger.debug("Returning result of process definition search: {}", (Object)processDefinitionList);
        return RestUtils.createCorrectVariant((Object)processDefinitionList, (HttpHeaders)headers, (Response.Status)Response.Status.OK);
    }

    @GET
    @Path(value="process/definitions/{pId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getProcessesById(@Context HttpHeaders headers, @PathParam(value="pId") String processId) {
        Collection definitions = this.runtimeDataService.getProcessesById(processId);
        ProcessDefinitionList processDefinitionList = this.convertToProcessList(definitions);
        logger.debug("Returning result of process definition search: {}", (Object)processDefinitionList);
        return RestUtils.createCorrectVariant((Object)processDefinitionList, (HttpHeaders)headers, (Response.Status)Response.Status.OK);
    }

    @GET
    @Path(value="containers/{id}/process/definitions/{pId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getProcessesByDeploymentIdProcessId(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="pId") String processId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        ProcessDefinition processDesc = this.runtimeDataService.getProcessesByDeploymentIdProcessId(containerId, processId);
        if (processDesc == null) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find process definition \"{0}\" in container \"{1}\"", processId, containerId), (Variant)v);
        }
        return RestUtils.createCorrectVariant((Object)this.convertToProcess(processDesc), (HttpHeaders)headers, (Response.Status)Response.Status.OK);
    }

    @GET
    @Path(value="task/instances/workitem/{workItemId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getTaskByWorkItemId(@Context HttpHeaders headers, @PathParam(value="workItemId") Long workItemId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        UserTaskInstanceDesc userTaskDesc = this.runtimeDataService.getTaskByWorkItemId(workItemId);
        if (userTaskDesc == null) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance for work item with id \"{0}\"", workItemId), (Variant)v);
        }
        return RestUtils.createCorrectVariant((Object)this.convertToTask(userTaskDesc), (HttpHeaders)headers, (Response.Status)Response.Status.OK);
    }

    @GET
    @Path(value="task/instances/{tInstanceId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getTaskById(@Context HttpHeaders headers, @PathParam(value="tInstanceId") Long taskId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        UserTaskInstanceDesc userTaskDesc = this.runtimeDataService.getTaskById(taskId);
        if (userTaskDesc == null) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v);
        }
        return RestUtils.createCorrectVariant((Object)this.convertToTask(userTaskDesc), (HttpHeaders)headers, (Response.Status)Response.Status.OK);
    }

    @GET
    @Path(value="task/instances/admins")
    @Produces(value={"application/xml", "application/json"})
    public Response getTasksAssignedAsBusinessAdministratorByStatus(@Context HttpHeaders headers, @QueryParam(value="status") List<String> status, @QueryParam(value="user") String userId, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            List tasks;
            userId = this.getUser(userId);
            logger.debug("About to search for task assigned as business admin for user '{}'", (Object)userId);
            if (status == null || status.isEmpty()) {
                tasks = this.runtimeDataService.getTasksAssignedAsBusinessAdministrator(userId, this.buildQueryFilter(page, pageSize));
            } else {
                List<Status> taskStatuses = this.buildTaskStatuses(status);
                tasks = this.runtimeDataService.getTasksAssignedAsBusinessAdministratorByStatus(userId, taskStatuses, this.buildQueryFilter(page, pageSize));
            }
            logger.debug("Found {} tasks for user '{}' assigned as business admin", (Object)tasks.size(), (Object)userId);
            TaskSummaryList result = this.convertToTaskSummaryList(tasks);
            return RestUtils.createCorrectVariant((Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Path(value="task/instances/pot-owners")
    @Produces(value={"application/xml", "application/json"})
    public Response getTasksAssignedAsPotentialOwner(@Context HttpHeaders headers, @QueryParam(value="status") List<String> status, @QueryParam(value="groups") List<String> groupIds, @QueryParam(value="user") String userId, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            List<Status> taskStatuses = this.buildTaskStatuses(status);
            userId = this.getUser(userId);
            logger.debug("About to search for task assigned as potential owner for user '{}'", (Object)userId);
            List tasks = groupIds != null && !groupIds.isEmpty() ? (taskStatuses == null ? this.runtimeDataService.getTasksAssignedAsPotentialOwner(userId, groupIds, this.buildQueryFilter(page, pageSize)) : this.runtimeDataService.getTasksAssignedAsPotentialOwner(userId, groupIds, taskStatuses, this.buildQueryFilter(page, pageSize))) : (taskStatuses != null ? this.runtimeDataService.getTasksAssignedAsPotentialOwnerByStatus(userId, taskStatuses, this.buildQueryFilter(page, pageSize)) : this.runtimeDataService.getTasksAssignedAsPotentialOwner(userId, this.buildQueryFilter(page, pageSize)));
            logger.debug("Found {} tasks for user '{}' assigned as potential owner", (Object)tasks.size(), (Object)userId);
            TaskSummaryList result = this.convertToTaskSummaryList(tasks);
            return RestUtils.createCorrectVariant((Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Path(value="task/instances/owners")
    @Produces(value={"application/xml", "application/json"})
    public Response getTasksOwnedByStatus(@Context HttpHeaders headers, @QueryParam(value="status") List<String> status, @QueryParam(value="user") String userId, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            List<Status> taskStatuses = this.buildTaskStatuses(status);
            userId = this.getUser(userId);
            logger.debug("About to search for task owned user '{}'", (Object)userId);
            List tasks = taskStatuses != null ? this.runtimeDataService.getTasksOwnedByStatus(userId, taskStatuses, this.buildQueryFilter(page, pageSize)) : this.runtimeDataService.getTasksOwned(userId, this.buildQueryFilter(page, pageSize));
            logger.debug("Found {} tasks owned by user '{}'", (Object)tasks.size(), (Object)userId);
            TaskSummaryList result = this.convertToTaskSummaryList(tasks);
            return RestUtils.createCorrectVariant((Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Path(value="task/instances/process/{pInstanceId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getTasksByStatusByProcessInstanceId(@Context HttpHeaders headers, @PathParam(value="pInstanceId") Long processInstanceId, @QueryParam(value="status") List<String> status, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            List<Status> taskStatuses = this.buildTaskStatuses(status);
            if (taskStatuses == null) {
                taskStatuses = new ArrayList<Status>();
                taskStatuses.add(Status.Ready);
                taskStatuses.add(Status.Reserved);
                taskStatuses.add(Status.InProgress);
            }
            logger.debug("About to search for tasks attached to process instance with id '{}'", (Object)processInstanceId);
            List tasks = this.runtimeDataService.getTasksByStatusByProcessInstanceId(processInstanceId, taskStatuses, this.buildQueryFilter(page, pageSize));
            logger.debug("Found {} tasks attached to process instance with id '{}'", (Object)tasks.size(), (Object)processInstanceId);
            TaskSummaryList result = this.convertToTaskSummaryList(tasks);
            return RestUtils.createCorrectVariant((Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Path(value="task/instances")
    @Produces(value={"application/xml", "application/json"})
    public Response getAllAuditTask(@Context HttpHeaders headers, @QueryParam(value="user") String userId, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            userId = this.getUser(userId);
            logger.debug("About to search for tasks available for user '{}'", (Object)userId);
            List tasks = this.runtimeDataService.getAllAuditTask(userId, this.buildQueryFilter(page, pageSize));
            logger.debug("Found {} tasks available for user '{}'", (Object)tasks.size(), (Object)userId);
            TaskSummaryList result = null;
            if (tasks == null) {
                result = new TaskSummaryList(new TaskSummary[0]);
            } else {
                TaskSummary[] instances = new TaskSummary[tasks.size()];
                int counter = 0;
                for (AuditTask taskSummary : tasks) {
                    TaskSummary task;
                    instances[counter] = task = TaskSummary.builder().id(Long.valueOf(taskSummary.getTaskId())).name(taskSummary.getName()).description(taskSummary.getDescription()).taskParentId(Long.valueOf(taskSummary.getParentId())).activationTime(taskSummary.getActivationTime()).actualOwner(taskSummary.getActualOwner()).containerId(taskSummary.getDeploymentId()).createdBy(taskSummary.getCreatedBy()).createdOn(taskSummary.getCreatedOn()).expirationTime(taskSummary.getDueDate()).priority(Integer.valueOf(taskSummary.getPriority())).processId(taskSummary.getProcessId()).processInstanceId(Long.valueOf(taskSummary.getProcessInstanceId())).status(taskSummary.getStatus()).build();
                    ++counter;
                }
                result = new TaskSummaryList(instances);
            }
            return RestUtils.createCorrectVariant((Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Path(value="task/instances/{tInstanceId}/events")
    @Produces(value={"application/xml", "application/json"})
    public Response getTaskEvents(@Context HttpHeaders headers, @PathParam(value="tInstanceId") Long taskId, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            logger.debug("About to search for task {} events", (Object)taskId);
            List tasks = this.runtimeDataService.getTaskEvents(taskId.longValue(), this.buildQueryFilter(page, pageSize));
            logger.debug("Found {} task events available for task '{}'", (Object)tasks.size(), (Object)taskId);
            TaskEventInstanceList result = null;
            if (tasks == null) {
                result = new TaskEventInstanceList(new TaskEventInstance[0]);
            } else {
                TaskEventInstance[] instances = new TaskEventInstance[tasks.size()];
                int counter = 0;
                for (TaskEvent taskSummary : tasks) {
                    TaskEventInstance task;
                    instances[counter] = task = TaskEventInstance.builder().id(Long.valueOf(taskSummary.getTaskId())).taskId(Long.valueOf(taskSummary.getTaskId())).date(taskSummary.getLogTime()).processInstanceId(taskSummary.getProcessInstanceId()).type(taskSummary.getType().toString()).user(taskSummary.getUserId()).workItemId(taskSummary.getWorkItemId()).build();
                    ++counter;
                }
                result = new TaskEventInstanceList(instances);
            }
            return RestUtils.createCorrectVariant((Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    protected ProcessInstanceList convertToProcessInstanceList(Collection<ProcessInstanceDesc> instances) {
        if (instances == null) {
            return new ProcessInstanceList(new ProcessInstance[0]);
        }
        ArrayList<ProcessInstance> processInstances = new ArrayList<ProcessInstance>(instances.size());
        for (ProcessInstanceDesc pi : instances) {
            ProcessInstance instance = this.convertToProcessInstance(pi);
            processInstances.add(instance);
        }
        return new ProcessInstanceList(processInstances);
    }

    protected ProcessInstance convertToProcessInstance(ProcessInstanceDesc pi) {
        ProcessInstance instance = ProcessInstance.builder().id(pi.getId()).processId(pi.getProcessId()).processName(pi.getProcessName()).processVersion(pi.getProcessVersion()).containerId(pi.getDeploymentId()).processInstanceDescription(pi.getProcessInstanceDescription()).correlationKey(pi.getCorrelationKey()).parentInstanceId(pi.getParentId()).date(pi.getDataTimeStamp()).initiator(pi.getInitiator()).state(pi.getState()).build();
        if (pi.getActiveTasks() != null && !pi.getActiveTasks().isEmpty()) {
            TaskSummary[] tasks = new TaskSummary[pi.getActiveTasks().size()];
            int counter = 0;
            for (UserTaskInstanceDesc taskSummary : pi.getActiveTasks()) {
                TaskSummary task;
                tasks[counter] = task = TaskSummary.builder().id(taskSummary.getTaskId()).name(taskSummary.getName()).description(taskSummary.getDescription()).activationTime(taskSummary.getActivationTime()).actualOwner(taskSummary.getActualOwner()).containerId(taskSummary.getDeploymentId()).createdBy(taskSummary.getCreatedBy()).createdOn(taskSummary.getCreatedOn()).priority(taskSummary.getPriority()).processId(taskSummary.getProcessId()).processInstanceId(taskSummary.getProcessInstanceId()).build();
                ++counter;
            }
            instance.setActiveUserTasks(new TaskSummaryList(tasks));
        }
        return instance;
    }

    protected ProcessDefinitionList convertToProcessList(Collection<ProcessDefinition> definitions) {
        if (definitions == null) {
            return new ProcessDefinitionList(new org.kie.server.api.model.definition.ProcessDefinition[0]);
        }
        ArrayList<org.kie.server.api.model.definition.ProcessDefinition> processes = new ArrayList<org.kie.server.api.model.definition.ProcessDefinition>(definitions.size());
        for (ProcessDefinition pd : definitions) {
            org.kie.server.api.model.definition.ProcessDefinition definition = this.convertToProcess(pd);
            processes.add(definition);
        }
        return new ProcessDefinitionList(processes);
    }

    protected org.kie.server.api.model.definition.ProcessDefinition convertToProcess(ProcessDefinition processDesc) {
        org.kie.server.api.model.definition.ProcessDefinition processDefinition = org.kie.server.api.model.definition.ProcessDefinition.builder().id(processDesc.getId()).name(processDesc.getName()).packageName(processDesc.getPackageName()).version(processDesc.getVersion()).containerId(processDesc.getDeploymentId()).build();
        return processDefinition;
    }

    protected QueryContext buildQueryContext(Integer page, Integer pageSize) {
        return new QueryContext(Integer.valueOf(page * pageSize), pageSize);
    }

    protected QueryFilter buildQueryFilter(Integer page, Integer pageSize) {
        return new QueryFilter(page * pageSize, pageSize.intValue());
    }

    protected List<Status> buildTaskStatuses(List<String> status) {
        if (status == null || status.isEmpty()) {
            return null;
        }
        ArrayList<Status> taskStatuses = new ArrayList<Status>();
        for (String s : status) {
            taskStatuses.add(Status.valueOf((String)s));
        }
        return taskStatuses;
    }

    protected NodeInstance convertToNodeInstance(NodeInstanceDesc nodeInstanceDesc) {
        NodeInstance nodeInstance = NodeInstance.builder().id(nodeInstanceDesc.getId()).name(nodeInstanceDesc.getName()).nodeId(nodeInstanceDesc.getNodeId()).nodeType(nodeInstanceDesc.getNodeType()).processInstanceId(nodeInstanceDesc.getProcessInstanceId()).containerId(nodeInstanceDesc.getDeploymentId()).workItemId(nodeInstanceDesc.getWorkItemId()).completed(Boolean.valueOf(nodeInstanceDesc.isCompleted())).connection(nodeInstanceDesc.getConnection()).date(nodeInstanceDesc.getDataTimeStamp()).build();
        return nodeInstance;
    }

    protected NodeInstanceList convertToNodeInstanceList(Collection<NodeInstanceDesc> definitions) {
        if (definitions == null) {
            return new NodeInstanceList(new NodeInstance[0]);
        }
        ArrayList<NodeInstance> processes = new ArrayList<NodeInstance>(definitions.size());
        for (NodeInstanceDesc ni : definitions) {
            NodeInstance nodeInstance = this.convertToNodeInstance(ni);
            processes.add(nodeInstance);
        }
        return new NodeInstanceList(processes);
    }

    protected VariableInstance convertToVariable(VariableDesc variableDesc) {
        VariableInstance instance = VariableInstance.builder().name(variableDesc.getVariableId()).processInstanceId(variableDesc.getProcessInstanceId()).value(variableDesc.getNewValue()).oldValue(variableDesc.getOldValue()).date(variableDesc.getDataTimeStamp()).build();
        return instance;
    }

    protected VariableInstanceList convertToVariablesList(Collection<VariableDesc> variables) {
        if (variables == null) {
            return new VariableInstanceList(new VariableInstance[0]);
        }
        ArrayList<VariableInstance> processes = new ArrayList<VariableInstance>(variables.size());
        for (VariableDesc vi : variables) {
            VariableInstance nodeInstance = this.convertToVariable(vi);
            processes.add(nodeInstance);
        }
        return new VariableInstanceList(processes);
    }

    protected TaskInstance convertToTask(UserTaskInstanceDesc userTask) {
        TaskInstance instance = TaskInstance.builder().id(userTask.getTaskId()).name(userTask.getName()).processInstanceId(userTask.getProcessInstanceId()).processId(userTask.getProcessId()).activationTime(userTask.getActivationTime()).actualOwner(userTask.getActualOwner()).containerId(userTask.getDeploymentId()).createdBy(userTask.getCreatedBy()).createdOn(userTask.getCreatedOn()).description(userTask.getDescription()).expirationTime(userTask.getDueDate()).status(userTask.getStatus()).priority(userTask.getPriority()).build();
        return instance;
    }

    protected TaskSummaryList convertToTaskSummaryList(Collection<org.kie.api.task.model.TaskSummary> tasks) {
        if (tasks == null) {
            return new TaskSummaryList(new TaskSummary[0]);
        }
        TaskSummary[] instances = new TaskSummary[tasks.size()];
        int counter = 0;
        for (org.kie.api.task.model.TaskSummary taskSummary : tasks) {
            instances[counter] = this.convertToTaskSummary(taskSummary);
            ++counter;
        }
        return new TaskSummaryList(instances);
    }

    protected TaskSummary convertToTaskSummary(org.kie.api.task.model.TaskSummary taskSummary) {
        TaskSummary task = TaskSummary.builder().id(taskSummary.getId()).name(taskSummary.getName()).description(taskSummary.getDescription()).subject(taskSummary.getSubject()).taskParentId(taskSummary.getParentId()).activationTime(taskSummary.getActivationTime()).actualOwner(taskSummary.getActualOwnerId()).containerId(taskSummary.getDeploymentId()).createdBy(taskSummary.getCreatedById()).createdOn(taskSummary.getCreatedOn()).expirationTime(taskSummary.getExpirationTime()).priority(taskSummary.getPriority()).processId(taskSummary.getProcessId()).processInstanceId(taskSummary.getProcessInstanceId()).status(taskSummary.getStatusId()).skipable(taskSummary.isSkipable().booleanValue()).build();
        return task;
    }
}

