/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.jbpm;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.drools.core.process.instance.WorkItem;
import org.jbpm.services.api.DefinitionService;
import org.jbpm.services.api.DeploymentNotFoundException;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.jbpm.services.api.ProcessService;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.model.ProcessDefinition;
import org.jbpm.services.api.model.ProcessInstanceDesc;
import org.kie.internal.KieInternalServices;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.process.CorrelationKeyFactory;
import org.kie.server.api.model.instance.ProcessInstance;
import org.kie.server.api.model.instance.WorkItemInstance;
import org.kie.server.api.model.instance.WorkItemInstanceList;
import org.kie.server.remote.rest.common.exception.ExecutionServerRestOperationException;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.marshal.MarshallerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/server")
public class ProcessResource {
    public static final Logger logger = LoggerFactory.getLogger(ProcessResource.class);
    private ProcessService processService;
    private DefinitionService definitionService;
    private RuntimeDataService runtimeDataService;
    private MarshallerHelper marshallerHelper;
    private CorrelationKeyFactory correlationKeyFactory = KieInternalServices.Factory.get().newCorrelationKeyFactory();

    public ProcessResource(ProcessService processService, DefinitionService definitionService, RuntimeDataService runtimeDataService, KieServerRegistry context) {
        this.processService = processService;
        this.definitionService = definitionService;
        this.runtimeDataService = runtimeDataService;
        this.marshallerHelper = new MarshallerHelper(context);
    }

    protected static String getRelativePath(HttpServletRequest httpRequest) {
        String url = httpRequest.getRequestURI();
        url = url.replaceAll(".*/rest", "");
        return url;
    }

    @POST
    @Path(value="containers/{id}/process/{pId}/instances")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response startProcess(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="pId") String processId, @DefaultValue(value="") String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            ProcessDefinition procDef = this.definitionService.getProcessDefinition(containerId, processId);
            if (procDef == null) {
                throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find process definition \"{0}\" in container \"{1}\"", processId, containerId), (Variant)v);
            }
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Error when retrieving process definition \"{0}\" in container \"{1}\":: Cause: {2}", processId, containerId, e.getMessage()), (Variant)v);
        }
        logger.debug("About to unmarshal parameters from payload: '{}'", (Object)payload);
        Map parameters = (Map)this.marshallerHelper.unmarshal(containerId, payload, type, Map.class);
        logger.debug("Calling start process with id {} on container {} and parameters {}", new Object[]{processId, containerId, parameters});
        Long processInstanceId = this.processService.startProcess(containerId, processId, parameters);
        try {
            String response = this.marshallerHelper.marshal(containerId, type, (Object)processInstanceId);
            logger.debug("Returning CREATED response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unable to create response: {0}", e.getMessage()), (Variant)v);
        }
    }

    @POST
    @Path(value="containers/{id}/process/{pId}/instances/correlation/{correlationKey}")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response startProcessWithCorrelation(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="pId") String processId, @PathParam(value="correlationKey") String correlationKey, @DefaultValue(value="") String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            ProcessDefinition procDef = this.definitionService.getProcessDefinition(containerId, processId);
            if (procDef == null) {
                throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find process definition \"{0}\" in container \"{1}\"", processId, containerId), (Variant)v);
            }
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Error when retrieving process definition \"{0}\" in container \"{1}\":: Cause: {2}", processId, containerId, e.getMessage()), (Variant)v);
        }
        logger.debug("About to unmarshal parameters from payload: '{}'", (Object)payload);
        Map parameters = (Map)this.marshallerHelper.unmarshal(containerId, payload, type, Map.class);
        String[] correlationProperties = correlationKey.split(":");
        CorrelationKey actualCorrelationKey = this.correlationKeyFactory.newCorrelationKey(Arrays.asList(correlationProperties));
        logger.debug("Calling start process with id {} on container {} and parameters {}", new Object[]{processId, containerId, parameters});
        Long processInstanceId = this.processService.startProcess(containerId, processId, actualCorrelationKey, parameters);
        try {
            String response = this.marshallerHelper.marshal(containerId, type, (Object)processInstanceId);
            logger.debug("Returning CREATED response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unable to create response: {0}", e.getMessage()), (Variant)v);
        }
    }

    @DELETE
    @Path(value="containers/{id}/process/instance/{pInstanceId}")
    @Produces(value={"application/xml", "application/json"})
    public Response abortProcessInstance(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="pInstanceId") Long processInstanceId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            this.processService.abortProcessInstance(processInstanceId);
            return null;
        }
        catch (ProcessInstanceNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v);
        }
        catch (DeploymentNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @DELETE
    @Path(value="containers/{id}/process/instances")
    @Produces(value={"application/xml", "application/json"})
    public Response abortProcessInstances(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @QueryParam(value="instanceId") List<Long> processInstanceIds) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            this.processService.abortProcessInstances(processInstanceIds);
            return null;
        }
        catch (ProcessInstanceNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceIds), (Variant)v);
        }
        catch (DeploymentNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @POST
    @Path(value="containers/{id}/process/instance/{pInstanceId}/signal/{sName}")
    @Produces(value={"application/xml", "application/json"})
    public Response signalProcessInstance(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="pInstanceId") Long processInstanceId, @PathParam(value="sName") String signalName, String eventPayload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            logger.debug("About to unmarshal event from payload: '{}'", (Object)eventPayload);
            Object event = this.marshallerHelper.unmarshal(containerId, eventPayload, type, Object.class);
            logger.debug("Calling signal '{}' process instance with id {} on container {} and event {}", new Object[]{signalName, processInstanceId, containerId, event});
            this.processService.signalProcessInstance(processInstanceId, signalName, event);
            return RestUtils.createResponse(null, (Variant)v, (Response.Status)Response.Status.OK);
        }
        catch (ProcessInstanceNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v);
        }
        catch (DeploymentNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @POST
    @Path(value="containers/{id}/process/instances/signal/{sName}")
    @Produces(value={"application/xml", "application/json"})
    public Response signalProcessInstances(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @QueryParam(value="instanceId") List<Long> processInstanceIds, @PathParam(value="sName") String signalName, String eventPayload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            logger.debug("About to unmarshal event from payload: '{}'", (Object)eventPayload);
            Object event = this.marshallerHelper.unmarshal(containerId, eventPayload, type, Object.class);
            logger.debug("Calling signal '{}' process instances with id {} on container {} and event {}", new Object[]{signalName, processInstanceIds, containerId, event});
            this.processService.signalProcessInstances(processInstanceIds, signalName, event);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.OK);
        }
        catch (ProcessInstanceNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceIds), (Variant)v);
        }
        catch (DeploymentNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Path(value="containers/{id}/process/instance/{pInstanceId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getProcessInstance(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="pInstanceId") Long processInstanceId, @QueryParam(value="withVars") boolean withVars) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            ProcessInstanceDesc instanceDesc = this.runtimeDataService.getProcessInstanceById(processInstanceId.longValue());
            if (instanceDesc == null) {
                throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v);
            }
            ProcessInstance processInstance = ProcessInstance.builder().id(instanceDesc.getId()).processId(instanceDesc.getProcessId()).processName(instanceDesc.getProcessName()).processVersion(instanceDesc.getProcessVersion()).state(instanceDesc.getState()).containerId(instanceDesc.getDeploymentId()).date(instanceDesc.getDataTimeStamp()).initiator(instanceDesc.getInitiator()).processInstanceDescription(instanceDesc.getProcessInstanceDescription()).parentInstanceId(instanceDesc.getParentId()).build();
            if (Boolean.TRUE.equals(withVars)) {
                Map variables = this.processService.getProcessInstanceVariables(processInstanceId);
                processInstance.setVariables(variables);
            }
            logger.debug("About to marshal process instance with id '{}' {}", (Object)processInstanceId, (Object)processInstance);
            String response = this.marshallerHelper.marshal(containerId, type, (Object)processInstance);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @PUT
    @Path(value="containers/{id}/process/instance/{pInstanceId}/variable/{varName}")
    @Produces(value={"application/xml", "application/json"})
    public Response setProcessVariable(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="pInstanceId") Long processInstanceId, @PathParam(value="varName") String varName, String variablePayload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            logger.debug("About to unmarshal variable from payload: '{}'", (Object)variablePayload);
            Object variable = this.marshallerHelper.unmarshal(containerId, variablePayload, type, Object.class);
            logger.debug("Setting variable '{}' on process instance with id {} with value {}", new Object[]{varName, processInstanceId, variable});
            this.processService.setProcessVariable(processInstanceId, varName, variable);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (ProcessInstanceNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v);
        }
        catch (DeploymentNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @POST
    @Path(value="containers/{id}/process/instance/{pInstanceId}/variables")
    @Produces(value={"application/xml", "application/json"})
    public Response setProcessVariables(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="pInstanceId") Long processInstanceId, String variablePayload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            logger.debug("About to unmarshal variables from payload: '{}'", (Object)variablePayload);
            Map variables = (Map)this.marshallerHelper.unmarshal(containerId, variablePayload, type, Map.class);
            logger.debug("Setting variables '{}' on process instance with id {} with value {}", new Object[]{variables.keySet(), processInstanceId, variables.values()});
            this.processService.setProcessVariables(processInstanceId, variables);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.OK);
        }
        catch (ProcessInstanceNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v);
        }
        catch (DeploymentNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Path(value="containers/{id}/process/instance/{pInstanceId}/variable/{varName}")
    @Produces(value={"application/xml", "application/json"})
    public Object getProcessInstanceVariable(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="pInstanceId") Long processInstanceId, @PathParam(value="varName") String varName) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            Object variable = this.processService.getProcessInstanceVariable(processInstanceId, varName);
            if (variable == null) {
                throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find variable \"{0}\" in process instance with id \"{1}\"", varName, processInstanceId), (Variant)v);
            }
            logger.debug("About to marshal process variable with name '{}' {}", (Object)varName, variable);
            String response = this.marshallerHelper.marshal(containerId, type, variable);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK);
        }
        catch (ProcessInstanceNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v);
        }
        catch (DeploymentNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Path(value="containers/{id}/process/instance/{pInstanceId}/variables")
    @Produces(value={"application/xml", "application/json"})
    public Response getProcessInstanceVariables(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="pInstanceId") Long processInstanceId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            Map variables = this.processService.getProcessInstanceVariables(processInstanceId);
            logger.debug("About to marshal process variables {}", (Object)variables);
            String response = this.marshallerHelper.marshal(containerId, type, (Object)variables);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK);
        }
        catch (ProcessInstanceNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v);
        }
        catch (DeploymentNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Path(value="containers/{id}/process/instance/{pInstanceId}/signals")
    @Produces(value={"application/xml", "application/json"})
    public Response getAvailableSignals(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="pInstanceId") Long processInstanceId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            Collection signals = this.processService.getAvailableSignals(processInstanceId);
            logger.debug("About to marshal available signals {}", (Object)signals);
            String response = this.marshallerHelper.marshal(containerId, type, (Object)signals);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK);
        }
        catch (ProcessInstanceNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v);
        }
        catch (DeploymentNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @PUT
    @Path(value="containers/{id}/process/instance/{pInstanceId}/workitems/{workItemId}/completed")
    @Produces(value={"application/xml", "application/json"})
    public Response completeWorkItem(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="pInstanceId") Long processInstanceId, @PathParam(value="workItemId") Long workItemId, String resultPayload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            logger.debug("About to unmarshal work item result from payload: '{}'", (Object)resultPayload);
            Map results = (Map)this.marshallerHelper.unmarshal(containerId, resultPayload, type, Map.class);
            logger.debug("Completing work item '{}' on process instance id {} with value {}", new Object[]{workItemId, processInstanceId, results});
            this.processService.completeWorkItem(workItemId, results);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (ProcessInstanceNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v);
        }
        catch (DeploymentNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @PUT
    @Path(value="containers/{id}/process/instance/{pInstanceId}/workitems/{workItemId}/aborted")
    @Produces(value={"application/xml", "application/json"})
    public Response abortWorkItem(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="pInstanceId") Long processInstanceId, @PathParam(value="workItemId") Long workItemId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            logger.debug("Aborting work item '{}' on process instance id {}", (Object)workItemId, (Object)processInstanceId);
            this.processService.abortWorkItem(workItemId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (ProcessInstanceNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v);
        }
        catch (DeploymentNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Path(value="containers/{id}/process/instance/{pInstanceId}/workitems/{workItemId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getWorkItem(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="pInstanceId") Long processInstanceId, @PathParam(value="workItemId") Long workItemId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            org.kie.api.runtime.process.WorkItem workItem = this.processService.getWorkItem(workItemId);
            if (workItem == null) {
                throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find work item instance with id \"{0}\"", workItemId), (Variant)v);
            }
            WorkItemInstance workItemInstance = WorkItemInstance.builder().id(Long.valueOf(workItem.getId())).nodeInstanceId(Long.valueOf(((WorkItem)workItem).getNodeInstanceId())).processInstanceId(Long.valueOf(workItem.getProcessInstanceId())).containerId(((WorkItem)workItem).getDeploymentId()).name(workItem.getName()).nodeId(Long.valueOf(((WorkItem)workItem).getNodeId())).parameters(workItem.getParameters()).state(Integer.valueOf(workItem.getState())).build();
            logger.debug("About to marshal work item {}", (Object)workItemInstance);
            String response = this.marshallerHelper.marshal(containerId, type, (Object)workItemInstance);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK);
        }
        catch (ProcessInstanceNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v);
        }
        catch (DeploymentNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Path(value="containers/{id}/process/instance/{pInstanceId}/workitems")
    @Produces(value={"application/xml", "application/json"})
    public Response getWorkItemByProcessInstance(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="pInstanceId") Long processInstanceId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            List workItems = this.processService.getWorkItemByProcessInstance(processInstanceId);
            WorkItemInstance[] instances = new WorkItemInstance[workItems.size()];
            int counter = 0;
            for (org.kie.api.runtime.process.WorkItem workItem : workItems) {
                WorkItemInstance workItemInstance;
                instances[counter] = workItemInstance = WorkItemInstance.builder().id(Long.valueOf(workItem.getId())).nodeInstanceId(Long.valueOf(((WorkItem)workItem).getNodeInstanceId())).processInstanceId(Long.valueOf(workItem.getProcessInstanceId())).containerId(((WorkItem)workItem).getDeploymentId()).name(workItem.getName()).nodeId(Long.valueOf(((WorkItem)workItem).getNodeId())).parameters(workItem.getParameters()).state(Integer.valueOf(workItem.getState())).build();
                ++counter;
            }
            WorkItemInstanceList result = new WorkItemInstanceList(instances);
            logger.debug("About to marshal work items {}", (Object)result);
            String response = this.marshallerHelper.marshal(containerId, type, (Object)result);
            logger.debug("Returning OK response with content '{}'", (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)Response.Status.OK);
        }
        catch (ProcessInstanceNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v);
        }
        catch (DeploymentNotFoundException e) {
            throw ExecutionServerRestOperationException.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            throw ExecutionServerRestOperationException.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }
}

