/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.jbpm;

import java.text.MessageFormat;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.jbpm.services.api.query.QueryAlreadyRegisteredException;
import org.jbpm.services.api.query.QueryNotFoundException;
import org.kie.server.api.model.definition.QueryDefinition;
import org.kie.server.api.model.definition.QueryDefinitionList;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.jbpm.QueryDataServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="server/queries/definitions")
public class QueryDataResource {
    public static final Logger logger = LoggerFactory.getLogger(QueryDataResource.class);
    private QueryDataServiceBase queryDataServiceBase;

    public QueryDataResource() {
    }

    public QueryDataResource(QueryDataServiceBase delegate) {
        this.queryDataServiceBase = delegate;
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    public Response getQueries(@Context HttpHeaders headers, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        QueryDefinitionList result = this.queryDataServiceBase.getQueries(page, pageSize);
        logger.debug("Returning result of get queries definition: {}", (Object)result);
        return RestUtils.createCorrectVariant((Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK);
    }

    @POST
    @Path(value="{queryName}")
    @Produces(value={"application/xml", "application/json"})
    public Response createQueryDefinition(@Context HttpHeaders headers, @PathParam(value="queryName") String queryName, String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            this.queryDataServiceBase.registerQuery(queryName, payload, type);
            logger.debug("Returning CREATED response after registering query with name {}", (Object)queryName);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (QueryAlreadyRegisteredException e) {
            return RestUtils.alreadyExists((String)MessageFormat.format("Query definition with name \"{0}\" already exists", queryName), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @PUT
    @Path(value="{queryName}")
    @Produces(value={"application/xml", "application/json"})
    public Response replaceQueryDefinition(@Context HttpHeaders headers, @PathParam(value="queryName") String queryName, String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        try {
            this.queryDataServiceBase.replaceQuery(queryName, payload, type);
            logger.debug("Returning CREATED response after registering query with name {}", (Object)queryName);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @DELETE
    @Path(value="{queryName}")
    @Produces(value={"application/xml", "application/json"})
    public Response dropQueryDefinition(@Context HttpHeaders headers, @PathParam(value="queryName") String queryName) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            this.queryDataServiceBase.unregisterQuery(queryName);
            return null;
        }
        catch (QueryNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find query definition with name \"{0}\"", queryName), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Path(value="{queryName}")
    @Produces(value={"application/xml", "application/json"})
    public Response getQuery(@Context HttpHeaders headers, @PathParam(value="queryName") String queryName) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        try {
            QueryDefinition queryDefinition = this.queryDataServiceBase.getQuery(queryName);
            return RestUtils.createCorrectVariant((Object)queryDefinition, (HttpHeaders)headers, (Response.Status)Response.Status.OK);
        }
        catch (QueryNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find query definition with name \"{0}\"", queryName), (Variant)v);
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v);
        }
    }

    @GET
    @Path(value="{queryName}/data")
    @Produces(value={"application/xml", "application/json"})
    public Response runQuery(@Context HttpHeaders headers, @PathParam(value="queryName") String queryName, @QueryParam(value="mapper") String mapper, @QueryParam(value="sortBy") String orderBy, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        Object result = this.queryDataServiceBase.query(queryName, mapper, orderBy, page, pageSize);
        logger.debug("Returning result of process instance search: {}", result);
        return RestUtils.createCorrectVariant((Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK);
    }

    @POST
    @Path(value="{queryName}/filtered-data")
    @Produces(value={"application/xml", "application/json"})
    public Response runQueryFiltered(@Context HttpHeaders headers, @PathParam(value="queryName") String queryName, @QueryParam(value="mapper") String mapper, @QueryParam(value="builder") String builder, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, String payload) {
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Object result = null;
        result = builder != null && !builder.isEmpty() ? this.queryDataServiceBase.queryFilteredWithBuilder(queryName, mapper, builder, page, pageSize, payload, type) : this.queryDataServiceBase.queryFiltered(queryName, mapper, page, pageSize, payload, type);
        logger.debug("Returning result of process instance search: {}", result);
        return RestUtils.createCorrectVariant((Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK);
    }
}

