/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.jbpm;

import java.text.MessageFormat;
import java.util.List;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.jbpm.services.api.TaskNotFoundException;
import org.kie.server.api.model.definition.ProcessDefinition;
import org.kie.server.api.model.definition.ProcessDefinitionList;
import org.kie.server.api.model.instance.NodeInstance;
import org.kie.server.api.model.instance.NodeInstanceList;
import org.kie.server.api.model.instance.ProcessInstance;
import org.kie.server.api.model.instance.ProcessInstanceList;
import org.kie.server.api.model.instance.TaskEventInstanceList;
import org.kie.server.api.model.instance.TaskInstance;
import org.kie.server.api.model.instance.TaskSummaryList;
import org.kie.server.api.model.instance.VariableInstanceList;
import org.kie.server.remote.rest.common.Header;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.jbpm.RuntimeDataServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="server/queries")
public class RuntimeDataResource {
    public static final Logger logger = LoggerFactory.getLogger(RuntimeDataResource.class);
    private RuntimeDataServiceBase runtimeDataServiceBase;
    private KieServerRegistry context;

    public RuntimeDataResource() {
    }

    public RuntimeDataResource(RuntimeDataServiceBase delegate, KieServerRegistry context) {
        this.runtimeDataServiceBase = delegate;
        this.context = context;
    }

    @GET
    @Path(value="processes/instances")
    @Produces(value={"application/xml", "application/json"})
    public Response getProcessInstances(@Context HttpHeaders headers, @QueryParam(value="status") List<Integer> status, @QueryParam(value="initiator") String initiator, @QueryParam(value="processName") String processName, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @QueryParam(value="sort") String sort, @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        ProcessInstanceList processInstanceList = this.runtimeDataServiceBase.getProcessInstances(status, initiator, processName, page, pageSize, sort, sortOrder);
        logger.debug("Returning result of process instance search: {}", (Object)processInstanceList);
        return RestUtils.createCorrectVariant((Object)processInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
    }

    @GET
    @Path(value="processes/{pId}/instances")
    @Produces(value={"application/xml", "application/json"})
    public Response getProcessInstancesByProcessId(@Context HttpHeaders headers, @PathParam(value="pId") String processId, @QueryParam(value="status") List<Integer> status, @QueryParam(value="initiator") String initiator, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @QueryParam(value="sort") String sort, @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        ProcessInstanceList processInstanceList = this.runtimeDataServiceBase.getProcessInstancesByProcessId(processId, status, initiator, page, pageSize, sort, sortOrder);
        logger.debug("Returning result of process instance search: {}", (Object)processInstanceList);
        return RestUtils.createCorrectVariant((Object)processInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
    }

    @GET
    @Path(value="containers/{id}/process/instances")
    @Produces(value={"application/xml", "application/json"})
    public Response getProcessInstancesByDeploymentId(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @QueryParam(value="status") List<Integer> status, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @QueryParam(value="sort") String sort, @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        ProcessInstanceList processInstanceList = this.runtimeDataServiceBase.getProcessInstancesByDeploymentId(containerId, status, page, pageSize, sort, sortOrder);
        logger.debug("Returning result of process instance search: {}", (Object)processInstanceList);
        return RestUtils.createCorrectVariant((Object)processInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
    }

    @GET
    @Path(value="processes/instance/correlation/{correlationKey}")
    @Produces(value={"application/xml", "application/json"})
    public Response getProcessInstanceByCorrelationKey(@Context HttpHeaders headers, @PathParam(value="correlationKey") String correlationKey) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        ProcessInstance processInstance = this.runtimeDataServiceBase.getProcessInstanceByCorrelationKey(correlationKey);
        if (processInstance == null) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", correlationKey), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        return RestUtils.createCorrectVariant((Object)processInstance, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
    }

    @GET
    @Path(value="processes/instances/correlation/{correlationKey}")
    @Produces(value={"application/xml", "application/json"})
    public Response getProcessInstancesByCorrelationKey(@Context HttpHeaders headers, @PathParam(value="correlationKey") String correlationKey, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @QueryParam(value="sort") String sort, @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        ProcessInstanceList processInstanceList = this.runtimeDataServiceBase.getProcessInstancesByCorrelationKey(correlationKey, page, pageSize, sort, sortOrder);
        return RestUtils.createCorrectVariant((Object)processInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
    }

    @GET
    @Path(value="processes/instances/variables/{varName}")
    @Produces(value={"application/xml", "application/json"})
    public Response getProcessInstanceByVariables(@Context HttpHeaders headers, @PathParam(value="varName") String variableName, @QueryParam(value="varValue") String variableValue, @QueryParam(value="status") List<Integer> status, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @QueryParam(value="sort") String sort, @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        ProcessInstanceList processInstanceList = this.runtimeDataServiceBase.getProcessInstanceByVariables(variableName, variableValue, status, page, pageSize, sort, sortOrder);
        logger.debug("Returning result of process instance search: {}", (Object)processInstanceList);
        return RestUtils.createCorrectVariant((Object)processInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
    }

    @GET
    @Path(value="processes/instances/{pInstanceId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getProcessInstanceById(@Context HttpHeaders headers, @PathParam(value="pInstanceId") long processInstanceId, @QueryParam(value="withVars") boolean withVars) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        ProcessInstance processInstanceDesc = null;
        try {
            processInstanceDesc = this.runtimeDataServiceBase.getProcessInstanceById(processInstanceId, withVars);
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        return RestUtils.createCorrectVariant((Object)processInstanceDesc, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
    }

    @GET
    @Path(value="processes/instances/{pInstanceId}/wi-nodes/instances/{workItemId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getNodeInstanceForWorkItem(@Context HttpHeaders headers, @PathParam(value="pInstanceId") long processInstanceId, @PathParam(value="workItemId") long workItemId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        NodeInstance nodeInstanceDesc = null;
        try {
            nodeInstanceDesc = this.runtimeDataServiceBase.getNodeInstanceForWorkItem(processInstanceId, workItemId);
        }
        catch (IllegalArgumentException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find node instance with id \"{0}\" within process instance with id \"{1}\"", workItemId, processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        return RestUtils.createCorrectVariant((Object)nodeInstanceDesc, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
    }

    @GET
    @Path(value="processes/instances/{pInstanceId}/nodes/instances")
    @Produces(value={"application/xml", "application/json"})
    public Response getProcessInstanceHistory(@Context HttpHeaders headers, @PathParam(value="pInstanceId") long processInstanceId, @QueryParam(value="activeOnly") Boolean active, @QueryParam(value="completedOnly") Boolean completed, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        NodeInstanceList nodeInstanceList = this.runtimeDataServiceBase.getProcessInstanceHistory(processInstanceId, active, completed, page, pageSize);
        logger.debug("Returning result of node instances search: {}", (Object)nodeInstanceList);
        return RestUtils.createCorrectVariant((Object)nodeInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
    }

    @GET
    @Path(value="processes/instances/{pInstanceId}/variables/instances")
    @Produces(value={"application/xml", "application/json"})
    public Response getVariablesCurrentState(@Context HttpHeaders headers, @PathParam(value="pInstanceId") long processInstanceId) {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        VariableInstanceList variableInstanceList = this.runtimeDataServiceBase.getVariablesCurrentState(processInstanceId);
        logger.debug("Returning result of variables search: {}", (Object)variableInstanceList);
        return RestUtils.createCorrectVariant((Object)variableInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
    }

    @GET
    @Path(value="processes/instances/{pInstanceId}/variables/instances/{varName}")
    @Produces(value={"application/xml", "application/json"})
    public Response getVariableHistory(@Context HttpHeaders headers, @PathParam(value="pInstanceId") long processInstanceId, @PathParam(value="varName") String variableName, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize) {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        VariableInstanceList variableInstanceList = this.runtimeDataServiceBase.getVariableHistory(processInstanceId, variableName, page, pageSize);
        logger.debug("Returning result of variable '{}; history search: {}", (Object)variableName, (Object)variableInstanceList);
        return RestUtils.createCorrectVariant((Object)variableInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
    }

    @GET
    @Path(value="containers/{id}/processes/definitions")
    @Produces(value={"application/xml", "application/json"})
    public Response getProcessesByDeploymentId(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @QueryParam(value="sort") String sort, @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        ProcessDefinitionList processDefinitionList = this.runtimeDataServiceBase.getProcessesByDeploymentId(containerId, page, pageSize, sort, sortOrder);
        logger.debug("Returning result of process definition search: {}", (Object)processDefinitionList);
        return RestUtils.createCorrectVariant((Object)processDefinitionList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
    }

    @GET
    @Path(value="processes/definitions")
    @Produces(value={"application/xml", "application/json"})
    public Response getProcessesByFilter(@Context HttpHeaders headers, @QueryParam(value="filter") String filter, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @QueryParam(value="sort") String sort, @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        ProcessDefinitionList processDefinitionList = this.runtimeDataServiceBase.getProcessesByFilter(filter, page, pageSize, sort, sortOrder);
        logger.debug("Returning result of process definition search: {}", (Object)processDefinitionList);
        return RestUtils.createCorrectVariant((Object)processDefinitionList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
    }

    @GET
    @Path(value="processes/definitions/{pId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getProcessesById(@Context HttpHeaders headers, @PathParam(value="pId") String processId) {
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        ProcessDefinitionList processDefinitionList = this.runtimeDataServiceBase.getProcessesById(processId);
        logger.debug("Returning result of process definition search: {}", (Object)processDefinitionList);
        return RestUtils.createCorrectVariant((Object)processDefinitionList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
    }

    @GET
    @Path(value="containers/{id}/processes/definitions/{pId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getProcessesByDeploymentIdProcessId(@Context HttpHeaders headers, @PathParam(value="id") String containerId, @PathParam(value="pId") String processId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        ProcessDefinition processDesc = null;
        try {
            processDesc = this.runtimeDataServiceBase.getProcessesByDeploymentIdProcessId(containerId, processId);
        }
        catch (IllegalArgumentException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process definition \"{0}\" in container \"{1}\"", processId, containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        return RestUtils.createCorrectVariant((Object)processDesc, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
    }

    @GET
    @Path(value="tasks/instances/workitem/{workItemId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getTaskByWorkItemId(@Context HttpHeaders headers, @PathParam(value="workItemId") Long workItemId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        TaskInstance userTaskDesc = null;
        try {
            userTaskDesc = this.runtimeDataServiceBase.getTaskByWorkItemId(workItemId.longValue());
            return RestUtils.createCorrectVariant((Object)userTaskDesc, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance for work item with id \"{0}\"", workItemId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @GET
    @Path(value="tasks/instances/{tInstanceId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getTaskById(@Context HttpHeaders headers, @PathParam(value="tInstanceId") Long taskId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        TaskInstance userTaskDesc = null;
        try {
            userTaskDesc = this.runtimeDataServiceBase.getTaskById(taskId.longValue());
            return RestUtils.createCorrectVariant((Object)userTaskDesc, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @GET
    @Path(value="tasks/instances/admins")
    @Produces(value={"application/xml", "application/json"})
    public Response getTasksAssignedAsBusinessAdministratorByStatus(@Context HttpHeaders headers, @QueryParam(value="status") List<String> status, @QueryParam(value="user") String userId, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @QueryParam(value="sort") String sort, @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            TaskSummaryList result = this.runtimeDataServiceBase.getTasksAssignedAsBusinessAdministratorByStatus(status, userId, page, pageSize, sort, sortOrder);
            return RestUtils.createCorrectVariant((Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @GET
    @Path(value="tasks/instances/pot-owners")
    @Produces(value={"application/xml", "application/json"})
    public Response getTasksAssignedAsPotentialOwner(@Context HttpHeaders headers, @QueryParam(value="status") List<String> status, @QueryParam(value="groups") List<String> groupIds, @QueryParam(value="user") String userId, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @QueryParam(value="sort") String sort, @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder, @QueryParam(value="filter") String filter) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            TaskSummaryList result = this.runtimeDataServiceBase.getTasksAssignedAsPotentialOwner(status, groupIds, userId, page, pageSize, sort, sortOrder, filter);
            return RestUtils.createCorrectVariant((Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @GET
    @Path(value="tasks/instances/owners")
    @Produces(value={"application/xml", "application/json"})
    public Response getTasksOwnedByStatus(@Context HttpHeaders headers, @QueryParam(value="status") List<String> status, @QueryParam(value="user") String userId, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @QueryParam(value="sort") String sort, @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            TaskSummaryList result = this.runtimeDataServiceBase.getTasksOwnedByStatus(status, userId, page, pageSize, sort, sortOrder);
            return RestUtils.createCorrectVariant((Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @GET
    @Path(value="tasks/instances/process/{pInstanceId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getTasksByStatusByProcessInstanceId(@Context HttpHeaders headers, @PathParam(value="pInstanceId") Long processInstanceId, @QueryParam(value="status") List<String> status, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @QueryParam(value="sort") String sort, @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            TaskSummaryList result = this.runtimeDataServiceBase.getTasksByStatusByProcessInstanceId((Number)processInstanceId, status, page, pageSize, sort, sortOrder);
            return RestUtils.createCorrectVariant((Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @GET
    @Path(value="tasks/instances")
    @Produces(value={"application/xml", "application/json"})
    public Response getAllAuditTask(@Context HttpHeaders headers, @QueryParam(value="user") String userId, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @QueryParam(value="sort") String sort, @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            TaskSummaryList result = this.runtimeDataServiceBase.getAllAuditTask(userId, page, pageSize, sort, sortOrder);
            return RestUtils.createCorrectVariant((Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @GET
    @Path(value="tasks/instances/{tInstanceId}/events")
    @Produces(value={"application/xml", "application/json"})
    public Response getTaskEvents(@Context HttpHeaders headers, @PathParam(value="tInstanceId") Long taskId, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @QueryParam(value="sort") String sort, @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            TaskEventInstanceList result = this.runtimeDataServiceBase.getTaskEvents(taskId.longValue(), page, pageSize, sort, sortOrder);
            return RestUtils.createCorrectVariant((Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", taskId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @GET
    @Path(value="tasks/instances/variables/{varName}")
    @Produces(value={"application/xml", "application/json"})
    public Response getTasksByVariables(@Context HttpHeaders headers, @PathParam(value="varName") String variableName, @QueryParam(value="varValue") String variableValue, @QueryParam(value="status") List<String> status, @QueryParam(value="user") String userId, @QueryParam(value="page") @DefaultValue(value="0") Integer page, @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @QueryParam(value="sort") String sort, @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)"", (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            TaskSummaryList result = this.runtimeDataServiceBase.getTasksByVariables(userId, variableName, variableValue, status, page, pageSize, sort, sortOrder);
            return RestUtils.createCorrectVariant((Object)result, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)MessageFormat.format("Unexpected error during processing: {0}", e.getMessage()), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }
}

