/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.jbpm.admin;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Example;
import io.swagger.annotations.ExampleProperty;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.jbpm.services.api.DeploymentNotFoundException;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.jbpm.services.api.TaskNotFoundException;
import org.jbpm.services.api.admin.ExecutionErrorNotFoundException;
import org.kie.server.api.model.admin.ExecutionErrorInstance;
import org.kie.server.api.model.admin.ExecutionErrorInstanceList;
import org.kie.server.api.model.admin.TaskNotificationList;
import org.kie.server.api.model.admin.TaskReassignmentList;
import org.kie.server.remote.rest.common.Header;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.remote.rest.jbpm.admin.ProcessAdminResource;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.jbpm.admin.UserTaskAdminServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="Task instance administration")
@Path(value="server/admin/containers/{containerId}/tasks")
public class UserTaskAdminResource {
    private static final Logger logger = LoggerFactory.getLogger(ProcessAdminResource.class);
    private UserTaskAdminServiceBase userTaskAdminServiceBase;
    private KieServerRegistry context;
    private static final int POT_OWNER = 1;
    private static final int EXL_OWNER = 2;
    private static final int ADMIN = 3;

    public UserTaskAdminResource() {
    }

    public UserTaskAdminResource(UserTaskAdminServiceBase userTaskAdminServiceBase, KieServerRegistry context) {
        this.userTaskAdminServiceBase = userTaskAdminServiceBase;
        this.context = context;
    }

    @ApiOperation(value="Adds users and groups as potential owners to a specified task instance.", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task instance or Container Id not found")})
    @PUT
    @Path(value="{taskInstanceId}/pot-owners")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response addPotentialOwners(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of task instance to be updated", required=true, example="123") @PathParam(value="taskInstanceId") Long tInstanceId, @ApiParam(value="optional flag that indicates if existing potential owners should be removed, defaults to false", required=false) @QueryParam(value="remove") @DefaultValue(value="false") boolean removeExisting, @ApiParam(value="list of users/groups to be added as potential owners, as OrgEntities type", required=true, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"users\" : [ \"john\" ],\n  \"groups\" : null\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<org-entities>\n    <users>john</users>\n</org-entities>")})) String payload) {
        return this.addToTask(headers, containerId, tInstanceId, removeExisting, payload, 1);
    }

    @ApiOperation(value="Adds users and groups to be excluded from being owners for a specified task instance.", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task instance or Container Id not found")})
    @PUT
    @Path(value="{taskInstanceId}/exl-owners")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response addExcludedOwners(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of task instance to be updated", required=true, example="123") @PathParam(value="taskInstanceId") Long tInstanceId, @ApiParam(value="optional flag that indicates if existing excluded owners should be removed, defaults to false", required=false) @QueryParam(value="remove") @DefaultValue(value="false") boolean removeExisting, @ApiParam(value="list of users/groups to be added as excluded owners, as OrgEntities type", required=true, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"users\" : [ \"john\" ],\n  \"groups\" : null\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<org-entities>\n    <users>john</users>\n</org-entities>")})) String payload) {
        return this.addToTask(headers, containerId, tInstanceId, removeExisting, payload, 2);
    }

    @ApiOperation(value="Adds business administrator users or groups to a specified task instance.", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task instance or Container Id not found")})
    @PUT
    @Path(value="{taskInstanceId}/admins")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response addAdmins(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of task instance to be updated", required=true, example="123") @PathParam(value="taskInstanceId") Long tInstanceId, @ApiParam(value="optional flag that indicates if existing business admins should be removed, defaults to false", required=false) @QueryParam(value="remove") @DefaultValue(value="false") boolean removeExisting, @ApiParam(value="list of users/groups to be added as business admins, as OrgEntities type", required=true, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"users\" : [ \"john\" ],\n  \"groups\" : null\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<org-entities>\n    <users>john</users>\n</org-entities>")})) String payload) {
        return this.addToTask(headers, containerId, tInstanceId, removeExisting, payload, 3);
    }

    @ApiOperation(value="Deletes specified users previously added as potential owners for a specified task instance.", response=Void.class, code=204)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task instance or Container Id not found")})
    @DELETE
    @Path(value="{taskInstanceId}/pot-owners/users/{entityId}")
    @Produces(value={"application/json", "application/xml"})
    public Response removePotentialOwnersUsers(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of task instance to be updated", required=true, example="123") @PathParam(value="taskInstanceId") Long tInstanceId, @ApiParam(value="list of users to be removed from potantial owners list", required=true, example="john") @PathParam(value="entityId") String users) {
        return this.removeFromTask(headers, containerId, tInstanceId, true, users, 1);
    }

    @ApiOperation(value="Deletes specified users previously added as excluded owners for a specified task instance. ", response=Void.class, code=204)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task instance or Container Id not found")})
    @DELETE
    @Path(value="{taskInstanceId}/exl-owners/users/{entityId}")
    @Produces(value={"application/json", "application/xml"})
    public Response removeExcludedOwnersUsers(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of task instance to be updated", required=true, example="123") @PathParam(value="taskInstanceId") Long tInstanceId, @ApiParam(value="list of users to be removed from excluded owners list", required=true, example="john") @PathParam(value="entityId") String users) {
        return this.removeFromTask(headers, containerId, tInstanceId, true, users, 2);
    }

    @ApiOperation(value="Deletes specified users previously added as business administrators for a specified task instance.", response=Void.class, code=204)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task instance or Container Id not found")})
    @DELETE
    @Path(value="{taskInstanceId}/admins/users/{entityId}")
    @Produces(value={"application/json", "application/xml"})
    public Response removeAdminsUsers(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of task instance to be updated", required=true, example="123") @PathParam(value="taskInstanceId") Long tInstanceId, @ApiParam(value="list of users to be removed from business admin list", required=true, example="john") @PathParam(value="entityId") String users) {
        return this.removeFromTask(headers, containerId, tInstanceId, true, users, 3);
    }

    @ApiOperation(value="Deletes specified groups previously added as potential owners for a specified task instance.", response=Void.class, code=204)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task instance or Container Id not found")})
    @DELETE
    @Path(value="{taskInstanceId}/pot-owners/groups/{entityId}")
    @Produces(value={"application/json", "application/xml"})
    public Response removePotentialOwnersGroups(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of task instance to be updated", required=true, example="123") @PathParam(value="taskInstanceId") Long tInstanceId, @ApiParam(value="list of groups to be removed from potantial owners list", required=true, example="HR") @PathParam(value="entityId") String groups) {
        return this.removeFromTask(headers, containerId, tInstanceId, false, groups, 1);
    }

    @ApiOperation(value="Deletes specified groups previously added as excluded owners for a specified task instance.", response=Void.class, code=204)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task instance or Container Id not found")})
    @DELETE
    @Path(value="{taskInstanceId}/exl-owners/groups/{entityId}")
    @Produces(value={"application/json", "application/xml"})
    public Response removeExcludedOwnersGroups(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of task instance to be updated", required=true, example="123") @PathParam(value="taskInstanceId") Long tInstanceId, @ApiParam(value="list of groups to be removed from excluded owners list", required=true, example="HR") @PathParam(value="entityId") String groups) {
        return this.removeFromTask(headers, containerId, tInstanceId, false, groups, 2);
    }

    @ApiOperation(value="Deletes specified groups previously added as business administrators for a specified task instance.", response=Void.class, code=204)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task instance or Container Id not found")})
    @DELETE
    @Path(value="{taskInstanceId}/admins/groups/{entityId}")
    @Produces(value={"application/json", "application/xml"})
    public Response removeAdminsGroups(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true) @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of task instance to be updated", required=true) @PathParam(value="taskInstanceId") Long tInstanceId, @ApiParam(value="list of groups to be removed from business admin list", required=true, example="HR") @PathParam(value="entityId") String groups) {
        return this.removeFromTask(headers, containerId, tInstanceId, false, groups, 3);
    }

    @ApiOperation(value="Adds input data to a specified task instance.", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task instance or Container Id not found")})
    @PUT
    @Path(value="{taskInstanceId}/contents/input")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response addTaskInputs(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of task instance to be updated", required=true, example="123") @PathParam(value="taskInstanceId") Long tInstanceId, @ApiParam(value="map of data to be set as task inputs, as Map", required=true, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n    \"age\": 25,\n    \"person\": {\n        \"Person\": {\n            \"name\": \"john\"\n        }\n    }\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<map-type>\n    <entries>\n        <entry>\n            <key>age</key>\n            <value xsi:type=\"xs:int\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n                    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">25</value>\n        </entry>\n        <entry>\n            <key>person</key>\n            <value xsi:type=\"person\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n                <name>john</name>\n            </value>\n        </entry>\n    </entries>\n</map-type>")})) String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskAdminServiceBase.addTaskInputs(containerId, (Number)tInstanceId, payload, type);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", tInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Deletes input data by parameter name from a specified task instance.", response=Void.class, code=204)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task instance or Container Id not found")})
    @DELETE
    @Path(value="{taskInstanceId}/contents/input")
    @Produces(value={"application/json", "application/xml"})
    public Response removeTaskInputs(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of task instance to be updated", required=true, example="123") @PathParam(value="taskInstanceId") Long tInstanceId, @ApiParam(value="one or more names of task inputs to be removed", required=true) @QueryParam(value="name") List<String> inputNames) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskAdminServiceBase.removeTaskInputs(containerId, (Number)tInstanceId, inputNames);
            return RestUtils.noContent((Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", tInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Deletes output data by parameter name from a specified task instance.", response=Void.class, code=204)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task instance or Container Id not found")})
    @DELETE
    @Path(value="{taskInstanceId}/contents/output")
    @Produces(value={"application/json", "application/xml"})
    public Response removeTaskOutputs(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of task instance to be updated", required=true, example="123") @PathParam(value="taskInstanceId") Long tInstanceId, @ApiParam(value="one or more names of task outputs to be removed", required=true) @QueryParam(value="name") List<String> outputNames) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskAdminServiceBase.removeTaskOutputs(containerId, (Number)tInstanceId, outputNames);
            return RestUtils.noContent((Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", tInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Schedules a specified task instance to be reassigned to specified users or groups and returns the ID of the reassignment.", response=Long.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task instance or Container Id not found"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="10")}))})
    @POST
    @Path(value="{taskInstanceId}/reassignments")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response reassign(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of task instance to be updated", required=true, example="123") @PathParam(value="taskInstanceId") Long tInstanceId, @ApiParam(value="time expression for reassignmnet", required=true) @QueryParam(value="expiresAt") String expiresAt, @ApiParam(value="optional flag that indicates the type of reassignment, either whenNotStarted or whenNotCompleted must be set", required=false) @QueryParam(value="whenNotStarted") @DefaultValue(value="false") boolean whenNotStarted, @ApiParam(value="optional flag that indicates the type of reassignment, either whenNotStarted or whenNotCompleted must be set", required=false) @QueryParam(value="whenNotCompleted") @DefaultValue(value="false") boolean whenNotCompleted, @ApiParam(value="list of users/groups that task should be reassined to, as OrgEntities type", required=true, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"users\" : [ \"john\" ],\n  \"groups\" : null\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<org-entities>\n    <users>john</users>\n</org-entities>")})) String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        if (expiresAt == null) {
            return RestUtils.badRequest((String)"'expiresAt' query parameter is mandatory", (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        try {
            if (!whenNotCompleted && !whenNotStarted) {
                return RestUtils.badRequest((String)"At least one query parameters must be set to true - 'whenNotStarted' or 'whenNotCompleted'", (Variant)v, (Header[])new Header[]{conversationIdHeader});
            }
            String id = null;
            if (whenNotStarted) {
                id = this.userTaskAdminServiceBase.reassignWhenNotStarted(containerId, (Number)tInstanceId, expiresAt, payload, type);
            }
            if (whenNotCompleted) {
                id = this.userTaskAdminServiceBase.reassignWhenNotCompleted(containerId, (Number)tInstanceId, expiresAt, payload, type);
            }
            return RestUtils.createResponse((Object)id, (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", tInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (RuntimeException e) {
            return RestUtils.badRequest((String)e.getMessage(), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Creates an email notification for the specified task instance and returns the ID of the new notification.", response=Long.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task instance or Container Id not found"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="10")}))})
    @POST
    @Path(value="{taskInstanceId}/notifications")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response notify(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of task instance to be updated", required=true, example="123") @PathParam(value="taskInstanceId") Long tInstanceId, @ApiParam(value="time expression for notification", required=true) @QueryParam(value="expiresAt") String expiresAt, @ApiParam(value="optional flag that indicates the type of notification, either whenNotStarted or whenNotCompleted must be set", required=false) @QueryParam(value="whenNotStarted") @DefaultValue(value="false") boolean whenNotStarted, @ApiParam(value="optional flag that indicates the type of notification, either whenNotStarted or whenNotCompleted must be set", required=false) @QueryParam(value="whenNotCompleted") @DefaultValue(value="false") boolean whenNotCompleted, @ApiParam(value="email notification details, as EmailNotification type", required=true, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"from\" : \"test@jbpm.org\",\n  \"reply-to\" : \"no-reply@jbpm.org\",\n  \"users\" : [ \"john\" ],\n  \"groups\" : null,\n  \"subject\" : \"reminder\",\n  \"body\" : \"my test content\"\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<email-notification>\n    <from>test@jbpm.org</from>\n    <reply-to>no-reply@jbpm.org</reply-to>\n    <users>john</users>\n    <subject>reminder</subject>\n    <body>my test content</body>\n</email-notification>")})) String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            if (expiresAt == null) {
                return RestUtils.badRequest((String)"'expiresAt' query parameter is mandatory", (Variant)v, (Header[])new Header[]{conversationIdHeader});
            }
            if (!whenNotCompleted && !whenNotStarted) {
                return RestUtils.badRequest((String)"At least one query parameters must be set to true - 'whenNotStarted' or 'whenNotCompleted'", (Variant)v, (Header[])new Header[]{conversationIdHeader});
            }
            String id = null;
            if (whenNotStarted) {
                id = this.userTaskAdminServiceBase.notifyWhenNotStarted(containerId, (Number)tInstanceId, expiresAt, payload, type);
            }
            if (whenNotCompleted) {
                id = this.userTaskAdminServiceBase.notifyWhenNotCompleted(containerId, (Number)tInstanceId, expiresAt, payload, type);
            }
            return RestUtils.createResponse((Object)id, (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", tInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Deletes a specified reassignment for a specified task instance.", response=Void.class, code=204)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task instance or Container Id not found")})
    @DELETE
    @Path(value="{taskInstanceId}/reassignments/{reassignmentId}")
    @Produces(value={"application/json", "application/xml"})
    public Response cancelReassignment(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of task instance to be updated", required=true, example="123") @PathParam(value="taskInstanceId") Long tInstanceId, @ApiParam(value="identifier of reassignment to be canceled", required=true, example="567") @PathParam(value="reassignmentId") Long reassignmentId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskAdminServiceBase.cancelReassignment(containerId, (Number)tInstanceId, (Number)reassignmentId);
            return RestUtils.noContent((Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", tInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Deletes a specified email notification from a specified task instance.", response=Void.class, code=204)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task instance or Container Id not found")})
    @DELETE
    @Path(value="{taskInstanceId}/notifications/{notificationId}")
    @Produces(value={"application/json", "application/xml"})
    public Response cancelNotification(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of task instance to be updated", required=true, example="123") @PathParam(value="taskInstanceId") Long tInstanceId, @ApiParam(value="identifier of notification to be canceled", required=true, example="567") @PathParam(value="notificationId") Long notificationId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskAdminServiceBase.cancelNotification(containerId, (Number)tInstanceId, (Number)notificationId);
            return RestUtils.noContent((Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", tInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns task reassignments for a specified task instance.", response=TaskReassignmentList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task instance or Container Id not found"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"task-reassignment\": [\n    {\n      \"id\": 9995,\n      \"name\": \"\",\n      \"reassign-at\": 1540394323872,\n      \"users\": [\n        \"John\",\n        \"Jane\"\n      ],\n      \"groups\": [\n        \"IT\"\n      ],\n      \"active\": true\n    }\n  ]\n}")}))})
    @GET
    @Path(value="{taskInstanceId}/reassignments")
    @Produces(value={"application/json", "application/xml"})
    public Response getTaskReassignments(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of task instance to be updated", required=true, example="123") @PathParam(value="taskInstanceId") Long tInstanceId, @ApiParam(value="optional flag that indicates if active only reassignmnets should be collected, defaults to true", required=false) @QueryParam(value="activeOnly") @DefaultValue(value="true") boolean activeOnly) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            TaskReassignmentList taskReassignmentList = this.userTaskAdminServiceBase.getTaskReassignments(containerId, (Number)tInstanceId, activeOnly);
            return RestUtils.createCorrectVariant((Object)taskReassignmentList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", tInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns notifications created for a specified task instance.", response=TaskNotificationList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task instance or Container Id not found"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"task-notification\": [\n    {\n      \"id\": 11070,\n      \"name\": null,\n      \"notify-at\": 1540396524172,\n      \"users\": [\n        \"Sheldon\"\n      ],\n      \"groups\": [\n        \"IT\"\n      ],\n      \"active\": true,\n      \"subject\": \"You hava a task not started\",\n      \"content\": \"You have been assigned to a task (task-id ${taskId}).\\n  Important technical information that can be of use when working on it:\\n    - process instance id - ${processInstanceId}\\n  - work item id - ${workItemId}\\n  - work item id - ${workItemId}\\n   Regards from dev team\"\n    }\n  ]\n}")}))})
    @GET
    @Path(value="{taskInstanceId}/notifications")
    @Produces(value={"application/json", "application/xml"})
    public Response getTaskNotifications(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of task instance to be updated", required=true, example="123") @PathParam(value="taskInstanceId") Long tInstanceId, @ApiParam(value="optional flag that indicates if active only notifications should be collected, defaults to true", required=false) @QueryParam(value="activeOnly") @DefaultValue(value="true") boolean activeOnly) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            TaskNotificationList taskNotificationList = this.userTaskAdminServiceBase.getTaskNotifications(containerId, (Number)tInstanceId, activeOnly);
            return RestUtils.createCorrectVariant((Object)taskNotificationList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", tInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Acknowledges a specified task execution error.", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task instance or Container Id not found")})
    @PUT
    @Path(value="errors/{errorId}")
    @Produces(value={"application/json", "application/xml"})
    public Response acknowledgeError(@Context HttpHeaders headers, @ApiParam(value="container id that error belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the execution error to be acknowledged", required=true, example="xxx-yyy-zzz") @PathParam(value="errorId") String errorId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskAdminServiceBase.acknowledgeError(Arrays.asList(errorId));
            return RestUtils.createCorrectVariant((Object)"", (HttpHeaders)headers, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ExecutionErrorNotFoundException e) {
            return RestUtils.notFound((String)e.getMessage(), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Acknowledges one or more task execution errors in a specified KIE container.", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task instance or Container Id not found")})
    @PUT
    @Path(value="errors")
    @Produces(value={"application/json", "application/xml"})
    public Response acknowledgeErrors(@Context HttpHeaders headers, @ApiParam(value="container id that errors belong to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="list of identifiers of execution errors to be acknowledged", required=true) @QueryParam(value="errorId") List<String> errorIds) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.userTaskAdminServiceBase.acknowledgeError(errorIds);
            return RestUtils.createCorrectVariant((Object)"", (HttpHeaders)headers, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ExecutionErrorNotFoundException e) {
            return RestUtils.notFound((String)e.getMessage(), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns information about a specified task execution error.", response=ExecutionErrorInstance.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Task instance or Container Id not found"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n      \"id\": \"a7982044-019d-4d4a-be3f-781f4ddca1df\",\n      \"type\": \"Process\",\n      \"container-id\": \"mortgage-process_1.0.0-SNAPSHOT\",\n      \"process-instance-id\": 4,\n      \"process-id\": \"Mortgage_Process.MortgageApprovalProcess\",\n      \"activity-id\": 12,\n      \"activity-name\": \"Validation\",\n      \"job-id\": null,\n      \"error-msg\": \"[Mortgage_Process.MortgageApprovalProcess:4 - Validation:3] -- [Mortgage_Process.MortgageApprovalProcess:4 - Validation:3] -- null\",\n      \"error\": null,\n      \"acknowledged\": false,\n      \"acknowledged-by\": null,\n      \"acknowledged-at\": null,\n      \"error-date\": 1539627364193\n    }")}))})
    @GET
    @Path(value="errors/{errorId}")
    @Produces(value={"application/json", "application/xml"})
    public Response getExecutionErrorById(@Context HttpHeaders headers, @ApiParam(value="container id that error belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the execution error to load", required=true, example="xxx-yyy-zzz") @PathParam(value="errorId") String errorId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            ExecutionErrorInstance executionErrorInstance = this.userTaskAdminServiceBase.getError(errorId);
            return RestUtils.createCorrectVariant((Object)executionErrorInstance, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ExecutionErrorNotFoundException e) {
            return RestUtils.notFound((String)e.getMessage(), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns task execution errors for a specified task instance.", response=ExecutionErrorInstanceList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Container Id not found"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"error-instance\": [\n    {\n      \"id\": \"54b04160-6242-475d-9452-0df3678123b0\",\n      \"type\": \"Process\",\n      \"container-id\": \"mortgage-process_1.0.0-SNAPSHOT\",\n      \"process-instance-id\": 4,\n      \"process-id\": \"Mortgage_Process.MortgageApprovalProcess\",\n      \"activity-id\": 12,\n      \"activity-name\": \"Validation\",\n      \"job-id\": null,\n      \"error-msg\": \"[Mortgage_Process.MortgageApprovalProcess:4 - Validation:3] -- [Mortgage_Process.MortgageApprovalProcess:4 - Validation:3] -- null\",\n      \"error\": null,\n      \"acknowledged\": false,\n      \"acknowledged-by\": null,\n      \"acknowledged-at\": null,\n      \"error-date\": 1539627373788\n    },\n    {\n      \"id\": \"a7982044-019d-4d4a-be3f-781f4ddca1df\",\n      \"type\": \"Process\",\n      \"container-id\": \"mortgage-process_1.0.0-SNAPSHOT\",\n      \"process-instance-id\": 4,\n      \"process-id\": \"Mortgage_Process.MortgageApprovalProcess\",\n      \"activity-id\": 12,\n      \"activity-name\": \"Validation\",\n      \"job-id\": null,\n      \"error-msg\": \"[Mortgage_Process.MortgageApprovalProcess:4 - Validation:3] -- [Mortgage_Process.MortgageApprovalProcess:4 - Validation:3] -- null\",\n      \"error\": null,\n      \"acknowledged\": false,\n      \"acknowledged-by\": null,\n      \"acknowledged-at\": null,\n      \"error-date\": 1539627364193\n    }\n  ]\n}")}))})
    @GET
    @Path(value="{taskInstanceId}/errors")
    @Produces(value={"application/json", "application/xml"})
    public Response getExecutionErrorsByTask(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of the task instance that errors should be collected for", required=true, example="123") @PathParam(value="taskInstanceId") Long taskId, @ApiParam(value="optional flag that indicates if acknowledged errors should also be collected, defaults to false", required=false) @QueryParam(value="includeAck") @DefaultValue(value="false") boolean includeAcknowledged, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            ExecutionErrorInstanceList executionErrorInstanceList = this.userTaskAdminServiceBase.getExecutionErrorsByTaskId(containerId, (Number)taskId, includeAcknowledged, page, pageSize, sort, sortOrder);
            return RestUtils.createCorrectVariant((Object)executionErrorInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ExecutionErrorNotFoundException e) {
            return RestUtils.notFound((String)e.getMessage(), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns all task execution errors for a specified KIE container.", response=ExecutionErrorInstanceList.class, code=200)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Container Id not found"), @ApiResponse(code=200, message="Successfull response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"error-instance\": [\n    {\n      \"id\": \"54b04160-6242-475d-9452-0df3678123b0\",\n      \"type\": \"Process\",\n      \"container-id\": \"mortgage-process_1.0.0-SNAPSHOT\",\n      \"process-instance-id\": 4,\n      \"process-id\": \"Mortgage_Process.MortgageApprovalProcess\",\n      \"activity-id\": 12,\n      \"activity-name\": \"Validation\",\n      \"job-id\": null,\n      \"error-msg\": \"[Mortgage_Process.MortgageApprovalProcess:4 - Validation:3] -- [Mortgage_Process.MortgageApprovalProcess:4 - Validation:3] -- null\",\n      \"error\": null,\n      \"acknowledged\": false,\n      \"acknowledged-by\": null,\n      \"acknowledged-at\": null,\n      \"error-date\": 1539627373788\n    },\n    {\n      \"id\": \"a7982044-019d-4d4a-be3f-781f4ddca1df\",\n      \"type\": \"Process\",\n      \"container-id\": \"mortgage-process_1.0.0-SNAPSHOT\",\n      \"process-instance-id\": 4,\n      \"process-id\": \"Mortgage_Process.MortgageApprovalProcess\",\n      \"activity-id\": 12,\n      \"activity-name\": \"Validation\",\n      \"job-id\": null,\n      \"error-msg\": \"[Mortgage_Process.MortgageApprovalProcess:4 - Validation:3] -- [Mortgage_Process.MortgageApprovalProcess:4 - Validation:3] -- null\",\n      \"error\": null,\n      \"acknowledged\": false,\n      \"acknowledged-by\": null,\n      \"acknowledged-at\": null,\n      \"error-date\": 1539627364193\n    }\n  ]\n}")}))})
    @GET
    @Path(value="errors")
    @Produces(value={"application/json", "application/xml"})
    public Response getExecutionErrors(@Context HttpHeaders headers, @ApiParam(value="container id that task instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="optional flag that indicates if acknowledged errors should also be collected, defaults to false", required=false) @QueryParam(value="includeAck") @DefaultValue(value="false") boolean includeAcknowledged, @ApiParam(value="optional name of the task to filter by", required=false) @QueryParam(value="name") String taskName, @ApiParam(value="optional process id that the task belongs to to filter by", required=false) @QueryParam(value="process") String processId, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            ExecutionErrorInstanceList executionErrorInstanceList = this.userTaskAdminServiceBase.getExecutionErrorsByTaskName(containerId, processId, taskName, includeAcknowledged, page, pageSize, sort, sortOrder);
            return RestUtils.createCorrectVariant((Object)executionErrorInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ExecutionErrorNotFoundException e) {
            return RestUtils.notFound((String)e.getMessage(), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    protected Response addToTask(HttpHeaders headers, String containerId, Long tInstanceId, boolean removeExisting, String payload, int operation) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            switch (operation) {
                case 1: {
                    this.userTaskAdminServiceBase.addPotentialOwners(containerId, (Number)tInstanceId, removeExisting, payload, type);
                    break;
                }
                case 2: {
                    this.userTaskAdminServiceBase.addExcludedOwners(containerId, (Number)tInstanceId, removeExisting, payload, type);
                    break;
                }
                case 3: {
                    this.userTaskAdminServiceBase.addBusinessAdmins(containerId, (Number)tInstanceId, removeExisting, payload, type);
                }
            }
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", tInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    protected Response removeFromTask(HttpHeaders headers, String containerId, Long tInstanceId, boolean isUser, String entities, int operation) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            String[] multipleEntities = entities.split(",");
            List<String> listOfEntities = Arrays.asList(multipleEntities);
            switch (operation) {
                case 1: {
                    this.userTaskAdminServiceBase.removePotentialOwners(containerId, (Number)tInstanceId, listOfEntities, isUser);
                    break;
                }
                case 2: {
                    this.userTaskAdminServiceBase.removeExcludedOwners(containerId, (Number)tInstanceId, listOfEntities, isUser);
                    break;
                }
                case 3: {
                    this.userTaskAdminServiceBase.removeBusinessAdmins(containerId, (Number)tInstanceId, listOfEntities, isUser);
                }
            }
            return RestUtils.noContent((Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (TaskNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find task instance with id \"{0}\"", tInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }
}

