/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.jbpm.admin;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Example;
import io.swagger.annotations.ExampleProperty;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.jbpm.services.api.DeploymentNotFoundException;
import org.jbpm.services.api.NodeInstanceNotFoundException;
import org.jbpm.services.api.NodeNotFoundException;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.jbpm.services.api.admin.ExecutionErrorNotFoundException;
import org.kie.server.api.model.admin.ExecutionErrorInstance;
import org.kie.server.api.model.admin.ExecutionErrorInstanceList;
import org.kie.server.api.model.admin.MigrationReportInstance;
import org.kie.server.api.model.admin.MigrationReportInstanceList;
import org.kie.server.api.model.admin.ProcessNodeList;
import org.kie.server.api.model.admin.TimerInstanceList;
import org.kie.server.api.model.instance.NodeInstanceList;
import org.kie.server.remote.rest.common.Header;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.jbpm.admin.ProcessAdminServiceBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="Process instance administration")
@Path(value="server/admin/containers/{containerId}/processes")
public class ProcessAdminResource {
    private static final Logger logger = LoggerFactory.getLogger(ProcessAdminResource.class);
    private ProcessAdminServiceBase processAdminServiceBase;
    private KieServerRegistry context;

    public ProcessAdminResource() {
    }

    public ProcessAdminResource(ProcessAdminServiceBase processAdminServiceBase, KieServerRegistry context) {
        this.processAdminServiceBase = processAdminServiceBase;
        this.context = context;
    }

    @ApiOperation(value="Migrates a specified process instance to a process definition in another KIE container.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process instance or Container Id not found"), @ApiResponse(code=404, message="Container Id not found"), @ApiResponse(code=201, response=MigrationReportInstance.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"migration-successful\": true,\n  \"migration-start\": \"2018-10-15T15:12:47.194Z\",\n  \"migration-end\": \"2018-10-15T15:12:47.194Z\",\n  \"migration-logs\": [\n    \"15-Oct-2018 15:56:23: StartNode () - Human\\n15-Oct-2018 15:56:23: Join () - System\\n15-Oct-2018 15:56:23: RuleSetNode (Validation) - System\\n15-Oct-2018 15:56:23: Split () - System\\n15-Oct-2018 15:56:23: RuleSetNode (Retract Validation) - System\\n15-Oct-2018 15:56:23: HumanTaskNode (Correct Data) - System\\n15-Oct-2018 15:56:23: RuleSetNode (Retract Validation) Completed - System\\n15-Oct-2018 15:56:23: Split () Completed - System\\n15-Oct-2018 15:56:23: RuleSetNode (Validation) Completed - System\\n15-Oct-2018 15:56:23: Join () Completed - System\\n15-Oct-2018 15:56:23: StartNode () Completed - System\"\n  ],\n  \"migration-process-instance\": 4\n}")}))})
    @PUT
    @Path(value="instances/{processInstanceId}")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response migrateProcessInstance(@Context HttpHeaders headers, @ApiParam(value="container id that process instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of process instance to be migrated", required=true, example="123") @PathParam(value="processInstanceId") Long processInstanceId, @ApiParam(value="container id that new process definition belongs to", required=true) @QueryParam(value="targetContainerId") String targetContainerId, @ApiParam(value="process definition that process instance should be migrated to", required=true) @QueryParam(value="targetProcessId") String targetProcessId, @ApiParam(value="node mapping - unique ids of old definition to new definition given as Map", required=false, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n    \"age\": 25,\n    \"name\": \"john\"\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<map-type>\n    <entries>\n        <entry>\n            <key>age</key>\n            <value xsi:type=\"xs:int\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n                    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">25</value>\n        </entry>\n        <entry>\n            <key>name</key>\n            <value xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n                    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">john</value>\n        </entry>\n    </entries>\n</map-type>")})) String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            MigrationReportInstance reportInstance = this.processAdminServiceBase.migrateProcessInstance(containerId, (Number)processInstanceId, targetContainerId, targetProcessId, payload, type);
            return RestUtils.createCorrectVariant((Object)reportInstance, (HttpHeaders)headers, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Migrates a specified process instance with all subprocesses to process definition in another KIE container.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process instance or Container Id not found"), @ApiResponse(code=404, message="Container Id not found"), @ApiResponse(code=201, response=MigrationReportInstanceList.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"migration-report-instance\": [\n    {\n      \"migration-successful\": true,\n      \"migration-start\": \"2018-10-15T15:12:47.194Z\",\n      \"migration-end\": \"2018-10-15T15:13:17.202Z\",\n      \"migration-logs\": [\n        \"15-Oct-2018 15:56:23: StartNode () - Human\\n15-Oct-2018 15:56:23: Join () - System\\n15-Oct-2018 15:56:23: RuleSetNode (Validation) - System\\n15-Oct-2018 15:56:23: Split () - System\\n15-Oct-2018 15:56:23: RuleSetNode (Retract Validation) - System\\n15-Oct-2018 15:56:23: HumanTaskNode (Correct Data) - System\\n15-Oct-2018 15:56:23: RuleSetNode (Retract Validation) Completed - System\\n15-Oct-2018 15:56:23: Split () Completed - System\\n15-Oct-2018 15:56:23: RuleSetNode (Validation) Completed - System\\n15-Oct-2018 15:56:23: Join () Completed - System\\n15-Oct-2018 15:56:23: StartNode () Completed - System\"\n      ],\n      \"migration-process-instance\": 5\n    },\n    {\n      \"migration-successful\": true,\n      \"migration-start\": \"2018-10-15T15:13:17.202Z\",\n      \"migration-end\": \"2018-10-15T15:13:47.194Z\",\n      \"migration-logs\": [\n        \"15-Oct-2018 15:56:23: StartNode () - Human\\n15-Oct-2018 15:56:23: Join () - System\\n15-Oct-2018 15:56:23: RuleSetNode (Validation) - System\\n15-Oct-2018 15:56:23: Split () - System\\n15-Oct-2018 15:56:23: RuleSetNode (Retract Validation) - System\\n15-Oct-2018 15:56:23: HumanTaskNode (Correct Data) - System\\n15-Oct-2018 15:56:23: RuleSetNode (Retract Validation) Completed - System\\n15-Oct-2018 15:56:23: Split () Completed - System\\n15-Oct-2018 15:56:23: RuleSetNode (Validation) Completed - System\\n15-Oct-2018 15:56:23: Join () Completed - System\\n15-Oct-2018 15:56:23: StartNode () Completed - System\"\n      ],\n      \"migration-process-instance\": 6\n    }\n  ]\n}")}))})
    @PUT
    @Path(value="instances/{processInstanceId}/subprocess")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response migrateProcessInstanceWithSubprocess(@Context HttpHeaders headers, @ApiParam(value="container id that process instances belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="list of identifiers of process instance to be migrated", required=true) @PathParam(value="processInstanceId") Long processInstanceId, @ApiParam(value="container id that new process definition belongs to", required=true) @QueryParam(value="targetContainerId") String targetContainerId, @ApiParam(value="process definition that process instances should be migrated to", required=true) @QueryParam(value="targetProcessId") String targetProcessId, @ApiParam(value="migration specifcation. It contains process mapping and node mapping - unique ids of old definition to new definition given as Map", required=false, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{ MigrationSpecification {\n   {         sourceProcessId : sourceProcessId, \n        targetProcessId : targetProcessId, \n        migration-nodes-map {\n            node1 : node2\n        }   }\n}"), @ExampleProperty(mediaType="application/xml", value="<MigrationSpecification>\n   <MigrationProcessSpecification>         <sourceProcessId>sourceProcessId</sourceProcessId> \n        <targetProcessId>targetProcessId</targetProcessId>, \n        <migration-nodes-map>                    <entry>\\n\" + \n                        <key>node 1</key>\\n\" + \n                        <value xsi:type=\\\"xs:int\\\" xmlns:xs=\\\"http://www.w3.org/2001/XMLSchema\\\"\\n \" +\n                               xmlns:xsi=\\\"http://www.w3.org/2001/XMLSchema-instance\\\">node 1 translate</value>\\n\" + \n                    </entry>\\n\" + \n        </migration-nodes-map>\n   </MigrationProcessSpecification></MigrationSpecification>")})) String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            MigrationReportInstanceList reportInstances = this.processAdminServiceBase.migrateProcessInstanceWithAllSubprocess(containerId, (Number)processInstanceId, targetContainerId, payload, type);
            return RestUtils.createCorrectVariant((Object)reportInstances, (HttpHeaders)headers, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Migrates multiple process instances to process definition in another KIE container.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process instance or Container Id not found"), @ApiResponse(code=404, message="Container Id not found"), @ApiResponse(code=201, response=MigrationReportInstanceList.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"migration-report-instance\": [\n    {\n      \"migration-successful\": true,\n      \"migration-start\": \"2018-10-15T15:12:47.194Z\",\n      \"migration-end\": \"2018-10-15T15:13:17.202Z\",\n      \"migration-logs\": [\n        \"15-Oct-2018 15:56:23: StartNode () - Human\\n15-Oct-2018 15:56:23: Join () - System\\n15-Oct-2018 15:56:23: RuleSetNode (Validation) - System\\n15-Oct-2018 15:56:23: Split () - System\\n15-Oct-2018 15:56:23: RuleSetNode (Retract Validation) - System\\n15-Oct-2018 15:56:23: HumanTaskNode (Correct Data) - System\\n15-Oct-2018 15:56:23: RuleSetNode (Retract Validation) Completed - System\\n15-Oct-2018 15:56:23: Split () Completed - System\\n15-Oct-2018 15:56:23: RuleSetNode (Validation) Completed - System\\n15-Oct-2018 15:56:23: Join () Completed - System\\n15-Oct-2018 15:56:23: StartNode () Completed - System\"\n      ],\n      \"migration-process-instance\": 5\n    },\n    {\n      \"migration-successful\": true,\n      \"migration-start\": \"2018-10-15T15:13:17.202Z\",\n      \"migration-end\": \"2018-10-15T15:13:47.194Z\",\n      \"migration-logs\": [\n        \"15-Oct-2018 15:56:23: StartNode () - Human\\n15-Oct-2018 15:56:23: Join () - System\\n15-Oct-2018 15:56:23: RuleSetNode (Validation) - System\\n15-Oct-2018 15:56:23: Split () - System\\n15-Oct-2018 15:56:23: RuleSetNode (Retract Validation) - System\\n15-Oct-2018 15:56:23: HumanTaskNode (Correct Data) - System\\n15-Oct-2018 15:56:23: RuleSetNode (Retract Validation) Completed - System\\n15-Oct-2018 15:56:23: Split () Completed - System\\n15-Oct-2018 15:56:23: RuleSetNode (Validation) Completed - System\\n15-Oct-2018 15:56:23: Join () Completed - System\\n15-Oct-2018 15:56:23: StartNode () Completed - System\"\n      ],\n      \"migration-process-instance\": 6\n    }\n  ]\n}")}))})
    @PUT
    @Path(value="instances")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response migrateProcessInstances(@Context HttpHeaders headers, @ApiParam(value="container id that process instances belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="list of identifiers of process instance to be migrated", required=true) @QueryParam(value="processInstanceId") List<Long> processInstanceIds, @ApiParam(value="container id that new process definition belongs to", required=true) @QueryParam(value="targetContainerId") String targetContainerId, @ApiParam(value="process definition that process instances should be migrated to", required=true) @QueryParam(value="targetProcessId") String targetProcessId, @ApiParam(value="node mapping - unique ids of old definition to new definition given as Map", required=false, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n    \"age\": 25,\n    \"name\": \"john\"\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<map-type>\n    <entries>\n        <entry>\n            <key>age</key>\n            <value xsi:type=\"xs:int\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n                    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">25</value>\n        </entry>\n        <entry>\n            <key>name</key>\n            <value xsi:type=\"xs:string\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n                    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">john</value>\n        </entry>\n    </entries>\n</map-type>")})) String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            MigrationReportInstanceList reportInstances = this.processAdminServiceBase.migrateProcessInstances(containerId, processInstanceIds, targetContainerId, targetProcessId, payload, type);
            return RestUtils.createCorrectVariant((Object)reportInstances, (HttpHeaders)headers, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceIds), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Aborts a specified node instance within a specified process instance.", response=Void.class, code=204)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process instance, node instance or Container Id not found")})
    @DELETE
    @Path(value="instances/{processInstanceId}/nodeinstances/{nodeInstanceId}")
    @Produces(value={"application/json", "application/xml"})
    public Response cancelNodeInstance(@Context HttpHeaders headers, @ApiParam(value="container id that process instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of process instance that node instance belongs to", required=true, example="123") @PathParam(value="processInstanceId") Long processInstanceId, @ApiParam(value="identifier of node instance that should be canceled", required=true, example="567") @PathParam(value="nodeInstanceId") Long nodeInstanceId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.processAdminServiceBase.cancelNodeInstance(containerId, (Number)processInstanceId, (Number)nodeInstanceId);
            return RestUtils.noContent((Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (NodeInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find node instance with id \"{0}\" within process instance with id \"{1}\"", nodeInstanceId, processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Re-triggers a specified node instance for a specified process instance. If the node is not active in the process instance, it becomes active upon re-triggering.", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process instance, node instance or Container Id not found")})
    @PUT
    @Path(value="instances/{processInstanceId}/nodeinstances/{nodeInstanceId}")
    @Produces(value={"application/json", "application/xml"})
    public Response retriggerNodeInstance(@Context HttpHeaders headers, @ApiParam(value="container id that process instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of process instance that node instance belongs to", required=true, example="123") @PathParam(value="processInstanceId") Long processInstanceId, @ApiParam(value="identifier of node instance that should be retriggered", required=true, example="567") @PathParam(value="nodeInstanceId") Long nodeInstanceId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.processAdminServiceBase.retriggerNodeInstance(containerId, (Number)processInstanceId, (Number)nodeInstanceId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (NodeInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find node instance with id \"{0}\" within process instance with id \"{1}\"", nodeInstanceId, processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Updates a specified timer for a specified process instance.", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process instance, node instance or Container Id not found")})
    @PUT
    @Path(value="instances/{processInstanceId}/timers/{timerId}")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Response updateTimer(@Context HttpHeaders headers, @ApiParam(value="container id that process instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of process instance that timer belongs to", required=true, example="123") @PathParam(value="processInstanceId") Long processInstanceId, @ApiParam(value="identifier of timer instance to be updated", required=true, example="99") @PathParam(value="timerId") Long timerId, @ApiParam(value="optional flag that indicates if the time expression is relative to the current date or not, defaults to true", required=false) @QueryParam(value="relative") @DefaultValue(value="true") boolean relative, @ApiParam(value="Map of timer expressions - deplay, perios and repeat are allowed values in the map", required=true, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"period\" : 0,\n  \"delay\" : 3,\n  \"repeatLimit\" : 0\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<map-type>\n    <entries>\n        <entry>\n            <key>period</key>\n            <value xsi:type=\"xs:long\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">0</value>\n        </entry>\n        <entry>\n            <key>delay</key>\n            <value xsi:type=\"xs:long\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">3</value>\n        </entry>\n        <entry>\n            <key>repeatLimit</key>\n            <value xsi:type=\"xs:int\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">0</value>\n        </entry>\n    </entries>\n</map-type>")})) String payload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String type = RestUtils.getContentType((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.processAdminServiceBase.updateTimer(containerId, (Number)processInstanceId, (Number)timerId, relative, payload, type);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (NodeInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find timer instance with id \"{0}\" within process instance with id \"{1}\"", timerId, processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Triggers a specified node for a specified process instance. If the node is not active in the process instance, it becomes active upon triggering.", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process instance, node instance or Container Id not found")})
    @POST
    @Path(value="instances/{processInstanceId}/nodes/{nodeId}")
    @Produces(value={"application/json", "application/xml"})
    public Response triggerNode(@Context HttpHeaders headers, @ApiParam(value="container id that process instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of process instance where node should be triggered", required=true, example="123") @PathParam(value="processInstanceId") Long processInstanceId, @ApiParam(value="identifier of the node to be triggered", required=true, example="567") @PathParam(value="nodeId") Long nodeId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.processAdminServiceBase.triggerNode(containerId, (Number)processInstanceId, (Number)nodeId);
            return RestUtils.createResponse((Object)"", (Variant)v, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (NodeNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find node with id \"{0}\" within process instance with id \"{1}\"", nodeId, processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns all timers for a specified process instance.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process instance or Container Id not found"), @ApiResponse(code=404, message="Container Id not found"), @ApiResponse(code=200, response=TimerInstanceList.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"timer-instance\": [\n    {\n      \"name\": \"MyTimer\",\n      \"id\": 1,\n      \"activation-time\": \"2018-10-18T04:49:28.907Z\",\n      \"last-fire-time\": \"2018-10-18T04:49:28.907Z\",\n      \"next-fire-time\": \"2018-10-18T04:49:28.907Z\",\n      \"delay\": 35000,\n      \"period\": 500000,\n      \"repeat-limit\": 2,\n      \"process-instance-id\": 6,\n      \"session-id\": 9\n    }\n  ]\n}")}))})
    @GET
    @Path(value="instances/{processInstanceId}/timers")
    @Produces(value={"application/json", "application/xml"})
    public Response getTimerInstances(@Context HttpHeaders headers, @ApiParam(value="container id that process instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of process instance that timer instances should be collected for", required=true, example="123") @PathParam(value="processInstanceId") Long processInstanceId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            TimerInstanceList timerInstanceList = this.processAdminServiceBase.getTimerInstances(containerId, (Number)processInstanceId);
            return RestUtils.createCorrectVariant((Object)timerInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns all the active node instances in a specified process instance.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process instance or Container Id not found"), @ApiResponse(code=200, response=NodeInstanceList.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"node-instance\": [\n    {\n      \"node-instance-id\": 1,\n      \"node-name\": \"Task\",\n      \"process-instance-id\": 2,\n      \"work-item-id\": 2,\n      \"container-id\": \"employee-rostering\",\n      \"start-date\": {\n        \"java.util.Date\": 1539184095048\n      },\n      \"node-id\": \"_5F8EED98-433C-4E7B-97BC-0E70615F13CB\",\n      \"node-type\": \"HumanTaskNode\",\n      \"node-connection\": \"_E89FEB0F-B8E1-4138-9DF0-397C9F9A6512\",\n      \"node-completed\": false,\n      \"reference-id\": null,\n      \"sla-compliance\": 0,\n      \"sla-due-date\": null\n    }\n  ]\n}")}))})
    @GET
    @Path(value="instances/{processInstanceId}/nodeinstances")
    @Produces(value={"application/json", "application/xml"})
    public Response getActiveNodeInstances(@Context HttpHeaders headers, @ApiParam(value="container id that process instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of process instance that active nodes instances should be collected for", required=true, example="123") @PathParam(value="processInstanceId") Long processInstanceId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            NodeInstanceList nodeInstanceList = this.processAdminServiceBase.getActiveNodeInstances(containerId, (Number)processInstanceId);
            return RestUtils.createCorrectVariant((Object)nodeInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns all nodes in a specified process instance.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process instance or Container Id not found"), @ApiResponse(code=200, response=ProcessNodeList.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"process-node\": [\n    {\n      \"name\": \"\",\n      \"id\": 1,\n      \"type\": \"StartNode\",\n      \"process-id\": \"Mortgage_Process.MortgageApprovalProcess\"\n    },\n    {\n      \"name\": \"\",\n      \"id\": 2,\n      \"type\": \"Join\",\n      \"process-id\": \"Mortgage_Process.MortgageApprovalProcess\"\n    },\n    {\n      \"name\": \"Validation\",\n      \"id\": 3,\n      \"type\": \"RuleSetNode\",\n      \"process-id\": \"Mortgage_Process.MortgageApprovalProcess\"\n    },\n    {\n      \"name\": \"\",\n      \"id\": 4,\n      \"type\": \"Split\",\n      \"process-id\": \"Mortgage_Process.MortgageApprovalProcess\"\n    },\n    {\n      \"name\": \"Retract Validation\",\n      \"id\": 5,\n      \"type\": \"RuleSetNode\",\n      \"process-id\": \"Mortgage_Process.MortgageApprovalProcess\"\n    },\n    {\n      \"name\": \"Correct Data\",\n      \"id\": 6,\n      \"type\": \"HumanTaskNode\",\n      \"process-id\": \"Mortgage_Process.MortgageApprovalProcess\"\n    },\n    {\n      \"name\": \"Mortgage Calculation\",\n      \"id\": 7,\n      \"type\": \"RuleSetNode\",\n      \"process-id\": \"Mortgage_Process.MortgageApprovalProcess\"\n    },\n    {\n      \"name\": \"Qualify\",\n      \"id\": 8,\n      \"type\": \"HumanTaskNode\",\n      \"process-id\": \"Mortgage_Process.MortgageApprovalProcess\"\n    },\n    {\n      \"name\": \"\",\n      \"id\": 9,\n      \"type\": \"Split\",\n      \"process-id\": \"Mortgage_Process.MortgageApprovalProcess\"\n    },\n    {\n      \"name\": \"Final Approval\",\n      \"id\": 10,\n      \"type\": \"HumanTaskNode\",\n      \"process-id\": \"Mortgage_Process.MortgageApprovalProcess\"\n    },\n    {\n      \"name\": \"\",\n      \"id\": 11,\n      \"type\": \"EndNode\",\n      \"process-id\": \"Mortgage_Process.MortgageApprovalProcess\"\n    },\n    {\n      \"name\": \"Increase Down Payment\",\n      \"id\": 12,\n      \"type\": \"HumanTaskNode\",\n      \"process-id\": \"Mortgage_Process.MortgageApprovalProcess\"\n    },\n    {\n      \"name\": \"\",\n      \"id\": 13,\n      \"type\": \"Split\",\n      \"process-id\": \"Mortgage_Process.MortgageApprovalProcess\"\n    },\n    {\n      \"name\": \"\",\n      \"id\": 14,\n      \"type\": \"EndNode\",\n      \"process-id\": \"Mortgage_Process.MortgageApprovalProcess\"\n    }\n  ]\n}")}))})
    @GET
    @Path(value="instances/{processInstanceId}/nodes")
    @Produces(value={"application/json", "application/xml"})
    public Response getNodes(@Context HttpHeaders headers, @ApiParam(value="container id that process instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of process instance that process nodes should be collected from", required=true, example="123") @PathParam(value="processInstanceId") Long processInstanceId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            ProcessNodeList processNodeList = this.processAdminServiceBase.getProcessNodes(containerId, (Number)processInstanceId);
            return RestUtils.createCorrectVariant((Object)processNodeList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ProcessInstanceNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find process instance with id \"{0}\"", processInstanceId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Acknowledges a specified process execution error (sets acknowledged to true for the error).", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Execution error or Container Id not found")})
    @PUT
    @Path(value="errors/{errorId}")
    @Produces(value={"application/json", "application/xml"})
    public Response acknowledgeError(@Context HttpHeaders headers, @ApiParam(value="container id that error belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of error to be acknowledged", required=true, example="xxx-yyy-zzz") @PathParam(value="errorId") String errorId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.processAdminServiceBase.acknowledgeError(containerId, Arrays.asList(errorId));
            return RestUtils.createCorrectVariant((Object)"", (HttpHeaders)headers, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ExecutionErrorNotFoundException e) {
            return RestUtils.notFound((String)e.getMessage(), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Acknowledges multiple process execution errors (sets acknowledged to true for the errors).", response=Void.class, code=201)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Execution error or Container Id not found")})
    @PUT
    @Path(value="errors")
    @Produces(value={"application/json", "application/xml"})
    public Response acknowledgeErrors(@Context HttpHeaders headers, @ApiParam(value="container id that errors belong to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="list of error identifiers to be acknowledged", required=true, example="xxx-yyy-zzz") @QueryParam(value="errorId") List<String> errorIds) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            this.processAdminServiceBase.acknowledgeError(containerId, errorIds);
            return RestUtils.createCorrectVariant((Object)"", (HttpHeaders)headers, (Response.Status)Response.Status.CREATED, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ExecutionErrorNotFoundException e) {
            return RestUtils.notFound((String)e.getMessage(), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns information about a specified process execution error.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process instance or Container Id not found"), @ApiResponse(code=200, response=ExecutionErrorInstance.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n      \"id\": \"a7982044-019d-4d4a-be3f-781f4ddca1df\",\n      \"type\": \"Process\",\n      \"container-id\": \"mortgage-process_1.0.0-SNAPSHOT\",\n      \"process-instance-id\": 4,\n      \"process-id\": \"Mortgage_Process.MortgageApprovalProcess\",\n      \"activity-id\": 12,\n      \"activity-name\": \"Validation\",\n      \"job-id\": null,\n      \"error-msg\": \"[Mortgage_Process.MortgageApprovalProcess:4 - Validation:3] -- [Mortgage_Process.MortgageApprovalProcess:4 - Validation:3] -- null\",\n      \"error\": null,\n      \"acknowledged\": false,\n      \"acknowledged-by\": null,\n      \"acknowledged-at\": null,\n      \"error-date\": 1539627364193\n    }")}))})
    @GET
    @Path(value="errors/{errorId}")
    @Produces(value={"application/json", "application/xml"})
    public Response getExecutionErrorById(@Context HttpHeaders headers, @ApiParam(value="container id that process error belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of error to be loaded", required=true, example="xxx-yyy-zzz") @PathParam(value="errorId") String errorId) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            ExecutionErrorInstance executionErrorInstance = this.processAdminServiceBase.getError(containerId, errorId);
            return RestUtils.createCorrectVariant((Object)executionErrorInstance, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ExecutionErrorNotFoundException e) {
            return RestUtils.notFound((String)e.getMessage(), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns all process execution errors for a specified process instance.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Container Id not found"), @ApiResponse(code=200, response=ExecutionErrorInstanceList.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"error-instance\": [\n    {\n      \"id\": \"54b04160-6242-475d-9452-0df3678123b0\",\n      \"type\": \"Process\",\n      \"container-id\": \"mortgage-process_1.0.0-SNAPSHOT\",\n      \"process-instance-id\": 4,\n      \"process-id\": \"Mortgage_Process.MortgageApprovalProcess\",\n      \"activity-id\": 12,\n      \"activity-name\": \"Validation\",\n      \"job-id\": null,\n      \"error-msg\": \"[Mortgage_Process.MortgageApprovalProcess:4 - Validation:3] -- [Mortgage_Process.MortgageApprovalProcess:4 - Validation:3] -- null\",\n      \"error\": null,\n      \"acknowledged\": false,\n      \"acknowledged-by\": null,\n      \"acknowledged-at\": null,\n      \"error-date\": 1539627373788\n    },\n    {\n      \"id\": \"a7982044-019d-4d4a-be3f-781f4ddca1df\",\n      \"type\": \"Process\",\n      \"container-id\": \"mortgage-process_1.0.0-SNAPSHOT\",\n      \"process-instance-id\": 4,\n      \"process-id\": \"Mortgage_Process.MortgageApprovalProcess\",\n      \"activity-id\": 12,\n      \"activity-name\": \"Validation\",\n      \"job-id\": null,\n      \"error-msg\": \"[Mortgage_Process.MortgageApprovalProcess:4 - Validation:3] -- [Mortgage_Process.MortgageApprovalProcess:4 - Validation:3] -- null\",\n      \"error\": null,\n      \"acknowledged\": false,\n      \"acknowledged-by\": null,\n      \"acknowledged-at\": null,\n      \"error-date\": 1539627364193\n    }\n  ]\n}")}))})
    @GET
    @Path(value="instances/{processInstanceId}/errors")
    @Produces(value={"application/json", "application/xml"})
    public Response getExecutionErrorsByProcessInstance(@Context HttpHeaders headers, @ApiParam(value="container id that process instance belongs to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="identifier of process instance that errors should be collected for", required=true, example="123") @PathParam(value="processInstanceId") Long processInstanceId, @ApiParam(value="optional flag that indicates if acknowledged errors should also be collected, defaults to false", required=false) @QueryParam(value="includeAck") @DefaultValue(value="false") boolean includeAcknowledged, @ApiParam(value="optional name of the node in the process instance to filter by", required=false) @QueryParam(value="node") String nodeName, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            ExecutionErrorInstanceList executionErrorInstanceList = this.processAdminServiceBase.getExecutionErrorsByProcessInstance(containerId, (Number)processInstanceId, nodeName, includeAcknowledged, page, pageSize, sort, sortOrder);
            return RestUtils.createCorrectVariant((Object)executionErrorInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ExecutionErrorNotFoundException e) {
            return RestUtils.notFound((String)e.getMessage(), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }

    @ApiOperation(value="Returns all process execution errors for a specified KIE container.")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error"), @ApiResponse(code=404, message="Process instance or Container Id not found"), @ApiResponse(code=200, response=ExecutionErrorInstanceList.class, message="Successful response", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"error-instance\": [\n    {\n      \"id\": \"54b04160-6242-475d-9452-0df3678123b0\",\n      \"type\": \"Process\",\n      \"container-id\": \"mortgage-process_1.0.0-SNAPSHOT\",\n      \"process-instance-id\": 4,\n      \"process-id\": \"Mortgage_Process.MortgageApprovalProcess\",\n      \"activity-id\": 12,\n      \"activity-name\": \"Validation\",\n      \"job-id\": null,\n      \"error-msg\": \"[Mortgage_Process.MortgageApprovalProcess:4 - Validation:3] -- [Mortgage_Process.MortgageApprovalProcess:4 - Validation:3] -- null\",\n      \"error\": null,\n      \"acknowledged\": false,\n      \"acknowledged-by\": null,\n      \"acknowledged-at\": null,\n      \"error-date\": 1539627373788\n    },\n    {\n      \"id\": \"a7982044-019d-4d4a-be3f-781f4ddca1df\",\n      \"type\": \"Process\",\n      \"container-id\": \"mortgage-process_1.0.0-SNAPSHOT\",\n      \"process-instance-id\": 4,\n      \"process-id\": \"Mortgage_Process.MortgageApprovalProcess\",\n      \"activity-id\": 12,\n      \"activity-name\": \"Validation\",\n      \"job-id\": null,\n      \"error-msg\": \"[Mortgage_Process.MortgageApprovalProcess:4 - Validation:3] -- [Mortgage_Process.MortgageApprovalProcess:4 - Validation:3] -- null\",\n      \"error\": null,\n      \"acknowledged\": false,\n      \"acknowledged-by\": null,\n      \"acknowledged-at\": null,\n      \"error-date\": 1539627364193\n    }\n  ]\n}")}))})
    @GET
    @Path(value="errors")
    @Produces(value={"application/json", "application/xml"})
    public Response getExecutionErrors(@Context HttpHeaders headers, @ApiParam(value="container id that errors belong to", required=true, example="evaluation_1.0.0-SNAPSHOT") @PathParam(value="containerId") String containerId, @ApiParam(value="optional flag that indicates if acknowledged errors should also be collected, defaults to false", required=false) @QueryParam(value="includeAck") @DefaultValue(value="false") boolean includeAcknowledged, @ApiParam(value="optional pagination - at which page to start, defaults to 0 (meaning first)", required=false) @QueryParam(value="page") @DefaultValue(value="0") Integer page, @ApiParam(value="optional pagination - size of the result, defaults to 10", required=false) @QueryParam(value="pageSize") @DefaultValue(value="10") Integer pageSize, @ApiParam(value="optional sort column, no default", required=false) @QueryParam(value="sort") String sort, @ApiParam(value="optional sort direction (asc, desc) - defaults to asc", required=false) @QueryParam(value="sortOrder") @DefaultValue(value="true") boolean sortOrder) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)containerId, (KieServerRegistry)this.context, (HttpHeaders)headers);
        try {
            ExecutionErrorInstanceList executionErrorInstanceList = this.processAdminServiceBase.getExecutionErrors(containerId, includeAcknowledged, page, pageSize, sort, sortOrder);
            return RestUtils.createCorrectVariant((Object)executionErrorInstanceList, (HttpHeaders)headers, (Response.Status)Response.Status.OK, (Header[])new Header[]{conversationIdHeader});
        }
        catch (ExecutionErrorNotFoundException e) {
            return RestUtils.notFound((String)e.getMessage(), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (DeploymentNotFoundException e) {
            return RestUtils.notFound((String)MessageFormat.format("Could not find container \"{0}\"", containerId), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
        catch (Exception e) {
            logger.error("Unexpected error during processing {}", (Object)e.getMessage(), (Object)e);
            return RestUtils.internalServerError((String)RestUtils.errorMessage((Throwable)e), (Variant)v, (Header[])new Header[]{conversationIdHeader});
        }
    }
}

