/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router.client;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.UrlMatchingStrategy;
import com.github.tomakehurst.wiremock.client.WireMock;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceFilter;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieScannerResource;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.api.model.KieServerStateInfo;
import org.kie.server.api.model.KieServiceResponse;
import org.kie.server.api.model.Message;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.router.client.KieServerRouterEventListener;
import org.kie.server.services.api.KieContainerInstance;
import org.kie.server.services.api.KieServer;
import org.kie.server.services.impl.KieContainerInstanceImpl;

public class KieServerRouterEventListenerRetryTest {
    private WireMockServer wireMockServer = null;
    private KieServerRouterEventListener client = null;
    private KieContainerInstance containerInstance = new KieContainerInstanceImpl("test-container", KieContainerStatus.STARTED, null, new ReleaseId("org.test", "test-kjar", "1.0"));

    public static int findFreePort() {
        int port = 0;
        try {
            ServerSocket server = new ServerSocket(0);
            port = server.getLocalPort();
            server.close();
        }
        catch (IOException e) {
            port = 9789;
        }
        return port;
    }

    @After
    public void cleanup() {
        if (this.client != null) {
            this.client.close();
        }
        if (this.wireMockServer != null) {
            this.wireMockServer.stop();
        }
    }

    @Test(timeout=10000L)
    public void testRouterContainerStartedRetry() throws Exception {
        final CountDownLatch failureLatch = new CountDownLatch(2);
        final CountDownLatch successLatch = new CountDownLatch(1);
        int routerPort = KieServerRouterEventListenerRetryTest.findFreePort();
        this.client = new KieServerRouterEventListener("test-server", "http://localhost:8080/kie-server", "http://localhost:" + routerPort, 2);
        this.client.setObserver(new KieServerRouterEventListener.RouterConnectionObserver(){

            public void onSuccess(String url) {
                successLatch.countDown();
            }

            public void onFailure(String url) {
                failureLatch.countDown();
            }
        });
        this.wireMockServer = this.createMockServer(routerPort, "/mgmt/add");
        this.client.afterContainerStarted(null, this.containerInstance);
        failureLatch.await();
        this.wireMockServer.start();
        successLatch.await();
        this.wireMockServer.verify(1, WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/mgmt/add")));
    }

    @Test(timeout=10000L)
    public void testRouterContainerStoppedRetry() throws Exception {
        final CountDownLatch failureLatch = new CountDownLatch(2);
        final CountDownLatch successLatch = new CountDownLatch(1);
        int routerPort = KieServerRouterEventListenerRetryTest.findFreePort();
        this.client = new KieServerRouterEventListener("test-server", "http://localhost:8080/kie-server", "http://localhost:" + routerPort, 2);
        this.client.setObserver(new KieServerRouterEventListener.RouterConnectionObserver(){

            public void onSuccess(String url) {
                successLatch.countDown();
            }

            public void onFailure(String url) {
                failureLatch.countDown();
            }
        });
        this.wireMockServer = this.createMockServer(routerPort, "/mgmt/remove");
        this.client.afterContainerStopped(null, this.containerInstance);
        failureLatch.await();
        this.wireMockServer.start();
        successLatch.await();
        this.wireMockServer.verify(1, WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/mgmt/remove")));
    }

    @Test(timeout=10000L)
    public void testRouterServerStoppedRetry() throws Exception {
        final CountDownLatch failureLatch = new CountDownLatch(1);
        final CountDownLatch successLatch = new CountDownLatch(1);
        int routerPort = KieServerRouterEventListenerRetryTest.findFreePort();
        this.client = new KieServerRouterEventListener("test-server", "http://localhost:8080/kie-server", "http://localhost:" + routerPort, 2);
        this.client.setObserver(new KieServerRouterEventListener.RouterConnectionObserver(){

            public void onSuccess(String url) {
                successLatch.countDown();
            }

            public void onFailure(String url) {
                failureLatch.countDown();
            }
        });
        this.wireMockServer = this.createMockServer(routerPort, "/mgmt/remove");
        this.client.beforeServerStopped(new KieServer(){

            public ServiceResponse<KieServerInfo> getInfo() {
                return null;
            }

            public ServiceResponse<KieContainerResource> createContainer(String containerId, KieContainerResource container) {
                return null;
            }

            public ServiceResponse<KieContainerResourceList> listContainers(KieContainerResourceFilter containerFilter) {
                KieContainerResource containerResource = new KieContainerResource(KieServerRouterEventListenerRetryTest.this.containerInstance.getContainerId(), KieServerRouterEventListenerRetryTest.this.containerInstance.getResource().getReleaseId(), KieServerRouterEventListenerRetryTest.this.containerInstance.getStatus());
                ArrayList<KieContainerResource> containers = new ArrayList<KieContainerResource>();
                containers.add(containerResource);
                KieContainerResourceList list = new KieContainerResourceList(containers);
                return new ServiceResponse(KieServiceResponse.ResponseType.SUCCESS, "", (Object)list);
            }

            public ServiceResponse<KieContainerResource> getContainerInfo(String id) {
                return null;
            }

            public ServiceResponse<Void> disposeContainer(String containerId) {
                return null;
            }

            public ServiceResponse<KieScannerResource> getScannerInfo(String id) {
                return null;
            }

            public ServiceResponse<KieScannerResource> updateScanner(String id, KieScannerResource resource) {
                return null;
            }

            public ServiceResponse<ReleaseId> getContainerReleaseId(String id) {
                return null;
            }

            public ServiceResponse<ReleaseId> updateContainerReleaseId(String id, ReleaseId releaseId) {
                return null;
            }

            public ServiceResponse<KieServerStateInfo> getServerState() {
                return null;
            }

            public void addServerMessage(Message message) {
            }

            public void addContainerMessage(String containerId, Message message) {
            }
        });
        failureLatch.await();
        this.wireMockServer.start();
        boolean met = successLatch.await(4L, TimeUnit.SECONDS);
        Assert.assertFalse((String)"On success should not be invoked", (boolean)met);
        this.wireMockServer.verify(0, WireMock.postRequestedFor((UrlMatchingStrategy)WireMock.urlEqualTo((String)"/mgmt/remove")));
    }

    protected WireMockServer createMockServer(int port, String url) {
        WireMockServer wireMockServer = new WireMockServer(port);
        wireMockServer.stubFor(WireMock.post((UrlMatchingStrategy)WireMock.urlEqualTo((String)url)).withHeader("Accept", WireMock.equalTo((String)"application/json")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/json").withBody("")));
        return wireMockServer;
    }
}

