/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router.handlers;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.server.router.handlers.KieServerInfoHandler;

public class KieServerInfoHandlerTest {
    @Before
    public void setUp() {
        System.setProperty("org.kie.server.router.host", "localhost");
        System.setProperty("org.kie.server.router.port", "9000");
    }

    @After
    public void tearDown() {
        System.clearProperty("org.kie.server.router.host");
        System.clearProperty("org.kie.server.router.port");
        System.clearProperty("org.kie.server.router.url.external");
    }

    @Test
    public void testGetLocationUrl() {
        String locationUrl = KieServerInfoHandler.getLocationUrl();
        Assert.assertEquals((Object)"http://localhost:9000/", (Object)locationUrl);
    }

    @Test
    public void testGetLocationUrlExternalLocation() {
        System.setProperty("org.kie.server.router.url.external", "https://my-domain:8900/");
        String locationUrl = KieServerInfoHandler.getLocationUrl();
        Assert.assertEquals((Object)"https://my-domain:8900/", (Object)locationUrl);
    }
}

