/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router.proxy.aggregate;

import java.util.ArrayList;
import org.jboss.logging.Logger;
import org.junit.Assert;
import org.junit.Test;
import org.kie.server.router.proxy.aggragate.JaxbXMLResponseAggregator;
import org.kie.server.router.proxy.aggregate.AbstractAggregateTest;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class JAXBAggregatorTest
extends AbstractAggregateTest {
    private static final Logger logger = Logger.getLogger(JAXBAggregatorTest.class);

    @Test
    public void testAggregateProcessDefinitions() throws Exception {
        String xml1 = this.read(this.getClass().getResourceAsStream("/jaxb/process-def-1.xml"));
        String xml2 = this.read(this.getClass().getResourceAsStream("/jaxb/process-def-2.xml"));
        JaxbXMLResponseAggregator aggregate = new JaxbXMLResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(xml1);
        data.add(xml2);
        String result = aggregate.aggregate(data);
        logger.debug((Object)result);
        Document xml = this.toXml(result);
        Assert.assertNotNull((Object)xml);
        NodeList processes = xml.getElementsByTagName("process-definitions");
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.getLength());
        NodeList processDefs = xml.getElementsByTagName("processes");
        Assert.assertNotNull((Object)processDefs);
        Assert.assertEquals((long)5L, (long)processDefs.getLength());
    }

    @Test
    public void testAggregateProcessDefinitionsTargetEmpty() throws Exception {
        String xml1 = this.read(this.getClass().getResourceAsStream("/jaxb/process-def-1.xml"));
        String xml2 = this.read(this.getClass().getResourceAsStream("/jaxb/process-def-empty.xml"));
        JaxbXMLResponseAggregator aggregate = new JaxbXMLResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(xml1);
        data.add(xml2);
        String result = aggregate.aggregate(data);
        logger.debug((Object)result);
        Document xml = this.toXml(result);
        Assert.assertNotNull((Object)xml);
        NodeList processes = xml.getElementsByTagName("process-definitions");
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.getLength());
        NodeList processDefs = xml.getElementsByTagName("processes");
        Assert.assertNotNull((Object)processDefs);
        Assert.assertEquals((long)2L, (long)processDefs.getLength());
    }

    @Test
    public void testAggregateProcessDefinitionsSourceEmpty() throws Exception {
        String xml1 = this.read(this.getClass().getResourceAsStream("/jaxb/process-def-empty.xml"));
        String xml2 = this.read(this.getClass().getResourceAsStream("/jaxb/process-def-2.xml"));
        JaxbXMLResponseAggregator aggregate = new JaxbXMLResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(xml1);
        data.add(xml2);
        String result = aggregate.aggregate(data);
        logger.debug((Object)result);
        Document xml = this.toXml(result);
        Assert.assertNotNull((Object)xml);
        NodeList processes = xml.getElementsByTagName("process-definitions");
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.getLength());
        NodeList processDefs = xml.getElementsByTagName("processes");
        Assert.assertNotNull((Object)processDefs);
        Assert.assertEquals((long)3L, (long)processDefs.getLength());
    }

    @Test
    public void testAggregateProcessDefinitionsEmpty() throws Exception {
        String xml1 = this.read(this.getClass().getResourceAsStream("/jaxb/process-def-empty.xml"));
        String xml2 = this.read(this.getClass().getResourceAsStream("/jaxb/process-def-empty.xml"));
        JaxbXMLResponseAggregator aggregate = new JaxbXMLResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(xml1);
        data.add(xml2);
        String result = aggregate.aggregate(data);
        logger.debug((Object)result);
        Document xml = this.toXml(result);
        Assert.assertNotNull((Object)xml);
        NodeList processes = xml.getElementsByTagName("process-definitions");
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.getLength());
        NodeList processDefs = xml.getElementsByTagName("processes");
        Assert.assertNotNull((Object)processDefs);
        Assert.assertEquals((long)0L, (long)processDefs.getLength());
    }

    @Test
    public void testAggregateProcessInstances() throws Exception {
        String xml1 = this.read(this.getClass().getResourceAsStream("/jaxb/process-instance-1.xml"));
        String xml2 = this.read(this.getClass().getResourceAsStream("/jaxb/process-instance-2.xml"));
        JaxbXMLResponseAggregator aggregate = new JaxbXMLResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(xml1);
        data.add(xml2);
        String result = aggregate.aggregate(data);
        logger.debug((Object)result);
        Document xml = this.toXml(result);
        Assert.assertNotNull((Object)xml);
        NodeList processes = xml.getElementsByTagName("process-instance-list");
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.getLength());
        NodeList processInstances = xml.getElementsByTagName("process-instance");
        Assert.assertNotNull((Object)processInstances);
        Assert.assertEquals((long)4L, (long)processInstances.getLength());
    }

    @Test
    public void testAggregateProcessInstancesTargetEmpty() throws Exception {
        String xml1 = this.read(this.getClass().getResourceAsStream("/jaxb/process-instance-1.xml"));
        String xml2 = this.read(this.getClass().getResourceAsStream("/jaxb/process-instance-empty.xml"));
        JaxbXMLResponseAggregator aggregate = new JaxbXMLResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(xml1);
        data.add(xml2);
        String result = aggregate.aggregate(data);
        logger.debug((Object)result);
        Document xml = this.toXml(result);
        Assert.assertNotNull((Object)xml);
        NodeList processes = xml.getElementsByTagName("process-instance-list");
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.getLength());
        NodeList processInstances = xml.getElementsByTagName("process-instance");
        Assert.assertNotNull((Object)processInstances);
        Assert.assertEquals((long)1L, (long)processInstances.getLength());
    }

    @Test
    public void testAggregateProcessInstancesSourceEmpty() throws Exception {
        String xml1 = this.read(this.getClass().getResourceAsStream("/jaxb/process-instance-empty.xml"));
        String xml2 = this.read(this.getClass().getResourceAsStream("/jaxb/process-instance-2.xml"));
        JaxbXMLResponseAggregator aggregate = new JaxbXMLResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(xml1);
        data.add(xml2);
        String result = aggregate.aggregate(data);
        logger.debug((Object)result);
        Document xml = this.toXml(result);
        Assert.assertNotNull((Object)xml);
        NodeList processes = xml.getElementsByTagName("process-instance-list");
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.getLength());
        NodeList processInstances = xml.getElementsByTagName("process-instance");
        Assert.assertNotNull((Object)processInstances);
        Assert.assertEquals((long)3L, (long)processInstances.getLength());
    }

    @Test
    public void testAggregateProcessInstancesEmpty() throws Exception {
        String xml1 = this.read(this.getClass().getResourceAsStream("/jaxb/process-instance-empty.xml"));
        String xml2 = this.read(this.getClass().getResourceAsStream("/jaxb/process-instance-empty.xml"));
        JaxbXMLResponseAggregator aggregate = new JaxbXMLResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(xml1);
        data.add(xml2);
        String result = aggregate.aggregate(data);
        logger.debug((Object)result);
        Document xml = this.toXml(result);
        Assert.assertNotNull((Object)xml);
        NodeList processes = xml.getElementsByTagName("process-instance-list");
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.getLength());
        NodeList processInstances = xml.getElementsByTagName("process-instance");
        Assert.assertNotNull((Object)processInstances);
        Assert.assertEquals((long)0L, (long)processInstances.getLength());
    }

    @Test
    public void testAggregateTaskSummaries() throws Exception {
        String xml1 = this.read(this.getClass().getResourceAsStream("/jaxb/task-summary-1.xml"));
        String xml2 = this.read(this.getClass().getResourceAsStream("/jaxb/task-summary-2.xml"));
        JaxbXMLResponseAggregator aggregate = new JaxbXMLResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(xml1);
        data.add(xml2);
        String result = aggregate.aggregate(data);
        logger.debug((Object)result);
        Document xml = this.toXml(result);
        Assert.assertNotNull((Object)xml);
        NodeList processes = xml.getElementsByTagName("task-summary-list");
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.getLength());
        NodeList processInstances = xml.getElementsByTagName("task-summary");
        Assert.assertNotNull((Object)processInstances);
        Assert.assertEquals((long)5L, (long)processInstances.getLength());
    }

    @Test
    public void testAggregateTaskSummariesTargetEmpty() throws Exception {
        String xml1 = this.read(this.getClass().getResourceAsStream("/jaxb/task-summary-1.xml"));
        String xml2 = this.read(this.getClass().getResourceAsStream("/jaxb/task-summary-empty.xml"));
        JaxbXMLResponseAggregator aggregate = new JaxbXMLResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(xml1);
        data.add(xml2);
        String result = aggregate.aggregate(data);
        logger.debug((Object)result);
        Document xml = this.toXml(result);
        Assert.assertNotNull((Object)xml);
        NodeList processes = xml.getElementsByTagName("task-summary-list");
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.getLength());
        NodeList processInstances = xml.getElementsByTagName("task-summary");
        Assert.assertNotNull((Object)processInstances);
        Assert.assertEquals((long)3L, (long)processInstances.getLength());
    }

    @Test
    public void testAggregateTaskSummariesSourceEmpty() throws Exception {
        String xml1 = this.read(this.getClass().getResourceAsStream("/jaxb/task-summary-empty.xml"));
        String xml2 = this.read(this.getClass().getResourceAsStream("/jaxb/task-summary-2.xml"));
        JaxbXMLResponseAggregator aggregate = new JaxbXMLResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(xml1);
        data.add(xml2);
        String result = aggregate.aggregate(data);
        logger.debug((Object)result);
        Document xml = this.toXml(result);
        Assert.assertNotNull((Object)xml);
        NodeList processes = xml.getElementsByTagName("task-summary-list");
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.getLength());
        NodeList processInstances = xml.getElementsByTagName("task-summary");
        Assert.assertNotNull((Object)processInstances);
        Assert.assertEquals((long)2L, (long)processInstances.getLength());
    }

    @Test
    public void testAggregateTaskSummariesEmpty() throws Exception {
        String xml1 = this.read(this.getClass().getResourceAsStream("/jaxb/task-summary-empty.xml"));
        String xml2 = this.read(this.getClass().getResourceAsStream("/jaxb/task-summary-empty.xml"));
        JaxbXMLResponseAggregator aggregate = new JaxbXMLResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(xml1);
        data.add(xml2);
        String result = aggregate.aggregate(data);
        logger.debug((Object)result);
        Document xml = this.toXml(result);
        Assert.assertNotNull((Object)xml);
        NodeList processes = xml.getElementsByTagName("task-summary-list");
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.getLength());
        NodeList processInstances = xml.getElementsByTagName("task-summary");
        Assert.assertNotNull((Object)processInstances);
        Assert.assertEquals((long)0L, (long)processInstances.getLength());
    }

    @Test
    public void testSortProcessDefinitions() throws Exception {
        String xml1 = this.read(this.getClass().getResourceAsStream("/jaxb/process-def-1.xml"));
        String xml2 = this.read(this.getClass().getResourceAsStream("/jaxb/process-def-2.xml"));
        JaxbXMLResponseAggregator aggregate = new JaxbXMLResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(xml1);
        data.add(xml2);
        String result = aggregate.aggregate(data, "ProcessId", true, Integer.valueOf(0), Integer.valueOf(2));
        logger.debug((Object)result);
        Document xml = this.toXml(result);
        Assert.assertNotNull((Object)xml);
        NodeList processes = xml.getElementsByTagName("process-definitions");
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.getLength());
        NodeList processDefs = xml.getElementsByTagName("processes");
        Assert.assertNotNull((Object)processDefs);
        Assert.assertEquals((long)2L, (long)processDefs.getLength());
        NodeList processDefIds = xml.getElementsByTagName("process-id");
        Assert.assertNotNull((Object)processDefIds);
        Assert.assertEquals((long)2L, (long)processDefIds.getLength());
        String value1 = processDefIds.item(0).getFirstChild().getNodeValue();
        Assert.assertEquals((Object)"1", (Object)value1);
        String value2 = processDefIds.item(1).getFirstChild().getNodeValue();
        Assert.assertEquals((Object)"2", (Object)value2);
    }

    @Test
    public void testSortProcessDefinitionsDescending() throws Exception {
        String xml1 = this.read(this.getClass().getResourceAsStream("/jaxb/process-def-1.xml"));
        String xml2 = this.read(this.getClass().getResourceAsStream("/jaxb/process-def-2.xml"));
        JaxbXMLResponseAggregator aggregate = new JaxbXMLResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(xml1);
        data.add(xml2);
        String result = aggregate.aggregate(data, "ProcessId", false, Integer.valueOf(0), Integer.valueOf(2));
        logger.debug((Object)result);
        Document xml = this.toXml(result);
        Assert.assertNotNull((Object)xml);
        NodeList processes = xml.getElementsByTagName("process-definitions");
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.getLength());
        NodeList processDefs = xml.getElementsByTagName("processes");
        Assert.assertNotNull((Object)processDefs);
        Assert.assertEquals((long)2L, (long)processDefs.getLength());
        NodeList processDefIds = xml.getElementsByTagName("process-id");
        Assert.assertNotNull((Object)processDefIds);
        Assert.assertEquals((long)2L, (long)processDefIds.getLength());
        String value1 = processDefIds.item(0).getFirstChild().getNodeValue();
        Assert.assertEquals((Object)"5", (Object)value1);
        String value2 = processDefIds.item(1).getFirstChild().getNodeValue();
        Assert.assertEquals((Object)"4", (Object)value2);
    }

    @Test
    public void testSortProcessDefinitionsNextPage() throws Exception {
        String xml1 = this.read(this.getClass().getResourceAsStream("/jaxb/process-def-1.xml"));
        String xml2 = this.read(this.getClass().getResourceAsStream("/jaxb/process-def-2.xml"));
        JaxbXMLResponseAggregator aggregate = new JaxbXMLResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(xml1);
        data.add(xml2);
        String result = aggregate.aggregate(data, "ProcessId", true, Integer.valueOf(1), Integer.valueOf(2));
        logger.debug((Object)result);
        Document xml = this.toXml(result);
        Assert.assertNotNull((Object)xml);
        NodeList processes = xml.getElementsByTagName("process-definitions");
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.getLength());
        NodeList processDefs = xml.getElementsByTagName("processes");
        Assert.assertNotNull((Object)processDefs);
        Assert.assertEquals((long)2L, (long)processDefs.getLength());
        NodeList processDefIds = xml.getElementsByTagName("process-id");
        Assert.assertNotNull((Object)processDefIds);
        Assert.assertEquals((long)2L, (long)processDefIds.getLength());
        String value1 = processDefIds.item(0).getFirstChild().getNodeValue();
        Assert.assertEquals((Object)"3", (Object)value1);
        String value2 = processDefIds.item(1).getFirstChild().getNodeValue();
        Assert.assertEquals((Object)"4", (Object)value2);
    }

    @Test
    public void testSortProcessDefinitionsNextPageDescending() throws Exception {
        String xml1 = this.read(this.getClass().getResourceAsStream("/jaxb/process-def-1.xml"));
        String xml2 = this.read(this.getClass().getResourceAsStream("/jaxb/process-def-2.xml"));
        JaxbXMLResponseAggregator aggregate = new JaxbXMLResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(xml1);
        data.add(xml2);
        String result = aggregate.aggregate(data, "ProcessId", false, Integer.valueOf(1), Integer.valueOf(2));
        logger.debug((Object)result);
        Document xml = this.toXml(result);
        Assert.assertNotNull((Object)xml);
        NodeList processes = xml.getElementsByTagName("process-definitions");
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.getLength());
        NodeList processDefs = xml.getElementsByTagName("processes");
        Assert.assertNotNull((Object)processDefs);
        Assert.assertEquals((long)2L, (long)processDefs.getLength());
        NodeList processDefIds = xml.getElementsByTagName("process-id");
        Assert.assertNotNull((Object)processDefIds);
        Assert.assertEquals((long)2L, (long)processDefIds.getLength());
        String value1 = processDefIds.item(0).getFirstChild().getNodeValue();
        Assert.assertEquals((Object)"3", (Object)value1);
        String value2 = processDefIds.item(1).getFirstChild().getNodeValue();
        Assert.assertEquals((Object)"2", (Object)value2);
    }

    @Test
    public void testSortProcessDefinitionsOutOPage() throws Exception {
        String xml1 = this.read(this.getClass().getResourceAsStream("/jaxb/process-def-1.xml"));
        String xml2 = this.read(this.getClass().getResourceAsStream("/jaxb/process-def-2.xml"));
        JaxbXMLResponseAggregator aggregate = new JaxbXMLResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(xml1);
        data.add(xml2);
        String result = aggregate.aggregate(data, "ProcessId", true, Integer.valueOf(5), Integer.valueOf(2));
        logger.debug((Object)result);
        Document xml = this.toXml(result);
        Assert.assertNotNull((Object)xml);
        NodeList processes = xml.getElementsByTagName("process-definitions");
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.getLength());
        NodeList processDefs = xml.getElementsByTagName("processes");
        Assert.assertNotNull((Object)processDefs);
        Assert.assertEquals((long)0L, (long)processDefs.getLength());
    }

    @Test
    public void testAggregateContainers() throws Exception {
        String xml1 = this.read(this.getClass().getResourceAsStream("/jaxb/containers-1.xml"));
        String xml2 = this.read(this.getClass().getResourceAsStream("/jaxb/containers-2.xml"));
        JaxbXMLResponseAggregator aggregate = new JaxbXMLResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(xml1);
        data.add(xml2);
        String result = aggregate.aggregate(data);
        logger.debug((Object)result);
        Document xml = this.toXml(result);
        Assert.assertNotNull((Object)xml);
        NodeList processes = xml.getElementsByTagName("response");
        Assert.assertNotNull((Object)processes);
        Assert.assertEquals((long)1L, (long)processes.getLength());
        NodeList wrapper = xml.getElementsByTagName("kie-containers");
        Assert.assertNotNull((Object)wrapper);
        Assert.assertEquals((long)1L, (long)wrapper.getLength());
        NodeList containers = xml.getElementsByTagName("kie-container");
        Assert.assertNotNull((Object)containers);
        Assert.assertEquals((long)6L, (long)containers.getLength());
    }
}

