/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.proxy.ProxyHandler;
import java.util.Date;
import org.jboss.logging.Logger;
import org.kie.server.router.handlers.AdminHttpHandler;
import org.kie.server.router.handlers.ContainersHttpHandler;
import org.kie.server.router.handlers.DocumentsHttpHandler;
import org.kie.server.router.handlers.JobsHttpHandler;
import org.kie.server.router.handlers.KieServerInfoHandler;
import org.kie.server.router.handlers.QueriesHttpHandler;
import org.kie.server.router.proxy.KieServerProxyClient;
import org.kie.server.router.repository.FileRepository;

public class KieServerRouter {
    private static final String HOST = System.getProperty("org.kie.server.router.host", "localhost");
    private static final String PORT = System.getProperty("org.kie.server.router.port", "9000");
    private static final Logger log = Logger.getLogger(KieServerRouter.class);
    private Undertow server;
    private FileRepository repository = new FileRepository();

    public static void main(String[] args) {
        KieServerRouter router = new KieServerRouter();
        router.start(HOST, Integer.parseInt(PORT));
    }

    public void start(String host, Integer port) {
        System.setProperty("org.kie.server.router.host", host);
        System.setProperty("org.kie.server.router.port", port.toString());
        KieServerProxyClient proxyClient = new KieServerProxyClient();
        ResponseCodeHandler notFoundHandler = ResponseCodeHandler.HANDLE_404;
        AdminHttpHandler adminHandler = new AdminHttpHandler(proxyClient, this.repository);
        PathHandler pathHandler = Handlers.path(new ProxyHandler(proxyClient, notFoundHandler));
        pathHandler.addPrefixPath("/queries", new QueriesHttpHandler(notFoundHandler, adminHandler));
        pathHandler.addPrefixPath("/jobs", new JobsHttpHandler(notFoundHandler, adminHandler));
        pathHandler.addPrefixPath("/documents", new DocumentsHttpHandler(notFoundHandler, adminHandler));
        pathHandler.addExactPath("/containers", new ContainersHttpHandler(notFoundHandler, adminHandler));
        pathHandler.addPrefixPath("/admin", adminHandler);
        pathHandler.addExactPath("/", new KieServerInfoHandler());
        this.server = Undertow.builder().addHttpListener(port, host).setHandler(pathHandler).build();
        this.server.start();
        log.infof("KieServerRouter started on %s:%s at %s", (Object)host, (Object)port, (Object)new Date());
    }

    public void stop() {
        this.stop(false);
    }

    public void stop(boolean clean) {
        if (this.server != null) {
            this.server.stop();
            if (clean) {
                this.repository.clean();
            }
            log.infof("KieServerRouter stopped on %s:%s at %s", (Object)System.getProperty("org.kie.server.router.host"), (Object)System.getProperty("org.kie.server.router.port"), (Object)new Date());
        } else {
            log.error("KieServerRouter was not started");
        }
    }
}

