/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router.proxy.aggragate;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jboss.logging.Logger;
import org.kie.server.router.proxy.aggragate.ResponseAggregator;
import org.kie.server.router.utils.Helper;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XMLResponseAggregator
implements ResponseAggregator {
    private static final Logger log = Logger.getLogger(XMLResponseAggregator.class);
    private static final String SORT_XSLT = Helper.read(XMLResponseAggregator.class.getResourceAsStream("/sort.xsl"));
    private static final String PAGE_XSLT = Helper.read(XMLResponseAggregator.class.getResourceAsStream("/page.xsl"));

    protected boolean supports(String expectedType, Object ... acceptTypes) {
        for (Object acceptType : acceptTypes) {
            boolean found;
            if (acceptType == null || !(found = acceptType.toString().toLowerCase().contains(expectedType))) continue;
            return true;
        }
        return false;
    }

    @Override
    public String aggregate(List<String> data) {
        try {
            if (data == null || data.isEmpty()) {
                return null;
            }
            List<String> nodes = this.knownNames();
            Document document = data.stream().map(xml -> this.newDoc((String)xml)).filter(d -> d != null).reduce((source, target) -> {
                this.deepMerge((Node)source, (Node)target, nodes, (Document)target);
                return target;
            }).get();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            StreamResult output = new StreamResult(out);
            DOMSource input = new DOMSource(document);
            transformer.transform(input, output);
            return new String(out.toByteArray());
        }
        catch (Exception e) {
            log.errorf("Failed to aggregate xml responses of %s", (Object)data, (Object)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public String aggregate(List<String> data, String sortBy, boolean ascending, Integer page, Integer pageSize) {
        try {
            if (data == null || data.isEmpty()) {
                return null;
            }
            List<String> nodes = this.knownNames();
            Document document = data.stream().map(xml -> this.newDoc((String)xml)).filter(d -> d != null).reduce((source, target) -> {
                this.deepMerge((Node)source, (Node)target, nodes, (Document)target);
                return target;
            }).get();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Transformer transformer = null;
            String root = document.getDocumentElement().getNodeName();
            String sortNode = this.getElementLevel();
            if (sortBy != null && !sortBy.trim().isEmpty()) {
                transformer = this.sort(this.getRootNode(root), sortNode, sortBy, ascending, document);
                DOMResult toutput = new DOMResult();
                DOMSource input = new DOMSource(document);
                transformer.transform(input, toutput);
                document = (Document)toutput.getNode();
            }
            transformer = this.page(this.getRootNode(root), sortNode, page, pageSize, document);
            StreamResult output = new StreamResult(out);
            transformer.transform(new DOMSource(document), output);
            return new String(out.toByteArray());
        }
        catch (Exception e) {
            log.errorf("Failed to aggregate xml responses of %s", (Object)data, (Object)e);
            throw new RuntimeException(e);
        }
    }

    protected Transformer sort(String root, String level, String fieldName, boolean ascending, Document source) throws Exception {
        String order = "ascending";
        if (!ascending) {
            order = "descending";
        }
        StreamSource xsltSort = new StreamSource(new StringReader(SORT_XSLT.replaceAll("KIE_ROOT", root).replaceAll("LEVEL", level).replaceAll("KIE_SORT_BY", this.sortBy(fieldName)).replaceAll("KIE_ORDER", order)));
        return TransformerFactory.newInstance().newTransformer(xsltSort);
    }

    protected Transformer page(String root, String node, Integer start, Integer size, Document source) throws Exception {
        Integer actualStart = start;
        Integer actualSize = size;
        if (actualStart > 0) {
            actualStart = actualStart * size;
            actualSize = actualStart + size;
        }
        log.debug("Start " + actualStart + " size " + actualSize);
        StreamSource xsltSort = new StreamSource(new StringReader(PAGE_XSLT.replaceAll("LEVEL", node).replaceAll("START", actualStart.toString()).replaceAll("SIZE", actualSize.toString())));
        return TransformerFactory.newInstance().newTransformer(xsltSort);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Document newDoc(String xml) {
        try (ByteArrayInputStream stream = new ByteArrayInputStream(xml.getBytes("UTF-8"));){
            Document doc;
            Document document = doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(stream);
            return document;
        }
        catch (Exception e) {
            log.errorf("Failed to create xml document of %s", (Object)xml, (Object)e);
            return null;
        }
    }

    protected void deepMerge(Node sourceNode, Node targetNode, List<String> nodes, Document target) {
        if (targetNode == null) {
            return;
        }
        NodeList sourceNodeList = sourceNode.getChildNodes();
        NodeList targetNodeList = targetNode.getChildNodes();
        for (int i = 0; i < sourceNodeList.getLength(); ++i) {
            sourceNode = sourceNodeList.item(i);
            targetNode = targetNodeList.item(i);
            if (!nodes.contains(sourceNode.getNodeName())) {
                this.deepMerge(sourceNode, targetNode, nodes, target);
            }
            if (targetNode == null) {
                return;
            }
            NodeList children = sourceNode.getChildNodes();
            this.copyNodes(children, target, targetNode);
        }
    }

    protected abstract void copyNodes(NodeList var1, Document var2, Node var3);

    protected abstract List<String> knownNames();

    protected abstract String getElementLevel();

    protected abstract String getRootNode(String var1);

    protected abstract String sortBy(String var1);
}

