/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router.proxy.aggragate;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.kie.server.router.proxy.aggragate.XMLResponseAggregator;
import org.kie.server.router.utils.Helper;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XstreamXMLResponseAggregator
extends XMLResponseAggregator {
    private static final String XSTREAM_TYPE = "xstream";
    private static final Properties sortByMapping = Helper.readProperties(XstreamXMLResponseAggregator.class.getResourceAsStream("/sort-xstream.mapping"));
    protected List<String> nodes = Arrays.asList("processes", "adHocFragments", "comments", "definitions", "caseInstances", "milestones", "roleAssignments", "stages", "migrationReportInstances", "processNodes", "taskNotifications", "taskReassignments", "timerInstances", "queries", "tasks", "documentInstances", "errorInfoInstances", "nodeInstances", "processInstances", "requestInfoInstances", "solver", "taskAttachments", "taskComments", "taskEvents", "tasks", "tasks", "variableInstances", "workItems", "result");

    @Override
    public boolean supports(Object ... acceptTypes) {
        return this.supports(XSTREAM_TYPE, acceptTypes);
    }

    @Override
    protected void copyNodes(NodeList children, Document target, Node targetNode) {
        for (int j = 0; j < children.getLength(); ++j) {
            Node existing = children.item(j);
            if (this.nodes.contains(existing.getNodeName()) || !existing.hasChildNodes()) continue;
            Node imported = target.importNode(existing, true);
            targetNode.appendChild(imported);
        }
    }

    @Override
    protected List<String> knownNames() {
        return this.nodes;
    }

    @Override
    protected String getElementLevel() {
        return "2";
    }

    @Override
    protected String getRootNode(String rootNode) {
        return "//*[count(ancestor::*) = 1]";
    }

    @Override
    protected String sortBy(String fieldName) {
        return sortByMapping.getProperty(fieldName, fieldName);
    }
}

