/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.proxy.ProxyHandler;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.jboss.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.kie.server.router.Configuration;
import org.kie.server.router.handlers.AdminHttpHandler;
import org.kie.server.router.handlers.ContainersHttpHandler;
import org.kie.server.router.handlers.DocumentsHttpHandler;
import org.kie.server.router.handlers.JobsHttpHandler;
import org.kie.server.router.handlers.KieServerInfoHandler;
import org.kie.server.router.handlers.QueriesDataHttpHandler;
import org.kie.server.router.handlers.QueriesHttpHandler;
import org.kie.server.router.proxy.KieServerProxyClient;
import org.kie.server.router.repository.FileRepository;
import org.kie.server.router.spi.ConfigRepository;
import org.kie.server.router.utils.HttpUtils;

public class KieServerRouter {
    private static final String HOST = System.getProperty("org.kie.server.router.host", "localhost");
    private static final String PORT = System.getProperty("org.kie.server.router.port", "9000");
    private static final String CONTROLLER = System.getProperty("org.kie.server.controller");
    private static final Logger log = Logger.getLogger(KieServerRouter.class);
    private static final String SERVER_INFO_JSON = "{\n      \"version\" : \"LATEST\",\n      \"name\" : \"KIE Server Router\",\n      \"location\" : \"" + KieServerInfoHandler.getLocationUrl() + "\",\n      \"capabilities\" : [ \"KieServer\", \"BRM\", \"BPM\", \"CaseMgmt\", \"BPM-UI\", \"BRP\" ],\n      \"id\" : \"kie-server-router\"\n}";
    private ServiceLoader<ConfigRepository> configRepositoryServiceLoader = ServiceLoader.load(ConfigRepository.class);
    private Undertow server;
    private ConfigRepository repository = new FileRepository();

    public KieServerRouter() {
        this.configRepositoryServiceLoader.forEach(repo -> {
            this.repository = repo;
        });
        log.info("KIE Server router repository implementation is " + this.repository);
    }

    public static void main(String[] args) {
        final KieServerRouter router = new KieServerRouter();
        router.start(HOST, Integer.parseInt(PORT));
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                router.stop();
            }
        });
    }

    public void start(String host, Integer port) {
        System.setProperty("org.kie.server.router.host", host);
        System.setProperty("org.kie.server.router.port", port.toString());
        Configuration configuration = this.repository.load();
        if (configuration == null) {
            configuration = new Configuration();
        }
        KieServerProxyClient proxyClient = new KieServerProxyClient(configuration);
        Map<String, Set<String>> perContainer = configuration.getHostsPerContainer();
        for (Map.Entry<String, Set<String>> entry : perContainer.entrySet()) {
            entry.getValue().forEach(url -> proxyClient.addContainer((String)entry.getKey(), URI.create(url)));
        }
        ResponseCodeHandler notFoundHandler = ResponseCodeHandler.HANDLE_404;
        AdminHttpHandler adminHandler = new AdminHttpHandler(configuration, this.repository);
        PathHandler pathHandler = Handlers.path(new ProxyHandler(proxyClient, notFoundHandler));
        pathHandler.addPrefixPath("/queries/definitions", new QueriesDataHttpHandler(notFoundHandler, adminHandler));
        pathHandler.addPrefixPath("/queries", new QueriesHttpHandler(notFoundHandler, adminHandler));
        pathHandler.addPrefixPath("/jobs", new JobsHttpHandler(notFoundHandler, adminHandler));
        pathHandler.addPrefixPath("/documents", new DocumentsHttpHandler(notFoundHandler, adminHandler));
        pathHandler.addExactPath("/containers", new ContainersHttpHandler(notFoundHandler, adminHandler));
        pathHandler.addPrefixPath("/admin", adminHandler);
        pathHandler.addExactPath("/", new KieServerInfoHandler());
        this.server = Undertow.builder().addHttpListener(port, host).setHandler(pathHandler).build();
        this.server.start();
        log.infof("KieServerRouter started on %s:%s at %s", (Object)host, (Object)port, (Object)new Date());
        this.connectToController(adminHandler);
    }

    public void stop() {
        this.stop(false);
    }

    public void stop(boolean clean) {
        this.disconnectToController();
        if (this.server != null) {
            this.server.stop();
            if (clean) {
                this.repository.clean();
            }
            log.infof("KieServerRouter stopped on %s:%s at %s", (Object)System.getProperty("org.kie.server.router.host"), (Object)System.getProperty("org.kie.server.router.port"), (Object)new Date());
        } else {
            log.error("KieServerRouter was not started");
        }
    }

    protected void connectToController(AdminHttpHandler adminHandler) {
        if (CONTROLLER == null) {
            return;
        }
        try {
            String jsonResponse = HttpUtils.putHttpCall(CONTROLLER + "/server/kie-server-router", SERVER_INFO_JSON);
            log.debugf("Controller response :: ", (Object)jsonResponse);
            ArrayList<String> containers = new ArrayList<String>();
            JSONObject serverConfig = new JSONObject(jsonResponse);
            try {
                JSONArray sourceList = serverConfig.getJSONArray("containers");
                for (int i = 0; i < sourceList.length(); ++i) {
                    JSONObject container = sourceList.getJSONObject(i);
                    containers.add(container.getString("container-id"));
                }
            }
            catch (JSONException e) {
                log.debug((Object)("Error when getting list of containers:: " + e.getMessage()), e);
            }
            adminHandler.addControllerContainers(containers);
            log.infof("KieServerRouter connected to controller at " + CONTROLLER, new Object[0]);
        }
        catch (Exception e) {
            log.error((Object)("Error when connecting to controller at " + CONTROLLER), e);
        }
    }

    protected void disconnectToController() {
        if (CONTROLLER == null) {
            return;
        }
        try {
            HttpUtils.deleteHttpCall(CONTROLLER + "/server/kie-server-router/?location=" + URLEncoder.encode(KieServerInfoHandler.getLocationUrl(), "UTF-8"));
            log.infof("KieServerRouter disconnected from controller at " + CONTROLLER, new Object[0]);
        }
        catch (Exception e) {
            log.error((Object)("Error when disconnecting from controller at " + CONTROLLER), e);
        }
    }
}

