/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.kie.server.router.handlers.AbstractAggregateHttpHandler;
import org.kie.server.router.handlers.AdminHttpHandler;
import org.kie.server.router.proxy.aggragate.ResponseAggregator;

public class QueriesDataHttpHandler
extends AbstractAggregateHttpHandler {
    public QueriesDataHttpHandler(HttpHandler httpHandler, AdminHttpHandler adminHandler) {
        super(httpHandler, adminHandler);
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (exchange.getRequestMethod().equals(HttpString.tryFromString("POST"))) {
            Deque<String> originalSortOrder;
            Deque<String> originalPageSize;
            Map<String, Deque<String>> queryParams = exchange.getQueryParameters();
            Integer page = 0;
            Integer pageSize = 10;
            Deque<String> originalPage = queryParams.get("page");
            if (originalPage != null && !originalPage.isEmpty()) {
                page = Integer.parseInt(originalPage.getFirst());
            }
            if ((originalPageSize = queryParams.remove("pageSize")) != null && !originalPageSize.isEmpty()) {
                pageSize = Integer.parseInt(originalPageSize.getFirst());
            }
            boolean useAdvanced = pageSize != -1;
            String routerPage = "0";
            String routerPageSize = String.valueOf((1 + page) * pageSize);
            String sortBy = null;
            boolean sortOder = true;
            Deque<String> originalSortBy = queryParams.get("sort");
            if (originalSortBy != null && !originalSortBy.isEmpty()) {
                sortBy = originalSortBy.getFirst();
            }
            if ((originalSortOrder = queryParams.get("sortOrder")) != null && !originalSortOrder.isEmpty()) {
                sortOder = Boolean.parseBoolean(originalSortOrder.getFirst());
            }
            StringBuilder requestBody = new StringBuilder();
            exchange.getRequestReceiver().receiveFullString((ex, data) -> requestBody.append(data));
            String body = requestBody.toString();
            ConcurrentHashMap<String, List> responseHeaders = new ConcurrentHashMap<String, List>();
            List<String> returnResponses = this.getServerHosts().parallelStream().map(url -> {
                String response = null;
                try {
                    response = this.sendPostRequest((String)url, body, exchange, (Map<String, List<String>>)responseHeaders, "0", routerPageSize);
                }
                catch (Exception e) {
                    log.error((Object)"Error when forwarding request to server", e);
                }
                return response;
            }).filter(msg -> msg != null && !msg.trim().isEmpty()).collect(Collectors.toList());
            HeaderValues accept = exchange.getRequestHeaders().get(Headers.ACCEPT);
            HeaderValues kieContentType = exchange.getRequestHeaders().get("X-KIE-ContentType");
            String response = "";
            if (returnResponses.size() > 0) {
                ResponseAggregator responseAggregator = this.adminHandler.getAggregators().stream().filter(a -> a.supports(kieContentType, accept, "application/xml")).findFirst().orElseThrow(() -> new RuntimeException("not possible to find response aggregator for " + responseHeaders.get(Headers.ACCEPT)));
                response = this.supportAdvancedAggregate() && useAdvanced ? responseAggregator.aggregate(returnResponses, sortBy, sortOder, page, pageSize) : responseAggregator.aggregate(returnResponses);
            }
            responseHeaders.forEach((name, value) -> exchange.getResponseHeaders().putAll(HttpString.tryFromString(name), (Collection<String>)value));
            exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, response.getBytes("UTF-8").length);
            exchange.getResponseSender().send(response);
        } else if (exchange.getRequestMethod().equals(HttpString.tryFromString("PUT"))) {
            StringBuilder requestBody = new StringBuilder();
            exchange.getRequestReceiver().receiveFullString((ex, data) -> requestBody.append(data));
            String body = requestBody.toString();
            ConcurrentHashMap<String, List> responseHeaders = new ConcurrentHashMap<String, List>();
            List returnResponses = this.getServerHosts().parallelStream().map(url -> {
                String response = null;
                try {
                    response = this.sendPutRequest((String)url, body, exchange, (Map<String, List<String>>)responseHeaders);
                }
                catch (Exception e) {
                    log.error((Object)"Error when forwarding request to server", e);
                }
                return response;
            }).filter(msg -> msg != null).collect(Collectors.toList());
            responseHeaders.forEach((name, value) -> exchange.getResponseHeaders().putAll(HttpString.tryFromString(name), (Collection<String>)value));
            if (returnResponses.size() == 0) {
                ResponseCodeHandler.HANDLE_404.handleRequest(exchange);
                return;
            }
            new ResponseCodeHandler(201).handleRequest(exchange);
        } else {
            if (exchange.getRequestMethod().equals(HttpString.tryFromString("DELETE"))) {
                ConcurrentHashMap<String, List> responseHeaders = new ConcurrentHashMap<String, List>();
                this.getServerHosts().parallelStream().forEach(url -> {
                    try {
                        this.sendDeleteRequest((String)url, exchange, (Map<String, List<String>>)responseHeaders);
                    }
                    catch (Exception e) {
                        log.error((Object)"Error when forwarding request to server", e);
                    }
                });
                responseHeaders.forEach((name, value) -> exchange.getResponseHeaders().putAll(HttpString.tryFromString(name), (Collection<String>)value));
                new ResponseCodeHandler(204).handleRequest(exchange);
                return;
            }
            super.handleRequest(exchange);
        }
    }

    protected String sendPostRequest(String url, String body, HttpServerExchange exchange, Map<String, List<String>> responseHeaders, String page, String pageSize) throws Exception {
        String inputLine;
        URL obj = new URL(url + exchange.getRequestPath() + "?" + exchange.getQueryString().replaceAll("page=[^&]*", "page=" + page).replaceAll("pageSize=[^&]*", "pageSize=" + pageSize));
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.setRequestMethod("POST");
        exchange.getRequestHeaders().forEach(h -> con.setRequestProperty(h.getHeaderName().toString(), h.getFirst()));
        con.setDoOutput(true);
        if (body != null) {
            con.getOutputStream().write(body.getBytes("UTF-8"));
        }
        log.debugf("Sending 'POST' request to URL : %s", (Object)obj);
        int responseCode = con.getResponseCode();
        log.debugf("Response Code : %s", responseCode);
        Map<String, List<String>> headers = con.getHeaderFields();
        headers.forEach((k, v) -> {
            if (k != null) {
                responseHeaders.put((String)k, (List<String>)v);
            }
        });
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        return response.toString();
    }

    protected String sendPutRequest(String url, String body, HttpServerExchange exchange, Map<String, List<String>> responseHeaders) throws Exception {
        String inputLine;
        URL obj = new URL(url + exchange.getRequestPath() + "?" + exchange.getQueryString());
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.setRequestMethod("PUT");
        exchange.getRequestHeaders().forEach(h -> con.setRequestProperty(h.getHeaderName().toString(), h.getFirst()));
        con.setDoOutput(true);
        if (body != null) {
            con.getOutputStream().write(body.getBytes("UTF-8"));
        }
        log.debugf("Sending 'PUT' request to URL : %s", (Object)obj);
        int responseCode = con.getResponseCode();
        log.debugf("Response Code : %s", responseCode);
        Map<String, List<String>> headers = con.getHeaderFields();
        headers.forEach((k, v) -> {
            if (k != null) {
                responseHeaders.put((String)k, (List<String>)v);
            }
        });
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        return response.toString();
    }

    protected String sendDeleteRequest(String url, HttpServerExchange exchange, Map<String, List<String>> responseHeaders) throws Exception {
        String inputLine;
        URL obj = new URL(url + exchange.getRequestPath() + "?" + exchange.getQueryString());
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.setRequestMethod("DELETE");
        exchange.getRequestHeaders().forEach(h -> con.setRequestProperty(h.getHeaderName().toString(), h.getFirst()));
        con.setDoOutput(true);
        log.debugf("Sending 'DELETE' request to URL : %s", (Object)obj);
        int responseCode = con.getResponseCode();
        log.debugf("Response Code : %s", responseCode);
        Map<String, List<String>> headers = con.getHeaderFields();
        headers.forEach((k, v) -> {
            if (k != null) {
                responseHeaders.put((String)k, (List<String>)v);
            }
        });
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        return response.toString();
    }
}

