/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.core;

import io.undertow.UndertowLogger;
import io.undertow.connector.ByteBufferPool;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.websockets.core.StreamSinkFrameChannel;
import io.undertow.websockets.core.StreamSourceFrameChannel;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketFrameType;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import org.xnio.Buffers;
import org.xnio.ChannelExceptionHandler;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;

public final class WebSocketUtils {
    private static final String EMPTY = "";

    public static ByteBuffer fromUtf8String(CharSequence utfString) {
        if (utfString == null || utfString.length() == 0) {
            return Buffers.EMPTY_BYTE_BUFFER;
        }
        return ByteBuffer.wrap(utfString.toString().getBytes(StandardCharsets.UTF_8));
    }

    public static String toUtf8String(ByteBuffer buffer) {
        if (!buffer.hasRemaining()) {
            return EMPTY;
        }
        if (buffer.hasArray()) {
            return new String(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining(), StandardCharsets.UTF_8);
        }
        byte[] content = new byte[buffer.remaining()];
        buffer.get(content);
        return new String(content, StandardCharsets.UTF_8);
    }

    public static String toUtf8String(ByteBuffer ... buffers) {
        int size = 0;
        for (ByteBuffer buf : buffers) {
            size += buf.remaining();
        }
        if (size == 0) {
            return EMPTY;
        }
        int index = 0;
        byte[] bytes = new byte[size];
        for (ByteBuffer buf : buffers) {
            int len;
            if (buf.hasArray()) {
                len = buf.remaining();
                System.arraycopy(buf.array(), buf.arrayOffset() + buf.position(), bytes, index, len);
                index += len;
                continue;
            }
            len = buf.remaining();
            buf.get(bytes, index, len);
            index += len;
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long transfer(ReadableByteChannel source, long count, ByteBuffer throughBuffer, WritableByteChannel sink) throws IOException {
        long total = 0L;
        while (total < count) {
            long res;
            throughBuffer.clear();
            if (count - total < (long)throughBuffer.remaining()) {
                throughBuffer.limit((int)(count - total));
            }
            try {
                res = source.read(throughBuffer);
                if (res <= 0L) {
                    long l = total == 0L ? res : total;
                    return l;
                }
            }
            finally {
                throughBuffer.flip();
            }
            while (throughBuffer.hasRemaining()) {
                res = sink.write(throughBuffer);
                if (res <= 0L) {
                    return total;
                }
                total += res;
            }
        }
        return total;
    }

    public static void echoFrame(final WebSocketChannel channel, StreamSourceFrameChannel ws) throws IOException {
        WebSocketFrameType type;
        switch (ws.getType()) {
            case PONG: {
                ws.close();
                return;
            }
            case PING: {
                type = WebSocketFrameType.PONG;
                break;
            }
            default: {
                type = ws.getType();
            }
        }
        StreamSinkFrameChannel sink = channel.send(type);
        sink.setRsv(ws.getRsv());
        WebSocketUtils.initiateTransfer(ws, sink, new ChannelListener<StreamSourceFrameChannel>(){

            @Override
            public void handleEvent(StreamSourceFrameChannel streamSourceFrameChannel) {
                IoUtils.safeClose((Closeable)streamSourceFrameChannel);
            }
        }, new ChannelListener<StreamSinkFrameChannel>(){

            @Override
            public void handleEvent(StreamSinkFrameChannel streamSinkFrameChannel) {
                try {
                    streamSinkFrameChannel.shutdownWrites();
                }
                catch (IOException e) {
                    UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                    IoUtils.safeClose(streamSinkFrameChannel, channel);
                    return;
                }
                try {
                    if (!streamSinkFrameChannel.flush()) {
                        streamSinkFrameChannel.getWriteSetter().set(ChannelListeners.flushingChannelListener(new ChannelListener<StreamSinkFrameChannel>(){

                            @Override
                            public void handleEvent(StreamSinkFrameChannel streamSinkFrameChannel) {
                                streamSinkFrameChannel.getWriteSetter().set(null);
                                IoUtils.safeClose((Closeable)streamSinkFrameChannel);
                                if (type == WebSocketFrameType.CLOSE) {
                                    IoUtils.safeClose((Closeable)channel);
                                }
                            }
                        }, new ChannelExceptionHandler<StreamSinkFrameChannel>(){

                            @Override
                            public void handleException(StreamSinkFrameChannel streamSinkFrameChannel, IOException e) {
                                UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                                IoUtils.safeClose(streamSinkFrameChannel, channel);
                            }
                        }));
                        streamSinkFrameChannel.resumeWrites();
                    } else {
                        if (type == WebSocketFrameType.CLOSE) {
                            IoUtils.safeClose((Closeable)channel);
                        }
                        streamSinkFrameChannel.getWriteSetter().set(null);
                        IoUtils.safeClose((Closeable)streamSinkFrameChannel);
                    }
                }
                catch (IOException e) {
                    UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                    IoUtils.safeClose(streamSinkFrameChannel, channel);
                }
            }
        }, new ChannelExceptionHandler<StreamSourceFrameChannel>(){

            @Override
            public void handleException(StreamSourceFrameChannel streamSourceFrameChannel, IOException e) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                IoUtils.safeClose(streamSourceFrameChannel, channel);
            }
        }, new ChannelExceptionHandler<StreamSinkFrameChannel>(){

            @Override
            public void handleException(StreamSinkFrameChannel streamSinkFrameChannel, IOException e) {
                UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                IoUtils.safeClose(streamSinkFrameChannel, channel);
            }
        }, channel.getBufferPool());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <I extends StreamSourceChannel, O extends StreamSinkChannel> void initiateTransfer(I source, O sink, ChannelListener<? super I> sourceListener, ChannelListener<? super O> sinkListener, ChannelExceptionHandler<? super I> readExceptionHandler, ChannelExceptionHandler<? super O> writeExceptionHandler, ByteBufferPool pool) {
        if (pool == null) {
            throw new IllegalArgumentException("pool is null");
        }
        PooledByteBuffer allocated = pool.allocate();
        boolean free = true;
        try {
            long transferred;
            ByteBuffer buffer = allocated.getBuffer();
            buffer.clear();
            do {
                try {
                    transferred = source.transferTo(Long.MAX_VALUE, buffer, sink);
                }
                catch (IOException e) {
                    ChannelListeners.invokeChannelExceptionHandler(source, readExceptionHandler, e);
                    if (free) {
                        allocated.close();
                    }
                    return;
                }
                if (transferred == -1L) {
                    source.suspendReads();
                    sink.suspendWrites();
                    ChannelListeners.invokeChannelListener(source, sourceListener);
                    ChannelListeners.invokeChannelListener(sink, sinkListener);
                    return;
                }
                while (buffer.hasRemaining()) {
                    int res;
                    try {
                        res = sink.write(buffer);
                    }
                    catch (IOException e) {
                        ChannelListeners.invokeChannelExceptionHandler(sink, writeExceptionHandler, e);
                        if (free) {
                            allocated.close();
                        }
                        return;
                    }
                    if (res == 0) {
                        TransferListener<? super I, ? super O> listener = new TransferListener<I, O>(allocated, source, sink, sourceListener, sinkListener, writeExceptionHandler, readExceptionHandler, 1);
                        source.suspendReads();
                        source.getReadSetter().set(listener);
                        sink.getWriteSetter().set(listener);
                        sink.resumeWrites();
                        free = false;
                        return;
                    }
                    if (res != -1) continue;
                    source.suspendReads();
                    sink.suspendWrites();
                    ChannelListeners.invokeChannelListener(source, sourceListener);
                    ChannelListeners.invokeChannelListener(sink, sinkListener);
                    return;
                }
            } while (transferred > 0L);
            TransferListener<? super I, ? super O> listener = new TransferListener<I, O>(allocated, source, sink, sourceListener, sinkListener, writeExceptionHandler, readExceptionHandler, 0);
            sink.suspendWrites();
            sink.getWriteSetter().set(listener);
            source.getReadSetter().set(listener);
            sink.suspendWrites();
            source.resumeReads();
            free = false;
        }
        finally {
            if (free) {
                allocated.close();
            }
        }
    }

    private WebSocketUtils() {
    }

    static final class TransferListener<I extends StreamSourceChannel, O extends StreamSinkChannel>
    implements ChannelListener<Channel> {
        private final PooledByteBuffer pooledBuffer;
        private final I source;
        private final O sink;
        private final ChannelListener<? super I> sourceListener;
        private final ChannelListener<? super O> sinkListener;
        private final ChannelExceptionHandler<? super O> writeExceptionHandler;
        private final ChannelExceptionHandler<? super I> readExceptionHandler;
        private volatile int state;

        TransferListener(PooledByteBuffer pooledBuffer, I source, O sink, ChannelListener<? super I> sourceListener, ChannelListener<? super O> sinkListener, ChannelExceptionHandler<? super O> writeExceptionHandler, ChannelExceptionHandler<? super I> readExceptionHandler, int state) {
            this.pooledBuffer = pooledBuffer;
            this.source = source;
            this.sink = sink;
            this.sourceListener = sourceListener;
            this.sinkListener = sinkListener;
            this.writeExceptionHandler = writeExceptionHandler;
            this.readExceptionHandler = readExceptionHandler;
            this.state = state;
        }

        @Override
        public void handleEvent(Channel channel) {
            ByteBuffer buffer = this.pooledBuffer.getBuffer();
            int state = this.state;
            switch (state) {
                case 0: {
                    block12: while (true) {
                        int ires;
                        long lres;
                        try {
                            lres = this.source.transferTo(Long.MAX_VALUE, buffer, (StreamSinkChannel)this.sink);
                        }
                        catch (IOException e) {
                            this.readFailed(e);
                            return;
                        }
                        if (lres == 0L && !buffer.hasRemaining()) {
                            return;
                        }
                        if (lres == -1L) {
                            this.done();
                            return;
                        }
                        do {
                            if (!buffer.hasRemaining()) continue block12;
                            try {
                                ires = this.sink.write(buffer);
                            }
                            catch (IOException e) {
                                this.writeFailed(e);
                                return;
                            }
                        } while (ires != 0);
                        break;
                    }
                    this.state = 1;
                    this.source.suspendReads();
                    this.sink.resumeWrites();
                    return;
                }
                case 1: {
                    while (true) {
                        long lres;
                        if (buffer.hasRemaining()) {
                            int ires;
                            try {
                                ires = this.sink.write(buffer);
                            }
                            catch (IOException e) {
                                this.writeFailed(e);
                                return;
                            }
                            if (ires != 0) continue;
                            return;
                        }
                        try {
                            lres = this.source.transferTo(Long.MAX_VALUE, buffer, (StreamSinkChannel)this.sink);
                        }
                        catch (IOException e) {
                            this.readFailed(e);
                            return;
                        }
                        if (lres == 0L && !buffer.hasRemaining()) {
                            this.state = 0;
                            this.sink.suspendWrites();
                            this.source.resumeReads();
                            return;
                        }
                        if (lres == -1L) break;
                    }
                    this.done();
                    return;
                }
            }
        }

        private void writeFailed(IOException e) {
            try {
                this.source.suspendReads();
                this.sink.suspendWrites();
                ChannelListeners.invokeChannelExceptionHandler(this.sink, this.writeExceptionHandler, e);
            }
            finally {
                this.pooledBuffer.close();
            }
        }

        private void readFailed(IOException e) {
            try {
                this.source.suspendReads();
                this.sink.suspendWrites();
                ChannelListeners.invokeChannelExceptionHandler(this.source, this.readExceptionHandler, e);
            }
            finally {
                this.pooledBuffer.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void done() {
            try {
                ChannelListener<? super I> sourceListener = this.sourceListener;
                ChannelListener<? super O> sinkListener = this.sinkListener;
                I source = this.source;
                O sink = this.sink;
                source.suspendReads();
                sink.suspendWrites();
                ChannelListeners.invokeChannelListener(source, sourceListener);
                ChannelListeners.invokeChannelListener(sink, sinkListener);
            }
            finally {
                this.pooledBuffer.close();
            }
        }

        public String toString() {
            return "Transfer channel listener (" + this.source + " to " + this.sink + ") -> (" + this.sourceListener + " and " + this.sinkListener + ')';
        }
    }
}

