/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router.proxy.aggregate;

import java.util.ArrayList;
import org.jboss.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;
import org.kie.server.router.proxy.aggragate.JSONResponseAggregator;
import org.kie.server.router.proxy.aggregate.AbstractAggregateTest;

public class JSONAggregatorTest
extends AbstractAggregateTest {
    private static final Logger logger = Logger.getLogger(JSONAggregatorTest.class);

    @Test
    public void testAggregateProcessDefinitions() throws Exception {
        String json1 = this.read(this.getClass().getResourceAsStream("/json/process-def-1.json"));
        String json2 = this.read(this.getClass().getResourceAsStream("/json/process-def-2.json"));
        JSONResponseAggregator aggregate = new JSONResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(json1);
        data.add(json2);
        String result = aggregate.aggregate(data);
        logger.debug((Object)result);
        JSONObject aggregated = new JSONObject(result);
        Assert.assertNotNull((Object)aggregated);
        Object processes = aggregated.get("processes");
        Assert.assertNotNull((Object)processes);
        Assert.assertTrue((boolean)(processes instanceof JSONArray));
        JSONArray processDefs = (JSONArray)processes;
        Assert.assertEquals((long)8L, (long)processDefs.length());
    }

    @Test
    public void testAggregateProcessDefinitionsTargetEmpty() throws Exception {
        String json1 = this.read(this.getClass().getResourceAsStream("/json/process-def-1.json"));
        String json2 = this.read(this.getClass().getResourceAsStream("/json/process-def-empty.json"));
        JSONResponseAggregator aggregate = new JSONResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(json1);
        data.add(json2);
        String result = aggregate.aggregate(data);
        logger.debug((Object)result);
        JSONObject aggregated = new JSONObject(result);
        Assert.assertNotNull((Object)aggregated);
        Object processes = aggregated.get("processes");
        Assert.assertNotNull((Object)processes);
        Assert.assertTrue((boolean)(processes instanceof JSONArray));
        JSONArray processDefs = (JSONArray)processes;
        Assert.assertEquals((long)5L, (long)processDefs.length());
    }

    @Test
    public void testAggregateProcessDefinitionsSourceEmpty() throws Exception {
        String json1 = this.read(this.getClass().getResourceAsStream("/json/process-def-empty.json"));
        String json2 = this.read(this.getClass().getResourceAsStream("/json/process-def-2.json"));
        JSONResponseAggregator aggregate = new JSONResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(json1);
        data.add(json2);
        String result = aggregate.aggregate(data);
        logger.debug((Object)result);
        JSONObject aggregated = new JSONObject(result);
        Assert.assertNotNull((Object)aggregated);
        Object processes = aggregated.get("processes");
        Assert.assertNotNull((Object)processes);
        Assert.assertTrue((boolean)(processes instanceof JSONArray));
        JSONArray processDefs = (JSONArray)processes;
        Assert.assertEquals((long)3L, (long)processDefs.length());
    }

    @Test
    public void testAggregateProcessDefinitionsEmpty() throws Exception {
        String json1 = this.read(this.getClass().getResourceAsStream("/json/process-def-empty.json"));
        String json2 = this.read(this.getClass().getResourceAsStream("/json/process-def-empty.json"));
        JSONResponseAggregator aggregate = new JSONResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(json1);
        data.add(json2);
        String result = aggregate.aggregate(data);
        logger.debug((Object)result);
        JSONObject aggregated = new JSONObject(result);
        Assert.assertNotNull((Object)aggregated);
        Object processes = aggregated.get("processes");
        Assert.assertNotNull((Object)processes);
        Assert.assertTrue((boolean)(processes instanceof JSONArray));
        JSONArray processDefs = (JSONArray)processes;
        Assert.assertEquals((long)0L, (long)processDefs.length());
    }

    @Test
    public void testAggregateProcessInstances() throws Exception {
        String json1 = this.read(this.getClass().getResourceAsStream("/json/process-instance-1.json"));
        String json2 = this.read(this.getClass().getResourceAsStream("/json/process-instance-2.json"));
        JSONResponseAggregator aggregate = new JSONResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(json1);
        data.add(json2);
        String result = aggregate.aggregate(data);
        logger.debug((Object)result);
        JSONObject aggregated = new JSONObject(result);
        Assert.assertNotNull((Object)aggregated);
        Object processes = aggregated.get("process-instance");
        Assert.assertNotNull((Object)processes);
        Assert.assertTrue((boolean)(processes instanceof JSONArray));
        JSONArray processDefs = (JSONArray)processes;
        Assert.assertEquals((long)5L, (long)processDefs.length());
    }

    @Test
    public void testAggregateProcessInstancesTargetEmpty() throws Exception {
        String json1 = this.read(this.getClass().getResourceAsStream("/json/process-instance-1.json"));
        String json2 = this.read(this.getClass().getResourceAsStream("/json/process-instance-empty.json"));
        JSONResponseAggregator aggregate = new JSONResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(json1);
        data.add(json2);
        String result = aggregate.aggregate(data);
        logger.debug((Object)result);
        JSONObject aggregated = new JSONObject(result);
        Assert.assertNotNull((Object)aggregated);
        Object processes = aggregated.get("process-instance");
        Assert.assertNotNull((Object)processes);
        Assert.assertTrue((boolean)(processes instanceof JSONArray));
        JSONArray processDefs = (JSONArray)processes;
        Assert.assertEquals((long)3L, (long)processDefs.length());
    }

    @Test
    public void testAggregateProcessInstancesSourceEmpty() throws Exception {
        String json1 = this.read(this.getClass().getResourceAsStream("/json/process-instance-empty.json"));
        String json2 = this.read(this.getClass().getResourceAsStream("/json/process-instance-2.json"));
        JSONResponseAggregator aggregate = new JSONResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(json1);
        data.add(json2);
        String result = aggregate.aggregate(data);
        logger.debug((Object)result);
        JSONObject aggregated = new JSONObject(result);
        Assert.assertNotNull((Object)aggregated);
        Object processes = aggregated.get("process-instance");
        Assert.assertNotNull((Object)processes);
        Assert.assertTrue((boolean)(processes instanceof JSONArray));
        JSONArray processDefs = (JSONArray)processes;
        Assert.assertEquals((long)2L, (long)processDefs.length());
    }

    @Test
    public void testAggregateProcessInstancesEmpty() throws Exception {
        String json1 = this.read(this.getClass().getResourceAsStream("/json/process-instance-empty.json"));
        String json2 = this.read(this.getClass().getResourceAsStream("/json/process-instance-empty.json"));
        JSONResponseAggregator aggregate = new JSONResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(json1);
        data.add(json2);
        String result = aggregate.aggregate(data);
        logger.debug((Object)result);
        JSONObject aggregated = new JSONObject(result);
        Assert.assertNotNull((Object)aggregated);
        Object processes = aggregated.get("process-instance");
        Assert.assertNotNull((Object)processes);
        Assert.assertTrue((boolean)(processes instanceof JSONArray));
        JSONArray processDefs = (JSONArray)processes;
        Assert.assertEquals((long)0L, (long)processDefs.length());
    }

    @Test
    public void testAggregateTaskSummaries() throws Exception {
        String json1 = this.read(this.getClass().getResourceAsStream("/json/task-summary-1.json"));
        String json2 = this.read(this.getClass().getResourceAsStream("/json/task-summary-2.json"));
        JSONResponseAggregator aggregate = new JSONResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(json1);
        data.add(json2);
        String result = aggregate.aggregate(data);
        logger.debug((Object)result);
        JSONObject aggregated = new JSONObject(result);
        Assert.assertNotNull((Object)aggregated);
        Object processes = aggregated.get("task-summary");
        Assert.assertNotNull((Object)processes);
        Assert.assertTrue((boolean)(processes instanceof JSONArray));
        JSONArray processDefs = (JSONArray)processes;
        Assert.assertEquals((long)7L, (long)processDefs.length());
    }

    @Test
    public void testAggregateTaskSummariesTargetEmpty() throws Exception {
        String json1 = this.read(this.getClass().getResourceAsStream("/json/task-summary-1.json"));
        String json2 = this.read(this.getClass().getResourceAsStream("/json/task-summary-empty.json"));
        JSONResponseAggregator aggregate = new JSONResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(json1);
        data.add(json2);
        String result = aggregate.aggregate(data);
        logger.debug((Object)result);
        JSONObject aggregated = new JSONObject(result);
        Assert.assertNotNull((Object)aggregated);
        Object processes = aggregated.get("task-summary");
        Assert.assertNotNull((Object)processes);
        Assert.assertTrue((boolean)(processes instanceof JSONArray));
        JSONArray processDefs = (JSONArray)processes;
        Assert.assertEquals((long)3L, (long)processDefs.length());
    }

    @Test
    public void testAggregateTaskSummariesSourceEmpty() throws Exception {
        String json1 = this.read(this.getClass().getResourceAsStream("/json/task-summary-empty.json"));
        String json2 = this.read(this.getClass().getResourceAsStream("/json/task-summary-2.json"));
        JSONResponseAggregator aggregate = new JSONResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(json1);
        data.add(json2);
        String result = aggregate.aggregate(data);
        logger.debug((Object)result);
        JSONObject aggregated = new JSONObject(result);
        Assert.assertNotNull((Object)aggregated);
        Object processes = aggregated.get("task-summary");
        Assert.assertNotNull((Object)processes);
        Assert.assertTrue((boolean)(processes instanceof JSONArray));
        JSONArray processDefs = (JSONArray)processes;
        Assert.assertEquals((long)4L, (long)processDefs.length());
    }

    @Test
    public void testAggregateTaskSummariesEmpty() throws Exception {
        String json1 = this.read(this.getClass().getResourceAsStream("/json/task-summary-empty.json"));
        String json2 = this.read(this.getClass().getResourceAsStream("/json/task-summary-empty.json"));
        JSONResponseAggregator aggregate = new JSONResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(json1);
        data.add(json2);
        String result = aggregate.aggregate(data);
        logger.debug((Object)result);
        JSONObject aggregated = new JSONObject(result);
        Assert.assertNotNull((Object)aggregated);
        Object processes = aggregated.get("task-summary");
        Assert.assertNotNull((Object)processes);
        Assert.assertTrue((boolean)(processes instanceof JSONArray));
        JSONArray processDefs = (JSONArray)processes;
        Assert.assertEquals((long)0L, (long)processDefs.length());
    }

    @Test
    public void testSortProcessDefinitions() throws Exception {
        String json1 = this.read(this.getClass().getResourceAsStream("/json/process-def-1.json"));
        String json2 = this.read(this.getClass().getResourceAsStream("/json/process-def-2.json"));
        JSONResponseAggregator aggregate = new JSONResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(json1);
        data.add(json2);
        String sorted = aggregate.aggregate(data, "ProcessId", true, Integer.valueOf(0), Integer.valueOf(2));
        logger.debug((Object)sorted);
        JSONObject aggregated = new JSONObject(sorted);
        Assert.assertNotNull((Object)aggregated);
        Object processes = aggregated.get("processes");
        Assert.assertNotNull((Object)processes);
        Assert.assertTrue((boolean)(processes instanceof JSONArray));
        JSONArray processDefs = (JSONArray)processes;
        Assert.assertEquals((long)2L, (long)processDefs.length());
        String value1 = ((JSONObject)processDefs.get(0)).getString("process-id");
        Assert.assertEquals((Object)"1", (Object)value1);
        String value2 = ((JSONObject)processDefs.get(1)).getString("process-id");
        Assert.assertEquals((Object)"2", (Object)value2);
    }

    @Test
    public void testSortProcessDefinitionsDescending() throws Exception {
        String json1 = this.read(this.getClass().getResourceAsStream("/json/process-def-1.json"));
        String json2 = this.read(this.getClass().getResourceAsStream("/json/process-def-2.json"));
        JSONResponseAggregator aggregate = new JSONResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(json1);
        data.add(json2);
        String sorted = aggregate.aggregate(data, "ProcessId", false, Integer.valueOf(0), Integer.valueOf(2));
        logger.debug((Object)sorted);
        JSONObject aggregated = new JSONObject(sorted);
        Assert.assertNotNull((Object)aggregated);
        Object processes = aggregated.get("processes");
        Assert.assertNotNull((Object)processes);
        Assert.assertTrue((boolean)(processes instanceof JSONArray));
        JSONArray processDefs = (JSONArray)processes;
        Assert.assertEquals((long)2L, (long)processDefs.length());
        String value1 = ((JSONObject)processDefs.get(0)).getString("process-id");
        Assert.assertEquals((Object)"8", (Object)value1);
        String value2 = ((JSONObject)processDefs.get(1)).getString("process-id");
        Assert.assertEquals((Object)"7", (Object)value2);
    }

    @Test
    public void testSortProcessDefinitionsNextPage() throws Exception {
        String json1 = this.read(this.getClass().getResourceAsStream("/json/process-def-1.json"));
        String json2 = this.read(this.getClass().getResourceAsStream("/json/process-def-2.json"));
        JSONResponseAggregator aggregate = new JSONResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(json1);
        data.add(json2);
        String sorted = aggregate.aggregate(data, "ProcessId", true, Integer.valueOf(1), Integer.valueOf(2));
        logger.debug((Object)sorted);
        JSONObject aggregated = new JSONObject(sorted);
        Assert.assertNotNull((Object)aggregated);
        Object processes = aggregated.get("processes");
        Assert.assertNotNull((Object)processes);
        Assert.assertTrue((boolean)(processes instanceof JSONArray));
        JSONArray processDefs = (JSONArray)processes;
        Assert.assertEquals((long)2L, (long)processDefs.length());
        String value1 = ((JSONObject)processDefs.get(0)).getString("process-id");
        Assert.assertEquals((Object)"3", (Object)value1);
        String value2 = ((JSONObject)processDefs.get(1)).getString("process-id");
        Assert.assertEquals((Object)"4", (Object)value2);
    }

    @Test
    public void testSortProcessDefinitionsNextPageDescending() throws Exception {
        String json1 = this.read(this.getClass().getResourceAsStream("/json/process-def-1.json"));
        String json2 = this.read(this.getClass().getResourceAsStream("/json/process-def-2.json"));
        JSONResponseAggregator aggregate = new JSONResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(json1);
        data.add(json2);
        String sorted = aggregate.aggregate(data, "ProcessId", false, Integer.valueOf(1), Integer.valueOf(2));
        logger.debug((Object)sorted);
        JSONObject aggregated = new JSONObject(sorted);
        Assert.assertNotNull((Object)aggregated);
        Object processes = aggregated.get("processes");
        Assert.assertNotNull((Object)processes);
        Assert.assertTrue((boolean)(processes instanceof JSONArray));
        JSONArray processDefs = (JSONArray)processes;
        Assert.assertEquals((long)2L, (long)processDefs.length());
        String value1 = ((JSONObject)processDefs.get(0)).getString("process-id");
        Assert.assertEquals((Object)"6", (Object)value1);
        String value2 = ((JSONObject)processDefs.get(1)).getString("process-id");
        Assert.assertEquals((Object)"5", (Object)value2);
    }

    @Test
    public void testSortProcessDefinitionsOutOfPage() throws Exception {
        String json1 = this.read(this.getClass().getResourceAsStream("/json/process-def-1.json"));
        String json2 = this.read(this.getClass().getResourceAsStream("/json/process-def-2.json"));
        JSONResponseAggregator aggregate = new JSONResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(json1);
        data.add(json2);
        String sorted = aggregate.aggregate(data, "ProcessId", true, Integer.valueOf(5), Integer.valueOf(2));
        logger.debug((Object)sorted);
        JSONObject aggregated = new JSONObject(sorted);
        Assert.assertNotNull((Object)aggregated);
        Object processes = aggregated.get("processes");
        Assert.assertNotNull((Object)processes);
        Assert.assertTrue((boolean)(processes instanceof JSONArray));
        JSONArray processDefs = (JSONArray)processes;
        Assert.assertEquals((long)0L, (long)processDefs.length());
    }

    @Test
    public void testAggregateContainers() throws Exception {
        String json1 = this.read(this.getClass().getResourceAsStream("/json/containers-1.json"));
        String json2 = this.read(this.getClass().getResourceAsStream("/json/containers-2.json"));
        JSONResponseAggregator aggregate = new JSONResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(json1);
        data.add(json2);
        String result = aggregate.aggregate(data);
        logger.debug((Object)result);
        JSONObject aggregated = new JSONObject(result);
        Assert.assertNotNull((Object)aggregated);
        JSONObject content = (JSONObject)((JSONObject)aggregated.get("result")).get("kie-containers");
        Object containers = content.get("kie-container");
        Assert.assertNotNull((Object)containers);
        Assert.assertTrue((boolean)(containers instanceof JSONArray));
        JSONArray processDefs = (JSONArray)containers;
        Assert.assertEquals((long)6L, (long)processDefs.length());
    }

    @Test
    public void testAggregateRawList() throws Exception {
        String json1 = this.read(this.getClass().getResourceAsStream("/json/raw-list-1.json"));
        String json2 = this.read(this.getClass().getResourceAsStream("/json/raw-list-2.json"));
        JSONResponseAggregator aggregate = new JSONResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(json1);
        data.add(json2);
        String result = aggregate.aggregate(data);
        logger.debug((Object)result);
        JSONArray aggregated = new JSONArray(result);
        Assert.assertNotNull((Object)aggregated);
        Assert.assertEquals((long)5L, (long)aggregated.length());
    }

    @Test
    public void testAggregateRawListWithPaging() throws Exception {
        String json1 = this.read(this.getClass().getResourceAsStream("/json/raw-list-1.json"));
        String json2 = this.read(this.getClass().getResourceAsStream("/json/raw-list-2.json"));
        JSONResponseAggregator aggregate = new JSONResponseAggregator();
        ArrayList<String> data = new ArrayList<String>();
        data.add(json1);
        data.add(json2);
        String result = aggregate.aggregate(data, null, true, Integer.valueOf(1), Integer.valueOf(2));
        logger.debug((Object)result);
        JSONArray aggregated = new JSONArray(result);
        Assert.assertNotNull((Object)aggregated);
        Assert.assertEquals((long)2L, (long)aggregated.length());
    }
}

