/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router;

import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.kie.server.router.Configuration;
import org.kie.server.router.ContainerInfo;

public class ConfigurationTest {
    @Test
    public void testRemoveServerWhenUnavailable() {
        Configuration config = new Configuration();
        config.addContainerHost("container1", "http://localhost:8080/server");
        config.addContainerHost("container2", "http://localhost:8180/server");
        config.addServerHost("server1", "http://localhost:8080/server");
        config.addServerHost("server2", "http://localhost:8180/server");
        ContainerInfo containerInfo = new ContainerInfo("test1.0", "test", "org.kie:test:1.0");
        config.addContainerInfo(containerInfo);
        Assert.assertEquals((long)2L, (long)config.getHostsPerContainer().size());
        Assert.assertEquals((long)2L, (long)config.getHostsPerServer().size());
        Assert.assertEquals((long)1L, (long)((Set)config.getHostsPerContainer().get("container1")).size());
        Assert.assertEquals((long)1L, (long)((Set)config.getHostsPerContainer().get("container2")).size());
        Assert.assertEquals((long)1L, (long)((Set)config.getHostsPerServer().get("server1")).size());
        Assert.assertEquals((long)1L, (long)((Set)config.getHostsPerServer().get("server2")).size());
        config.removeUnavailableServer("http://localhost:8180/server");
        Assert.assertEquals((long)2L, (long)config.getHostsPerContainer().size());
        Assert.assertEquals((long)2L, (long)config.getHostsPerServer().size());
        Assert.assertEquals((long)1L, (long)((Set)config.getHostsPerContainer().get("container1")).size());
        Assert.assertEquals((long)0L, (long)((Set)config.getHostsPerContainer().get("container2")).size());
        Assert.assertEquals((long)1L, (long)((Set)config.getHostsPerServer().get("server1")).size());
        Assert.assertEquals((long)0L, (long)((Set)config.getHostsPerServer().get("server2")).size());
    }

    @Test
    public void testRemoveServerWhenUnavailableRequestURL() {
        Configuration config = new Configuration();
        config.addContainerHost("container1", "http://localhost:8080/server");
        config.addContainerHost("container2", "http://localhost:8180/server");
        config.addServerHost("server1", "http://localhost:8080/server");
        config.addServerHost("server2", "http://localhost:8180/server");
        ContainerInfo containerInfo = new ContainerInfo("test1.0", "test", "org.kie:test:1.0");
        config.addContainerInfo(containerInfo);
        Assert.assertEquals((long)2L, (long)config.getHostsPerContainer().size());
        Assert.assertEquals((long)2L, (long)config.getHostsPerServer().size());
        Assert.assertEquals((long)1L, (long)((Set)config.getHostsPerContainer().get("container1")).size());
        Assert.assertEquals((long)1L, (long)((Set)config.getHostsPerContainer().get("container2")).size());
        Assert.assertEquals((long)1L, (long)((Set)config.getHostsPerServer().get("server1")).size());
        Assert.assertEquals((long)1L, (long)((Set)config.getHostsPerServer().get("server2")).size());
        config.removeUnavailableServer("http://localhost:8180/server/containers/instances/1");
        Assert.assertEquals((long)2L, (long)config.getHostsPerContainer().size());
        Assert.assertEquals((long)2L, (long)config.getHostsPerServer().size());
        Assert.assertEquals((long)1L, (long)((Set)config.getHostsPerContainer().get("container1")).size());
        Assert.assertEquals((long)0L, (long)((Set)config.getHostsPerContainer().get("container2")).size());
        Assert.assertEquals((long)1L, (long)((Set)config.getHostsPerServer().get("server1")).size());
        Assert.assertEquals((long)0L, (long)((Set)config.getHostsPerServer().get("server2")).size());
    }
}

