/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.attribute;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeBuilder;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieImpl;

public class ResponseCookieAttribute
implements ExchangeAttribute {
    private static final String TOKEN_PREFIX = "%{resp-cookie,";
    private final String cookieName;

    public ResponseCookieAttribute(String cookieName) {
        this.cookieName = cookieName;
    }

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        Cookie cookie = exchange.getResponseCookies().get(this.cookieName);
        if (cookie == null) {
            return null;
        }
        return cookie.getValue();
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        exchange.setResponseCookie(new CookieImpl(this.cookieName, newValue));
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Response cookie";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.startsWith(ResponseCookieAttribute.TOKEN_PREFIX) && token.endsWith("}")) {
                String cookieName = token.substring(ResponseCookieAttribute.TOKEN_PREFIX.length(), token.length() - 1);
                return new ResponseCookieAttribute(cookieName);
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

