/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router.repository;

import java.io.File;
import java.io.FileReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.logging.Logger;
import org.kie.server.router.Configuration;
import org.kie.server.router.KieServerRouter;
import org.kie.server.router.repository.ConfigurationMarshaller;

public class ConfigFileWatcher
implements Runnable {
    private static final Logger log = Logger.getLogger(KieServerRouter.class);
    private WatchService watcher;
    private Path toWatch;
    private AtomicBoolean active = new AtomicBoolean(true);
    private ConfigurationMarshaller marshaller;
    private Configuration configuration;

    public ConfigFileWatcher(String configFilePath, ConfigurationMarshaller marshaller, Configuration configuration) {
        this.marshaller = marshaller;
        this.configuration = configuration;
        this.toWatch = Paths.get(configFilePath, new String[0]);
        if (!Files.isDirectory(this.toWatch, new LinkOption[0])) {
            this.toWatch = Paths.get(configFilePath, new String[0]).getParent();
        }
        try {
            this.watcher = this.toWatch.getFileSystem().newWatchService();
            log.debug("About to start watching " + this.toWatch.toString());
            this.toWatch.register(this.watcher, StandardWatchEventKinds.ENTRY_MODIFY);
        }
        catch (Exception e) {
            log.error((Object)("Error when setting up config file watcher :: " + e.getMessage()), e);
            this.active.set(false);
        }
    }

    public void stop() {
        this.active.set(false);
    }

    @Override
    public void run() {
        try {
            while (this.active.get()) {
                WatchKey key = this.watcher.poll(5L, TimeUnit.SECONDS);
                if (key == null) continue;
                for (WatchEvent<?> event : key.pollEvents()) {
                    Path updatedFile = (Path)event.context();
                    File modifiedFile = updatedFile.toFile();
                    if (!modifiedFile.getName().equals("kie-server-router.json")) continue;
                    log.debug("Received config file update event, reloading...");
                    try {
                        FileReader reader = new FileReader(new File(this.toWatch.toFile(), "kie-server-router.json"));
                        Throwable throwable = null;
                        try {
                            Configuration updated = this.marshaller.unmarshall(reader);
                            this.configuration.reloadFrom(updated);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (reader == null) continue;
                            if (throwable != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            reader.close();
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)("Unexpected exception while reading updated configuration file :: " + e.getMessage()), e);
                    }
                }
                key.reset();
            }
        }
        catch (InterruptedException e) {
            log.debug("Interrupted exception received...");
        }
    }
}

