/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router.repository;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.logging.Logger;
import org.kie.server.router.Configuration;
import org.kie.server.router.KieServerRouter;
import org.kie.server.router.repository.ConfigurationMarshaller;

public class ConfigFileWatcher
implements Runnable {
    private static final Logger log = Logger.getLogger(KieServerRouter.class);
    private long sleepTime;
    private Path toWatch;
    private AtomicBoolean active;
    private ConfigurationMarshaller marshaller;
    private Configuration configuration;
    private long lastUpdate;

    public ConfigFileWatcher(String configFilePath, ConfigurationMarshaller marshaller, Configuration configuration) {
        block30: {
            this.sleepTime = Long.parseLong(System.getProperty("org.kie.server.router.config.watcher.interval", "30000"));
            this.active = new AtomicBoolean(true);
            this.lastUpdate = -1L;
            this.marshaller = marshaller;
            this.configuration = configuration;
            this.toWatch = Paths.get(configFilePath, new String[0]);
            if (!Files.isDirectory(this.toWatch, new LinkOption[0])) {
                this.toWatch = Paths.get(configFilePath, new String[0]).getParent();
            }
            this.toWatch = Paths.get(this.toWatch.toString(), "kie-server-router.json");
            try {
                if (this.toWatch.toFile().exists()) {
                    this.lastUpdate = Files.getLastModifiedTime(this.toWatch, new LinkOption[0]).toMillis();
                    break block30;
                }
                log.warnv("configuration file does not exist {0} , creating...", (Object)this.toWatch);
                String cfg = marshaller.marshall(configuration);
                File file = new File(this.toWatch.toString());
                if (file.createNewFile()) {
                    try (FileOutputStream fos = new FileOutputStream(file);
                         PrintWriter writer = new PrintWriter(fos);){
                        writer.write(cfg);
                    }
                }
                FileTime lastModified = Files.getLastModifiedTime(this.toWatch, new LinkOption[0]);
                this.lastUpdate = lastModified.toMillis();
            }
            catch (IOException e) {
                log.error((Object)"Unable to read last modified date of routers config file", e);
            }
            catch (Exception e) {
                log.error((Object)"Unable to writer config file", e);
            }
        }
    }

    public void stop() {
        this.active.set(false);
    }

    @Override
    public void run() {
        try {
            while (this.active.get()) {
                block20: {
                    try {
                        if (!this.toWatch.toFile().exists()) {
                            log.warnv("configuration file does not exist {0} ", (Object)this.toWatch);
                            Thread.sleep(this.sleepTime);
                            continue;
                        }
                        FileTime lastModified = Files.getLastModifiedTime(this.toWatch, new LinkOption[0]);
                        log.debug("Config file " + this.toWatch + " last modified " + lastModified);
                        if (lastModified.toMillis() <= this.lastUpdate) break block20;
                        log.debug("Config file updated, reloading...");
                        try (FileReader reader = new FileReader(this.toWatch.toFile());){
                            Configuration updated = this.marshaller.unmarshall(reader);
                            this.configuration.reloadFrom(updated);
                        }
                        catch (Exception e) {
                            log.error((Object)("Unexpected exception while reading updated configuration file :: " + e.getMessage()), e);
                        }
                        this.lastUpdate = lastModified.toMillis();
                    }
                    catch (IOException ioe) {
                        log.warn((Object)"Unexpected exception while watching config file, maybe file does not exist? ", ioe);
                    }
                }
                Thread.sleep(this.sleepTime);
            }
        }
        catch (InterruptedException e) {
            log.debug("Interrupted exception received...");
        }
    }
}

