/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Base64;
import org.jboss.logging.Logger;
import org.kie.server.router.KieServerRouterEnvironment;

public class HttpUtils {
    private static final Logger log = Logger.getLogger(HttpUtils.class);

    public static void deleteHttpCall(KieServerRouterEnvironment env, String url) throws Exception {
        URL controllerURL = new URL(url);
        HttpURLConnection con = (HttpURLConnection)controllerURL.openConnection();
        con.setRequestMethod("DELETE");
        con.setRequestProperty("Accept", "application/json");
        con.setRequestProperty("Content-Type", "application/json");
        con.setRequestProperty("Authorization", HttpUtils.getAuthorization(env));
        con.setDoOutput(true);
        log.debugf("Sending 'DELETE' request to URL : %s", (Object)controllerURL);
        int responseCode = con.getResponseCode();
        log.debugf("Response Code : %s", responseCode);
        if (responseCode > 204) {
            throw new IOException("Unsucessful response code " + responseCode);
        }
    }

    public static void getHttpCall(KieServerRouterEnvironment env, String url) throws Exception {
        URL controllerURL = new URL(url);
        HttpURLConnection con = (HttpURLConnection)controllerURL.openConnection();
        con.setRequestMethod("GET");
        con.setRequestProperty("Accept", "application/json");
        con.setRequestProperty("Content-Type", "application/json");
        con.setRequestProperty("Authorization", HttpUtils.getAuthorization(env));
        con.setDoOutput(true);
        log.debugf("Sending 'GET' request to URL : %s", (Object)controllerURL);
        int responseCode = con.getResponseCode();
        log.debugf("Response Code : %s", responseCode);
        if (responseCode != 200) {
            throw new IOException("Unsucessful response code " + responseCode);
        }
    }

    public static String putHttpCall(KieServerRouterEnvironment env, String url, String body) throws Exception {
        String inputLine;
        URL controllerURL = new URL(url);
        HttpURLConnection con = (HttpURLConnection)controllerURL.openConnection();
        con.setRequestMethod("PUT");
        con.setRequestProperty("Accept", "application/json");
        con.setRequestProperty("Content-Type", "application/json");
        con.setRequestProperty("Authorization", HttpUtils.getAuthorization(env));
        con.setDoOutput(true);
        if (body != null) {
            con.getOutputStream().write(body.getBytes("UTF-8"));
        }
        log.debugf("Sending 'PUT' request to URL : %s", (Object)controllerURL);
        int responseCode = con.getResponseCode();
        log.debugf("Response Code : %s", responseCode);
        if (responseCode > 201) {
            throw new IOException("Unsucessful response code " + responseCode);
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        return response.toString();
    }

    protected static String getAuthorization(KieServerRouterEnvironment env) throws Exception {
        if (env.hasKieControllerToken()) {
            return "Bearer " + env.getKieControllerToken();
        }
        return "Basic " + Base64.getEncoder().encodeToString((env.getKieControllerUser() + ":" + env.getKieControllerPwd()).getBytes("UTF-8"));
    }
}

