/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router.utils;

import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.Enumeration;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.jboss.logging.Logger;
import org.kie.server.router.utils.AliasedX509ExtendedKeyManager;

public class SSLContextBuilder {
    private static final Logger logger = Logger.getLogger(SSLContextBuilder.class);
    private static final String KEYSTORE_TYPE = "JKS";
    private String keystorePath;
    private String keystorePassword;
    private String keyAlias;

    public static SSLContextBuilder builder() {
        return new SSLContextBuilder();
    }

    public SSLContextBuilder setKeyStorePath(String keystorePath) {
        this.keystorePath = keystorePath;
        return this;
    }

    public SSLContextBuilder setKeyStorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
        return this;
    }

    public SSLContextBuilder setKeyAlias(String keystoreKeyAlias) {
        this.keyAlias = keystoreKeyAlias;
        return this;
    }

    public SSLContext buildTrustore() {
        SSLContext sSLContext;
        FileInputStream fis = new FileInputStream(this.keystorePath);
        try {
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            char[] trustStorePassword = this.keystorePassword.toCharArray();
            trustStore.load(fis, trustStorePassword);
            SSLContext context = SSLContext.getInstance("TLSv1.2");
            TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            factory.init(trustStore);
            TrustManager[] managers = factory.getTrustManagers();
            context.init(null, managers, null);
            SSLContext.setDefault(context);
            sSLContext = SSLContext.getDefault();
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        fis.close();
        return sSLContext;
    }

    public SSLContext build() {
        SSLContext sSLContext;
        logger.info("KeyStore path: " + this.keystorePath);
        FileInputStream fis = new FileInputStream(this.keystorePath);
        try {
            KeyStore keyStore = KeyStore.getInstance(KEYSTORE_TYPE);
            char[] password = this.keystorePassword.toCharArray();
            keyStore.load(fis, password);
            if (!keyStore.containsAlias(this.keyAlias)) {
                Enumeration<String> aliases = keyStore.aliases();
                StringBuilder messageBuilder = new StringBuilder("KeyStore does not contain configured alias '").append(this.keyAlias).append("'.");
                messageBuilder.append("Valid aliases are ");
                messageBuilder.append("{");
                while (aliases.hasMoreElements()) {
                    String nextAlias = aliases.nextElement();
                    messageBuilder.append(nextAlias);
                    if (!aliases.hasMoreElements()) continue;
                    messageBuilder.append(", ");
                }
                messageBuilder.append("}.");
                throw new IllegalArgumentException(messageBuilder.toString());
            }
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, password);
            KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
            KeyManager[] aliasedKeyManagers = new KeyManager[keyManagers.length];
            int arrayIndex = 0;
            for (KeyManager nextKeyManager : keyManagers) {
                AliasedX509ExtendedKeyManager aliasedKeyMananger;
                try {
                    aliasedKeyMananger = new AliasedX509ExtendedKeyManager(this.keyAlias, (X509KeyManager)nextKeyManager);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                aliasedKeyManagers[arrayIndex] = aliasedKeyMananger;
                ++arrayIndex;
            }
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(aliasedKeyManagers, null, null);
            sSLContext = sslContext;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                logger.error(e.getMessage());
                throw new RuntimeException(e);
            }
        }
        fis.close();
        return sSLContext;
    }
}

