/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router.proxy;

import io.undertow.server.HttpServerExchange;
import io.undertow.util.HttpString;
import org.kie.server.router.spi.RestrictionPolicy;

public class DefaultRestrictionPolicy
implements RestrictionPolicy {
    @Override
    public boolean restrictedEndpoint(HttpServerExchange exchange, String containerId) {
        String relativePath = exchange.getRelativePath();
        boolean isReadOnlyRequest = this.isGet(exchange.getRequestMethod());
        boolean isContainerResource = relativePath.endsWith("/containers/" + containerId);
        boolean isScannerResource = relativePath.endsWith("/scanner");
        boolean isReleaseIdResource = relativePath.endsWith("/release-id");
        return !isReadOnlyRequest && (isContainerResource || isScannerResource || isReleaseIdResource);
    }

    public String toString() {
        return "Default restriction policy (disabled management endpoints)";
    }

    private boolean isGet(HttpString requestMethod) {
        return requestMethod.equals(HttpString.tryFromString("GET"));
    }
}

