/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;
import org.kie.server.router.Configuration;
import org.kie.server.router.ContainerInfo;
import org.kie.server.router.KieServerRouterEnvironment;
import org.kie.server.router.repository.ConfigFileWatcher;
import org.kie.server.router.repository.ConfigurationMarshaller;
import org.kie.server.router.spi.ConfigRepository;
import org.kie.server.router.utils.FailedHostInfo;
import org.kie.server.router.utils.HttpUtils;

public class ConfigurationManager {
    private static final Logger log = Logger.getLogger(ConfigurationManager.class);
    private KieServerRouterEnvironment environment;
    private ConfigRepository repository;
    private Configuration configuration;
    private ConfigurationMarshaller marshaller;
    private ScheduledExecutorService executorService;
    private ScheduledFuture<?> failedHostsReconnects;
    private ScheduledFuture<?> addToControllerAttempts;
    private ScheduledFuture<?> removeFromControllerAttempts;
    private CopyOnWriteArrayList<FailedHostInfo> failedHosts = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<ContainerInfo> containersToAddToController = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<String> containersToRemoveFromController = new CopyOnWriteArrayList();
    private ConfigFileWatcher watcher;
    private CopyOnWriteArrayList<String> controllerContainers;
    private static final String CONTAINER_SPEC_JSON = "{\n    \"container-id\" : \"#1@\",\n    \"container-name\" : \"#2@\",\n    \"server-template-key\" : {\n      \"server-id\" : \"kie-server-router\",\n      \"server-name\" : \"KIE Server Router\"\n    },\n    \"release-id\" : {\n      \"group-id\" : \"#3@\",\n      \"artifact-id\" : \"#4@\",\n      \"version\" : \"#5@\"\n    },\n    \"configuration\" : { },\n    \"status\" : \"STARTED\"\n  }";

    public ConfigurationManager(KieServerRouterEnvironment environment, ConfigRepository repository, ScheduledExecutorService executorService) {
        this.marshaller = new ConfigurationMarshaller();
        this.environment = environment;
        this.repository = repository;
        this.executorService = executorService;
        this.configuration = repository.load();
        this.controllerContainers = new CopyOnWriteArrayList();
    }

    public void startWatcher() {
        if (this.watcher != null) {
            return;
        }
        this.watcher = new ConfigFileWatcher(this.environment, this);
        this.executorService.submit(this.watcher);
    }

    public void stopWatcher() {
        if (this.watcher == null) {
            return;
        }
        this.watcher.stop();
    }

    public String toJsonConfig() throws Exception {
        return this.marshaller.marshall(this.configuration);
    }

    public synchronized void persist() {
        this.repository.persist(this.configuration);
    }

    public synchronized void syncPersistent() {
        Configuration conf = this.repository.load();
        this.configuration.syncFromRepository(conf);
    }

    public synchronized void add(String containerId, String alias, String serverId, String serverUrl, String releaseId) {
        this.configuration.reloadFromRepository(this.repository.load());
        this.configuration.addContainerHost(containerId, serverUrl);
        this.configuration.addContainerHost(alias, serverUrl);
        this.configuration.addServerHost(serverId, serverUrl);
        this.configuration.addContainerInfo(new ContainerInfo(containerId, alias, releaseId));
        this.repository.persist(this.configuration);
        this.updateControllerOnAdd(containerId, releaseId, alias, new ContainerInfo(containerId, alias, releaseId));
    }

    public synchronized void remove(String containerId, String alias, String serverId, String serverUrl, String releaseId) {
        this.configuration.reloadFromRepository(this.repository.load());
        this.configuration.removeContainerHost(containerId, serverUrl);
        this.configuration.removeContainerHost(alias, serverUrl);
        this.configuration.removeServerHost(serverId, serverUrl);
        this.configuration.removeContainerInfo(new ContainerInfo(containerId, alias, releaseId));
        this.repository.persist(this.configuration);
        this.updateControllerOnRemove(containerId);
    }

    public synchronized Configuration getConfiguration() {
        return this.configuration;
    }

    public void addControllerContainers(List<String> containers) {
        this.controllerContainers.addAll(containers);
    }

    private KieServerRouterEnvironment environment() {
        return this.environment;
    }

    public synchronized FailedHostInfo disconnectFailedHost(String url) {
        log.info("Server at " + url + " is now offline");
        FailedHostInfo failedHost = this.configuration.removeUnavailableServer(url);
        this.failedHosts.add(failedHost);
        log.debug("Scheduling host checks...");
        long attemptInterval = this.environment().getKieControllerAttemptInterval();
        this.failedHostsReconnects = this.executorService.scheduleAtFixedRate(this::pingFailedHost, attemptInterval, attemptInterval, TimeUnit.SECONDS);
        this.repository.persist(this.configuration);
        return failedHost;
    }

    public synchronized void reconnectFailedHost(FailedHostInfo failedHostInfo) {
        log.info("Server at " + failedHostInfo.getServerUrl() + " is back online");
        this.configuration.reloadFromRepository(this.repository.load());
        for (String containerId : failedHostInfo.getContainers()) {
            this.configuration.addContainerHost(containerId, failedHostInfo.getServerUrl());
        }
        this.configuration.addServerHost(failedHostInfo.getServerId(), failedHostInfo.getServerUrl());
        this.repository.persist(this.configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pingFailedHost() {
        if (this.failedHosts.isEmpty()) {
            return;
        }
        Iterator<FailedHostInfo> it = this.failedHosts.iterator();
        ArrayList<FailedHostInfo> toRemove = new ArrayList<FailedHostInfo>();
        while (it.hasNext()) {
            FailedHostInfo failedHost = it.next();
            if (this.environment().getKieControllerRecoveryAttemptLimit() == failedHost.getAttempts()) {
                toRemove.add(failedHost);
                log.info("Host " + failedHost.getServerUrl() + " has reached reconnect attempts limit " + this.environment().getKieControllerRecoveryAttemptLimit() + " quiting");
                continue;
            }
            try {
                HttpUtils.getHttpCall(this.environment(), failedHost.getServerUrl());
                this.failedHostsReconnects.cancel(false);
                this.reconnectFailedHost(failedHost);
                toRemove.add(failedHost);
            }
            catch (Exception e) {
                log.debug("Host " + failedHost.getServerUrl() + " is still not available, attempting to reconnect in " + this.environment().getKieControllerAttemptInterval() + " seconds, error " + e.getMessage());
            }
            finally {
                failedHost.attempted();
            }
        }
        this.failedHosts.removeAll(toRemove);
    }

    private void updateControllerOnRemove(String containerId) {
        List hostsPerContainer;
        if (this.environment().hasKieControllerUrl() && this.controllerContainers.contains(containerId) && (hostsPerContainer = this.configuration.getHostsPerContainer().getOrDefault(containerId, Collections.emptyList())).isEmpty()) {
            this.controllerContainers.remove(containerId);
            this.containersToRemoveFromController.add(containerId);
            if (this.removeFromControllerAttempts == null) {
                this.removeFromControllerAttempts = this.executorService.scheduleAtFixedRate(() -> {
                    try {
                        ArrayList<String> sent = new ArrayList<String>();
                        for (String container : this.containersToRemoveFromController) {
                            if (this.controllerContainers.contains(container)) {
                                sent.add(container);
                                continue;
                            }
                            this.dropFromController(container);
                            sent.add(container);
                        }
                        this.containersToRemoveFromController.removeAll(sent);
                        if (this.containersToRemoveFromController.isEmpty()) {
                            this.removeFromControllerAttempts.cancel(false);
                            this.removeFromControllerAttempts = null;
                        }
                    }
                    catch (Exception e) {
                        log.warn("Exception when notifying controller about deleted containers " + e.getMessage() + " next attempt in " + this.environment().getKieControllerAttemptInterval() + " seconds");
                        log.debug(e);
                    }
                }, this.environment().getKieControllerAttemptInterval(), this.environment().getKieControllerAttemptInterval(), TimeUnit.SECONDS);
            }
        }
    }

    private void updateControllerOnAdd(String containerId, String releaseId, String alias, ContainerInfo containerInfo) {
        if (this.environment().hasKieControllerUrl() && releaseId != null && !this.controllerContainers.contains(containerId)) {
            this.controllerContainers.add(containerId);
            this.containersToAddToController.add(containerInfo);
            if (this.addToControllerAttempts == null) {
                this.addToControllerAttempts = this.executorService.scheduleAtFixedRate(() -> {
                    try {
                        ArrayList<ContainerInfo> sent = new ArrayList<ContainerInfo>();
                        for (ContainerInfo container : this.containersToAddToController) {
                            if (!this.controllerContainers.contains(container.getContainerId())) {
                                sent.add(container);
                                continue;
                            }
                            this.pushToController(container.getReleaseId(), container.getContainerId(), container.getAlias());
                            sent.add(container);
                        }
                        this.containersToAddToController.removeAll(sent);
                        if (this.containersToAddToController.isEmpty()) {
                            this.addToControllerAttempts.cancel(false);
                            this.addToControllerAttempts = null;
                        }
                    }
                    catch (Exception e) {
                        log.warn("Exception when notifying controller about deleted containers " + e.getMessage() + " next attempt in " + this.environment().getKieControllerAttemptInterval() + " seconds");
                        log.debug((Object)"Stacktrace", e);
                    }
                }, this.environment().getKieControllerAttemptInterval(), this.environment().getKieControllerAttemptInterval(), TimeUnit.SECONDS);
            }
        }
    }

    private void pushToController(String releaseId, String containerId, String alias) throws Exception {
        String[] gav = releaseId.split(":");
        String jsonPayload = CONTAINER_SPEC_JSON.replaceFirst("#1@", containerId).replaceFirst("#2@", alias).replaceFirst("#3@", gav[0]).replaceFirst("#4@", gav[1]).replaceFirst("#5@", gav[2]);
        HttpUtils.putHttpCall(this.environment(), this.environment().getKieControllerUrl() + "/management/servers/" + this.environment().getRouterId() + "/containers/" + containerId, jsonPayload);
        log.infof("Added %s container into controller at %s ", (Object)containerId, (Object)this.environment().getKieControllerUrl());
    }

    private void dropFromController(String containerId) throws Exception {
        HttpUtils.deleteHttpCall(this.environment(), this.environment().getKieControllerUrl() + "/management/servers/" + this.environment().getRouterId() + "/containers/" + containerId);
        log.infof("Removed %s container from controller at %s ", (Object)containerId, (Object)this.environment().getKieControllerUrl());
    }

    public void close() {
        if (this.watcher != null) {
            this.watcher.stop();
        }
    }
}

