/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.router.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.util.stream.Collectors;
import org.kie.server.router.KieServerRouterEnvironment;
import org.kie.server.router.KieServerRouterResponsesUtil;

public class KieServerInfoHandler
implements HttpHandler {
    private KieServerRouterEnvironment env;

    public KieServerInfoHandler(KieServerRouterEnvironment env) {
        this.env = env;
    }

    private KieServerRouterEnvironment environment() {
        return this.env;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (exchange.getRequestMethod().equals(HttpString.tryFromString("OPTIONS"))) {
            String response = "GET, OPTIONS";
            exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "text/plain;charset=UTF-8");
            exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, response.getBytes("UTF-8").length);
            exchange.getResponseHeaders().put(Headers.ALLOW, response);
            exchange.getResponseSender().send(response);
        }
        HeaderValues accept = exchange.getRequestHeaders().get(Headers.ACCEPT);
        HeaderValues kieContentType = exchange.getRequestHeaders().get("X-KIE-ContentType");
        String acceptRequest = "";
        if (accept != null) {
            acceptRequest = accept.stream().collect(Collectors.joining(","));
        }
        String kieContentTypeRequest = "";
        if (kieContentType != null) {
            kieContentTypeRequest = kieContentType.stream().collect(Collectors.joining(","));
        }
        String response = KieServerRouterResponsesUtil.buildJAXBServerInfoReponse(this.environment());
        String contentTypeResponse = "application/xml";
        if (acceptRequest.toLowerCase().contains("json") || kieContentTypeRequest.toLowerCase().contains("json")) {
            response = KieServerRouterResponsesUtil.buildJSONServerInfoReponse(this.environment());
            contentTypeResponse = "application/json";
        } else if (kieContentTypeRequest.toLowerCase().contains("xstream")) {
            response = KieServerRouterResponsesUtil.buildXSTREAMServerInfoReponse(this.environment());
            contentTypeResponse = "application/xml";
        }
        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, contentTypeResponse);
        exchange.getResponseHeaders().put(Headers.CONTENT_LENGTH, response.getBytes("UTF-8").length);
        exchange.getResponseSender().send(response);
    }
}

