/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.services.casemgmt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jbpm.casemgmt.api.model.CaseRole;
import org.jbpm.casemgmt.api.model.instance.CaseMilestoneInstance;
import org.jbpm.casemgmt.api.model.instance.CaseRoleInstance;
import org.jbpm.casemgmt.api.model.instance.CaseStageInstance;
import org.jbpm.casemgmt.api.model.instance.CommentInstance;
import org.jbpm.services.api.model.NodeInstanceDesc;
import org.jbpm.services.api.model.ProcessDefinition;
import org.jbpm.services.api.model.ProcessInstanceDesc;
import org.kie.api.runtime.query.QueryContext;
import org.kie.api.task.model.Group;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.User;
import org.kie.server.api.model.cases.CaseAdHocFragment;
import org.kie.server.api.model.cases.CaseComment;
import org.kie.server.api.model.cases.CaseDefinition;
import org.kie.server.api.model.cases.CaseInstance;
import org.kie.server.api.model.cases.CaseMilestone;
import org.kie.server.api.model.cases.CaseMilestoneDefinition;
import org.kie.server.api.model.cases.CaseRoleAssignment;
import org.kie.server.api.model.cases.CaseStage;
import org.kie.server.api.model.cases.CaseStageDefinition;
import org.kie.server.api.model.definition.ProcessDefinitionList;
import org.kie.server.api.model.instance.NodeInstance;
import org.kie.server.api.model.instance.ProcessInstance;
import org.kie.server.api.model.instance.TaskSummary;
import org.kie.server.api.model.instance.TaskSummaryList;

public class ConvertUtils {
    public static List<CaseRoleAssignment> transformRoleAssignment(Collection<CaseRoleInstance> roleInstances) {
        ArrayList<CaseRoleAssignment> roleAssignments = new ArrayList<CaseRoleAssignment>();
        if (roleInstances != null) {
            roleInstances.forEach(r -> roleAssignments.add(CaseRoleAssignment.builder().name(r.getRoleName()).users(r.getRoleAssignments().stream().filter(oe -> oe instanceof User).map(OrganizationalEntity::getId).collect(Collectors.toList())).groups(r.getRoleAssignments().stream().filter(oe -> oe instanceof Group).map(OrganizationalEntity::getId).collect(Collectors.toList())).build()));
        }
        return roleAssignments;
    }

    public static List<CaseMilestone> transformMilestones(Collection<CaseMilestoneInstance> milestoneInstances) {
        ArrayList<CaseMilestone> milestones = new ArrayList<CaseMilestone>();
        if (milestoneInstances != null) {
            milestoneInstances.forEach(m -> milestones.add(CaseMilestone.builder().id(m.getId()).name(m.getName()).status(m.getStatus().toString()).achieved(m.isAchieved()).achievedAt(m.getAchievedAt()).build()));
        }
        return milestones;
    }

    public static List<CaseStage> transformStages(Collection<CaseStageInstance> stageInstances) {
        ArrayList<CaseStage> stages = new ArrayList<CaseStage>();
        if (stageInstances != null) {
            stageInstances.forEach(s -> stages.add(CaseStage.builder().id(s.getId()).name(s.getName()).status(s.getStatus().toString()).activeNodes(ConvertUtils.transformNodeInstance(s.getActiveNodes())).adHocFragments(s.getAdHocFragments().stream().map(adhoc -> CaseAdHocFragment.builder().name(adhoc.getName()).type(adhoc.getType()).build()).collect(Collectors.toList())).build()));
        }
        return stages;
    }

    public static CaseInstance transformCaseInstance(org.jbpm.casemgmt.api.model.instance.CaseInstance actualCaseInstance) {
        if (actualCaseInstance == null) {
            return null;
        }
        return CaseInstance.builder().caseId(actualCaseInstance.getCaseId()).caseDefinitionId(actualCaseInstance.getCaseDefinitionId()).containerId(actualCaseInstance.getDeploymentId()).caseDescription(actualCaseInstance.getCaseDescription()).caseOwner(actualCaseInstance.getOwner()).caseStatus(actualCaseInstance.getStatus()).startedAt(actualCaseInstance.getStartedAt()).completedAt(actualCaseInstance.getCompletedAt()).completionMessage(actualCaseInstance.getCompletionMessage()).build();
    }

    public static List<CaseComment> transformCaseComments(Collection<CommentInstance> caseComments) {
        ArrayList<CaseComment> comments = new ArrayList<CaseComment>();
        if (caseComments != null) {
            caseComments.forEach(c -> comments.add(CaseComment.builder().id(c.getId()).author(c.getAuthor()).addedAt(c.getCreatedAt()).text(c.getComment()).build()));
        }
        return comments;
    }

    public static List<NodeInstance> transformNodeInstance(Collection<NodeInstanceDesc> nodeInstances) {
        if (nodeInstances == null) {
            return Collections.emptyList();
        }
        return nodeInstances.stream().map(an -> NodeInstance.builder().id(an.getId()).name(an.getName()).date(an.getDataTimeStamp()).completed(Boolean.valueOf(an.isCompleted())).connection(an.getConnection()).containerId(an.getDeploymentId()).nodeType(an.getNodeType()).nodeId(an.getNodeId()).processInstanceId(an.getProcessInstanceId()).workItemId(an.getWorkItemId()).referenceId(an.getReferenceId()).build()).collect(Collectors.toList());
    }

    public static QueryContext buildQueryContext(Integer page, Integer pageSize) {
        return new QueryContext(Integer.valueOf(page * pageSize), pageSize);
    }

    public static QueryContext buildQueryContext(Integer page, Integer pageSize, String orderBy, boolean asc) {
        if (orderBy != null && !orderBy.isEmpty()) {
            return new QueryContext(Integer.valueOf(page * pageSize), pageSize, orderBy, asc);
        }
        return new QueryContext(Integer.valueOf(page * pageSize), pageSize);
    }

    public static List<ProcessInstance> transformProcessInstance(Collection<ProcessInstanceDesc> processInstanceDescs) {
        if (processInstanceDescs == null) {
            return Collections.emptyList();
        }
        return processInstanceDescs.stream().map(pi -> ProcessInstance.builder().id(pi.getId()).processId(pi.getProcessId()).processName(pi.getProcessName()).processVersion(pi.getProcessVersion()).containerId(pi.getDeploymentId()).processInstanceDescription(pi.getProcessInstanceDescription()).correlationKey(pi.getCorrelationKey()).parentInstanceId(pi.getParentId()).date(pi.getDataTimeStamp()).initiator(pi.getInitiator()).state(pi.getState()).build()).collect(Collectors.toList());
    }

    public static List<CaseInstance> transformCaseInstances(Collection<org.jbpm.casemgmt.api.model.instance.CaseInstance> caseInstanceDescs) {
        if (caseInstanceDescs == null) {
            return Collections.emptyList();
        }
        return caseInstanceDescs.stream().map(c -> ConvertUtils.transformCaseInstance(c)).collect(Collectors.toList());
    }

    public static CaseDefinition transformCase(org.jbpm.casemgmt.api.model.CaseDefinition caseDefinition) {
        if (caseDefinition == null) {
            return null;
        }
        return CaseDefinition.builder().id(caseDefinition.getId()).caseIdPrefix(caseDefinition.getIdentifierPrefix()).name(caseDefinition.getName()).version(caseDefinition.getVersion()).containerId(caseDefinition.getDeploymentId()).roles(caseDefinition.getCaseRoles().stream().collect(Collectors.toMap(CaseRole::getName, CaseRole::getCardinality))).adHocFragments(caseDefinition.getAdHocFragments().stream().map(adf -> CaseAdHocFragment.builder().name(adf.getName()).type(adf.getType()).build()).collect(Collectors.toList())).stages(caseDefinition.getCaseStages().stream().map(s -> CaseStageDefinition.builder().id(s.getId()).name(s.getName()).adHocFragments(s.getAdHocFragments().stream().map(adf -> CaseAdHocFragment.builder().name(adf.getName()).type(adf.getType()).build()).collect(Collectors.toList())).build()).collect(Collectors.toList())).milestones(caseDefinition.getCaseMilestones().stream().map(m -> CaseMilestoneDefinition.builder().id(m.getId()).name(m.getName()).mandatory(m.isMandatory()).build()).collect(Collectors.toList())).build();
    }

    public static List<CaseDefinition> transformCases(Collection<org.jbpm.casemgmt.api.model.CaseDefinition> caseDescs) {
        if (caseDescs == null) {
            return Collections.emptyList();
        }
        return caseDescs.stream().map(c -> ConvertUtils.transformCase(c)).collect(Collectors.toList());
    }

    public static TaskSummaryList convertToTaskSummaryList(Collection<org.kie.api.task.model.TaskSummary> tasks) {
        if (tasks == null) {
            return new TaskSummaryList(new TaskSummary[0]);
        }
        TaskSummary[] instances = new TaskSummary[tasks.size()];
        int counter = 0;
        for (org.kie.api.task.model.TaskSummary taskSummary : tasks) {
            instances[counter] = ConvertUtils.convertToTaskSummary(taskSummary);
            ++counter;
        }
        return new TaskSummaryList(instances);
    }

    public static TaskSummary convertToTaskSummary(org.kie.api.task.model.TaskSummary taskSummary) {
        TaskSummary task = TaskSummary.builder().id(taskSummary.getId()).name(taskSummary.getName()).description(taskSummary.getDescription()).subject(taskSummary.getSubject()).taskParentId(taskSummary.getParentId()).activationTime(taskSummary.getActivationTime()).actualOwner(taskSummary.getActualOwnerId()).containerId(taskSummary.getDeploymentId()).createdBy(taskSummary.getCreatedById()).createdOn(taskSummary.getCreatedOn()).expirationTime(taskSummary.getExpirationTime()).priority(taskSummary.getPriority()).processId(taskSummary.getProcessId()).processInstanceId(taskSummary.getProcessInstanceId()).status(taskSummary.getStatusId()).skipable(taskSummary.isSkipable().booleanValue()).build();
        return task;
    }

    public static ProcessDefinitionList transformProcesses(Collection<ProcessDefinition> definitions) {
        if (definitions == null) {
            return new ProcessDefinitionList(new org.kie.server.api.model.definition.ProcessDefinition[0]);
        }
        ArrayList<org.kie.server.api.model.definition.ProcessDefinition> processes = new ArrayList<org.kie.server.api.model.definition.ProcessDefinition>(definitions.size());
        for (ProcessDefinition pd : definitions) {
            org.kie.server.api.model.definition.ProcessDefinition definition = ConvertUtils.transformProcess(pd);
            processes.add(definition);
        }
        return new ProcessDefinitionList(processes);
    }

    public static org.kie.server.api.model.definition.ProcessDefinition transformProcess(ProcessDefinition processDesc) {
        if (processDesc == null) {
            return null;
        }
        org.kie.server.api.model.definition.ProcessDefinition processDefinition = org.kie.server.api.model.definition.ProcessDefinition.builder().id(processDesc.getId()).name(processDesc.getName()).packageName(processDesc.getPackageName()).version(processDesc.getVersion()).containerId(processDesc.getDeploymentId()).dynamic(processDesc.isDynamic()).build();
        return processDefinition;
    }
}

