/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.backend.elasticsearch.rest.impl;

import java.text.ParseException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.dashbuilder.dataprovider.backend.elasticsearch.ElasticSearchValueTypeMapper;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.EmptySearchResponse;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.SearchHitResponse;
import org.dashbuilder.dataprovider.backend.elasticsearch.rest.model.SearchResponse;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.def.ElasticSearchDataSetDef;
import org.dashbuilder.dataset.group.GroupStrategy;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHitField;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.metrics.avg.Avg;
import org.elasticsearch.search.aggregations.metrics.cardinality.Cardinality;
import org.elasticsearch.search.aggregations.metrics.max.Max;
import org.elasticsearch.search.aggregations.metrics.min.Min;
import org.elasticsearch.search.aggregations.metrics.sum.Sum;
import org.elasticsearch.search.aggregations.metrics.valuecount.ValueCount;

public class NativeClientResponseParser {
    private final ElasticSearchValueTypeMapper valueTypeMapper;

    public NativeClientResponseParser(ElasticSearchValueTypeMapper valueTypeMapper) {
        this.valueTypeMapper = valueTypeMapper;
    }

    public SearchResponse parse(DataSetMetadata metadata, org.elasticsearch.action.search.SearchResponse response, List<DataColumn> columns) throws ParseException {
        boolean existAggregations;
        long tookInMilis = response.getTookInMillis();
        int responseCode = response.status().getStatus();
        long totalHits = response.getHits().getTotalHits();
        float maxScore = response.getHits().getMaxScore();
        int totalShards = response.getTotalShards();
        int successfulShards = response.getSuccessfulShards();
        int shardFailures = response.getFailedShards();
        int hitCount = response.getHits().getHits().length;
        Aggregations aggregations = response.getAggregations();
        boolean bl = existAggregations = aggregations != null && !aggregations.asList().isEmpty();
        if (hitCount == 0 && !existAggregations) {
            return new EmptySearchResponse(tookInMilis, responseCode, totalHits, maxScore, totalShards, successfulShards, shardFailures);
        }
        LinkedList<SearchHitResponse> hits = new LinkedList<SearchHitResponse>();
        if (existAggregations) {
            this.parseAggregationsResponse(metadata, hits, aggregations, columns);
        } else {
            this.parseHitsResponse(metadata, hits, response.getHits(), columns);
        }
        if (hits.isEmpty()) {
            return new EmptySearchResponse(tookInMilis, responseCode, totalHits, maxScore, totalShards, successfulShards, shardFailures);
        }
        return new SearchResponse(tookInMilis, responseCode, totalHits, maxScore, totalShards, successfulShards, shardFailures, hits.toArray(new SearchHitResponse[hits.size()]));
    }

    private void parseHitsResponse(DataSetMetadata metadata, List<SearchHitResponse> hits, SearchHits responseHits, List<DataColumn> columns) throws ParseException {
        SearchHit[] resultHits = responseHits.getHits();
        if (null != resultHits) {
            for (SearchHit searchHit : resultHits) {
                String fieldName;
                float score = searchHit.getScore();
                String id = searchHit.getId();
                String type = searchHit.getType();
                String index = searchHit.getIndex();
                long version = searchHit.getVersion();
                Map sourceAsMap = searchHit.getSource();
                Map sourceFields = searchHit.getFields();
                HashMap<String, Object> fields = new HashMap<String, Object>();
                if (null != sourceFields && !sourceFields.isEmpty()) {
                    for (Map.Entry entry : sourceFields.entrySet()) {
                        fieldName = (String)entry.getKey();
                        SearchHitField hitValue = (SearchHitField)entry.getValue();
                        if (hitValue == null) continue;
                        Object fieldValue = hitValue.getValue();
                        fields.put(fieldName, fieldValue);
                    }
                } else if (null != sourceAsMap && !sourceAsMap.isEmpty()) {
                    for (Map.Entry entry : sourceAsMap.entrySet()) {
                        fieldName = (String)entry.getKey();
                        Object fieldValue = entry.getValue();
                        fields.put(fieldName, fieldValue);
                    }
                }
                SearchHitResponse hit = new SearchHitResponse(score, index, id, type, version, this.orderAndParseFields(metadata, fields, columns));
                hits.add(hit);
            }
        }
    }

    private void parseAggregationsResponse(DataSetMetadata metadata, List<SearchHitResponse> hits, Aggregations aggregations, List<DataColumn> columns) throws ParseException {
        this.parseAggregationsResponse(metadata, hits, aggregations, null, columns);
    }

    private void parseAggregationsResponse(DataSetMetadata metadata, List<SearchHitResponse> hits, Aggregations aggregations, SearchHitResponse sourceHit, List<DataColumn> columns) throws ParseException {
        Map aggregationMap = aggregations.asMap();
        if (null != aggregationMap && !aggregationMap.isEmpty()) {
            HashMap<String, Object> fields = new HashMap();
            if (null != sourceHit && null != sourceHit.getFields()) {
                fields = sourceHit.getFields();
            }
            for (Aggregation aggregation : aggregations.asList()) {
                List buckets;
                StringTerms agg;
                Number value = null;
                if (aggregation instanceof StringTerms) {
                    agg = (StringTerms)aggregation;
                    buckets = agg.getBuckets();
                    if (buckets != null && !buckets.isEmpty()) {
                        for (Terms.Bucket bucket : buckets) {
                            String aggValue = bucket.getKeyAsString();
                            HashMap<String, Object> bucketFields = new HashMap<String, Object>();
                            bucketFields.put(agg.getName(), aggValue);
                            SearchHitResponse hit = new SearchHitResponse(bucketFields);
                            Aggregations bucketAggregations = bucket.getAggregations();
                            if (null == bucketAggregations || bucketAggregations.asList().isEmpty()) continue;
                            this.parseAggregationsResponse(metadata, hits, bucketAggregations, hit, columns);
                        }
                    }
                } else {
                    if (null == sourceHit) {
                        sourceHit = new SearchHitResponse(fields);
                    }
                    if (aggregation instanceof ValueCount) {
                        agg = (ValueCount)aggregation;
                        value = agg.getValue();
                    } else if (aggregation instanceof Sum) {
                        agg = (Sum)aggregation;
                        value = agg.getValue();
                    } else if (aggregation instanceof Min) {
                        agg = (Min)aggregation;
                        value = agg.getValue();
                    } else if (aggregation instanceof Max) {
                        agg = (Max)aggregation;
                        value = agg.getValue();
                    } else if (aggregation instanceof Avg) {
                        agg = (Avg)aggregation;
                        value = agg.getValue();
                    } else if (aggregation instanceof Cardinality) {
                        agg = (Cardinality)aggregation;
                        value = agg.getValue();
                    } else if (aggregation instanceof InternalMultiBucketAggregation && null != (buckets = (agg = (InternalMultiBucketAggregation)aggregation).getBuckets()) && !buckets.isEmpty()) {
                        for (Object oBucket : buckets) {
                            if (!(oBucket instanceof MultiBucketsAggregation.Bucket)) continue;
                            MultiBucketsAggregation.Bucket bucket = (MultiBucketsAggregation.Bucket)oBucket;
                            String aggValue = bucket.getKeyAsString();
                            HashMap<String, Object> bucketFields = new HashMap<String, Object>();
                            bucketFields.put(agg.getName(), aggValue);
                            SearchHitResponse hit = new SearchHitResponse(bucketFields);
                            Aggregations bucketAggregations = bucket.getAggregations();
                            if (null == bucketAggregations || bucketAggregations.asList().isEmpty()) continue;
                            this.parseAggregationsResponse(metadata, hits, bucketAggregations, hit, columns);
                        }
                    }
                }
                String aggName = aggregation.getName();
                if (null == value) continue;
                fields.put(aggName, value);
            }
        }
        if (null != sourceHit && null != sourceHit.getFields() && !sourceHit.getFields().isEmpty()) {
            SearchHitResponse result = new SearchHitResponse(sourceHit.getScore(), sourceHit.getIndex(), sourceHit.getId(), sourceHit.getType(), sourceHit.getVersion(), this.orderAndParseFields(metadata, sourceHit.getFields(), columns));
            hits.add(result);
        }
    }

    private Map<String, Object> orderAndParseFields(DataSetMetadata metadata, Map<String, Object> fields, List<DataColumn> columns) throws ParseException {
        if (fields == null) {
            return null;
        }
        if (columns == null) {
            return new LinkedHashMap<String, Object>(fields);
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (DataColumn column : columns) {
            String columnId = column.getId();
            if (!fields.containsKey(columnId)) continue;
            Object value = fields.get(columnId);
            Object parsedValue = this.parseValue(metadata, column, value);
            result.put(columnId, parsedValue);
        }
        return result;
    }

    private Object parseValue(DataSetMetadata metadata, DataColumn column, Object value) throws ParseException {
        if (null != metadata && null != column && null != value) {
            String valueStr = value.toString();
            ElasticSearchDataSetDef def = (ElasticSearchDataSetDef)metadata.getDefinition();
            ColumnType columnType = column.getColumnType();
            if (ColumnType.TEXT.equals((Object)columnType)) {
                return this.valueTypeMapper.parseText(def, column.getId(), valueStr);
            }
            if (ColumnType.LABEL.equals((Object)columnType)) {
                boolean isColumnGroup = column.getColumnGroup() != null && column.getColumnGroup().getStrategy().equals((Object)GroupStrategy.FIXED);
                return this.valueTypeMapper.parseLabel(def, column.getId(), valueStr, isColumnGroup);
            }
            if (ColumnType.NUMBER.equals((Object)columnType)) {
                return this.valueTypeMapper.parseNumeric(def, column.getId(), valueStr);
            }
            if (ColumnType.DATE.equals((Object)columnType)) {
                if (value instanceof Number) {
                    Number number = (Number)value;
                    return this.valueTypeMapper.parseDate(def, column.getId(), number.longValue());
                }
                return this.valueTypeMapper.parseDate(def, column.getId(), valueStr);
            }
            throw new UnsupportedOperationException("Cannot parse value for column with id [" + column.getId() + "] (Data Set UUID [" + def.getUUID() + "]). Value core type not supported. Expecting string or number or date core field types.");
        }
        return null;
    }
}

