/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.dashbuilder.dataprovider.sql.JDBCUtils;
import org.dashbuilder.dataprovider.sql.SQLDataSetTestBase;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.SQLDataSetDef;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SQLColumnsTypeTest
extends SQLDataSetTestBase {
    String CLOB_TABLE = "CLOB_TABLE";
    String CLOB_COLUMN = "CLOB_CL";
    String CLOB_VAL = "TEST_CLOB";

    @Before
    public void prepareForClobTest() throws SQLException {
        String TABLE_SQL = this.createTableWithClobSQL();
        String INSERT = "INSERT INTO " + this.CLOB_TABLE + " VALUES(1, '" + this.CLOB_VAL + "')";
        JDBCUtils.execute((Connection)this.conn, (String)TABLE_SQL);
        JDBCUtils.execute((Connection)this.conn, (String)INSERT);
    }

    @Override
    public void tearDown() throws Exception {
        this.removeClobTable();
        super.tearDown();
    }

    @Override
    public void testAll() throws Exception {
        this.prepareForClobTest();
        this.clobColumnTest();
        this.removeClobTable();
    }

    @Test
    public void clobColumnTest() throws Exception {
        SQLDataSetDef def = new SQLDataSetDef();
        def.setDbTable(this.CLOB_TABLE);
        def.setDataSource("test");
        this.dataSetDefRegistry.registerDataSetDef((DataSetDef)def);
        DataSet ds = this.sqlDataSetProvider.lookupDataSet((DataSetDef)def, null);
        DataColumn clobColumn = ds.getColumnById(this.CLOB_COLUMN);
        Assert.assertNotNull((Object)clobColumn);
        Assert.assertEquals((long)1L, (long)clobColumn.getValues().size());
        Object object = clobColumn.getValues().get(0);
        Assert.assertEquals((Object)this.CLOB_VAL, (Object)object.toString());
    }

    private String createTableWithClobSQL() {
        String databaseType;
        switch (databaseType = this.testSettings.getDatabaseType()) {
            case "mysql": 
            case "mariadb": {
                return "CREATE TABLE " + this.CLOB_TABLE + " (ID INTEGER PRIMARY KEY," + this.CLOB_COLUMN + " LONGTEXT)";
            }
            case "postgres": {
                return "CREATE TABLE " + this.CLOB_TABLE + " (ID INTEGER PRIMARY KEY," + this.CLOB_COLUMN + " TEXT)";
            }
        }
        return "CREATE TABLE " + this.CLOB_TABLE + " (ID INTEGER PRIMARY KEY," + this.CLOB_COLUMN + " CLOB)";
    }

    private void removeClobTable() throws SQLException {
        String DELETE = "DROP TABLE " + this.CLOB_TABLE;
        Statement stmt = this.conn.createStatement();
        stmt.executeUpdate(DELETE);
    }
}

