/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.sql;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.dashbuilder.dataprovider.sql.SQLDataSourceLocator;
import org.dashbuilder.dataset.def.SQLDataSetDef;
import org.h2.jdbcx.JdbcDataSource;

public class DatabaseTestSettings {
    public static final String H2 = "h2";
    public static final String H2MEM = "h2mem";
    public static final String POSTGRES = "postgres";
    public static final String MYSQL = "mysql";
    public static final String MARIADB = "mariadb";
    public static final String ORACLE = "oracle";
    public static final String DB2 = "db2";
    public static final String SQLSERVER = "sqlserver";
    public static final String SYBASE = "sybase";
    public static final String MONETDB = "monetdb";
    protected Properties connectionSettings;

    public DatabaseTestSettings() {
        this(false);
    }

    public DatabaseTestSettings(boolean externalDatasourceConfig) {
        if (!externalDatasourceConfig) {
            String type = this.getDatabaseType();
            this.connectionSettings = new Properties();
            String propsFile = "testdb-" + type + ".properties";
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(propsFile);
            if (is != null) {
                try {
                    this.connectionSettings.load(is);
                }
                catch (IOException e) {
                    throw new RuntimeException("Database settings file load error: " + propsFile, e);
                }
            } else {
                throw new IllegalArgumentException("Database settings file not found in classpath: " + propsFile);
            }
        }
    }

    public Properties getConnectionSettings() {
        return this.connectionSettings;
    }

    public String getExpenseReportsTableDsetFile() {
        return "expenseReports.dset";
    }

    public String getExpenseReportsQueryDsetFile() {
        return "expenseReports_query.dset";
    }

    public String getExpenseReportsSqlDsetFile() {
        return "expenseReports_sql.dset";
    }

    public boolean isH2() {
        return H2.equals(this.getDatabaseType()) || H2MEM.equals(this.getDatabaseType());
    }

    public boolean isMySQL() {
        return MYSQL.equals(this.getDatabaseType());
    }

    public boolean isMariaDB() {
        return MARIADB.equals(this.getDatabaseType());
    }

    public boolean isPostgres() {
        return POSTGRES.equals(this.getDatabaseType());
    }

    public boolean isOracle() {
        return ORACLE.equals(this.getDatabaseType());
    }

    public boolean isSqlServer() {
        return SQLSERVER.equals(this.getDatabaseType());
    }

    public boolean isDb2() {
        return DB2.equals(this.getDatabaseType());
    }

    public boolean isSybase() {
        return SYBASE.equals(this.getDatabaseType());
    }

    public boolean isMonetDB() {
        return MONETDB.equals(this.getDatabaseType());
    }

    public String getDatabaseType() {
        return H2MEM;
    }

    public SQLDataSourceLocator getDataSourceLocator() {
        return new SQLDataSourceLocator(){

            public DataSource lookup(SQLDataSetDef def) throws Exception {
                String url = DatabaseTestSettings.this.connectionSettings.getProperty("url");
                String user = DatabaseTestSettings.this.connectionSettings.getProperty("user");
                String password = DatabaseTestSettings.this.connectionSettings.getProperty("password");
                JdbcDataSource ds = new JdbcDataSource();
                ds.setURL(url);
                if (!StringUtils.isBlank((CharSequence)user)) {
                    ds.setUser(user);
                }
                if (!StringUtils.isBlank((CharSequence)password)) {
                    ds.setPassword(password);
                }
                return ds;
            }
        };
    }
}

