/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dataprovider.sql;

import org.dashbuilder.dataprovider.sql.SQLDataSetTestBase;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookupFactory;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.impl.DataSetLookupBuilderImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.slf4j.Logger;

@RunWith(value=MockitoJUnitRunner.class)
public class SQLInjectionAttacksTest
extends SQLDataSetTestBase {
    @Mock
    Logger logger;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.sqlDataSetProvider.log = this.logger;
        ((Logger)Mockito.doAnswer(invocationOnMock -> {
            String sql = (String)invocationOnMock.getArguments()[0];
            System.out.println(sql);
            return null;
        }).when((Object)this.logger)).debug(Mockito.anyString());
    }

    @Override
    public void testAll() throws Exception {
        this.testStringFilterInjection();
    }

    public void testStringFilterInjection() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset("expense_reports")).filter("EMPLOYEE", new ColumnFilter[]{FilterFactory.equalsTo((Comparable)((Object)"David' OR EMPLOYEE != 'Toni"))})).buildLookup());
        Assert.assertEquals((long)result.getRowCount(), (long)0L);
        result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset("expense_reports")).filter("EMPLOYEE", new ColumnFilter[]{FilterFactory.equalsTo((Comparable)((Object)"David\" OR EMPLOYEE != \"Toni"))})).buildLookup());
        Assert.assertEquals((long)result.getRowCount(), (long)0L);
        result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset("expense_reports")).filter("EMPLOYEE", new ColumnFilter[]{FilterFactory.equalsTo((Comparable)((Object)"David` OR EMPLOYEE != `Toni"))})).buildLookup());
        Assert.assertEquals((long)result.getRowCount(), (long)0L);
    }

    @Test
    public void testDropTable() throws Exception {
        DataSet result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset("expense_reports")).filter("EMPLOYEE", new ColumnFilter[]{FilterFactory.equalsTo((Comparable)((Object)"David'; DROP TABLE 'EXPENSE_REPORTS; SELECT 'a' = 'a"))})).buildLookup());
        result = this.dataSetManager.lookupDataSet(((DataSetLookupBuilderImpl)DataSetLookupFactory.newDataSetLookupBuilder().dataset("expense_reports")).buildLookup());
        Assert.assertEquals((long)result.getRowCount(), (long)50L);
    }
}

