/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.source.git;

import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import org.guvnor.ala.source.Host;
import org.guvnor.ala.source.Repository;
import org.guvnor.ala.source.git.GitCredentials;
import org.guvnor.ala.source.git.GitHubRepository;
import org.guvnor.ala.source.git.Protocol;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.commons.config.ConfigProperties;

public class GitHub
implements Host<GitCredentials> {
    private final String id = this.toHex("GitHub");
    private final String name;
    private final GitCredentials credentials;
    private final ConfigProperties configProperties;

    public GitHub() {
        this(new GitCredentials());
    }

    public GitHub(GitCredentials credentials) {
        this(credentials, new ConfigProperties(System.getProperties()));
    }

    public GitHub(GitCredentials credentials, ConfigProperties configProperties) {
        this.name = "GitHub";
        this.credentials = credentials;
        this.configProperties = configProperties;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Repository getRepository(String id) {
        return this.getRepository(id, Collections.emptyMap());
    }

    public Repository getRepository(String id, Map<String, String> env) {
        return this.getRepository(this.credentials, id, env);
    }

    public Repository getRepository(GitCredentials credential, String repositoryId, Map<String, String> env) {
        Protocol protocol;
        PortablePreconditions.checkNotNull((String)"credential", (Object)credential);
        PortablePreconditions.checkNotEmpty((String)"id", (String)repositoryId);
        PortablePreconditions.checkCondition((String)"id must have a slash", (boolean)repositoryId.contains("/"));
        String[] ids = repositoryId.split("/");
        if (env != null && !env.isEmpty()) {
            Protocol tempProtocol;
            String _protocol = env.getOrDefault("protocol", Protocol.HTTPS.toString());
            try {
                tempProtocol = Protocol.valueOf(_protocol);
            }
            catch (Exception ex) {
                tempProtocol = Protocol.HTTPS;
            }
            protocol = tempProtocol;
        } else {
            protocol = Protocol.HTTPS;
        }
        return new GitHubRepository(this, repositoryId, ids[0], ids[1], protocol.toURI("github.com", repositoryId), credential, env, this.configProperties);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GitHub)) {
            return false;
        }
        GitHub gitHub = (GitHub)o;
        return this.id.equals(gitHub.id) && this.name.equals(gitHub.name);
    }

    public int hashCode() {
        return 31 * this.id.hashCode() + this.name.hashCode();
    }

    private String toHex(String arg) {
        return String.format("%040x", new BigInteger(1, arg.getBytes(Charset.forName("UTF-8"))));
    }
}

