/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.source.git;

import java.math.BigInteger;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import org.guvnor.ala.source.Host;
import org.guvnor.ala.source.Repository;
import org.guvnor.ala.source.git.GitCredentials;
import org.guvnor.ala.source.git.GitRepository;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.commons.config.ConfigProperties;

public class UFLocal
implements Host<GitCredentials> {
    private final String id = this.toHex("UFLocal");
    private final String name;
    private final GitCredentials credentials;
    private final ConfigProperties configProperties;

    public UFLocal() {
        this(new GitCredentials());
    }

    public UFLocal(GitCredentials credentials) {
        this(credentials, new ConfigProperties(System.getProperties()));
    }

    public UFLocal(GitCredentials credentials, ConfigProperties configProperties) {
        this.name = "UFLocal";
        this.credentials = credentials;
        this.configProperties = configProperties;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Repository getRepository(String id) {
        return this.getRepository(id, Collections.emptyMap());
    }

    public Repository getRepository(String id, Map<String, String> env) {
        return this.getRepository(this.credentials, id, env);
    }

    public Repository getRepository(GitCredentials credential, String repositoryId, Map<String, String> env) {
        PortablePreconditions.checkNotNull((String)"credential", (Object)credential);
        PortablePreconditions.checkNotEmpty((String)"id", (String)repositoryId);
        return new GitRepository(this, repositoryId, repositoryId, URI.create("git://local"), credential, env, this.configProperties);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UFLocal)) {
            return false;
        }
        UFLocal gitHub = (UFLocal)o;
        return this.id.equals(gitHub.id) && this.name.equals(gitHub.name);
    }

    public int hashCode() {
        return 31 * this.id.hashCode() + this.name.hashCode();
    }

    private String toHex(String arg) {
        return String.format("%040x", new BigInteger(1, arg.getBytes(Charset.forName("UTF-8"))));
    }
}

