/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.pipeline.execution.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.enterprise.inject.Instance;
import org.guvnor.ala.pipeline.ConfigExecutor;
import org.guvnor.ala.pipeline.Input;
import org.guvnor.ala.pipeline.Pipeline;
import org.guvnor.ala.pipeline.Stage;
import org.guvnor.ala.pipeline.events.PipelineEventListener;
import org.guvnor.ala.pipeline.execution.PipelineExecutor;
import org.guvnor.ala.pipeline.execution.PipelineExecutorTask;
import org.guvnor.ala.pipeline.execution.PipelineExecutorTaskDef;
import org.guvnor.ala.pipeline.execution.PipelineExecutorTrace;
import org.guvnor.ala.pipeline.execution.impl.PipelineExecutorTaskManagerImpl;
import org.guvnor.ala.pipeline.execution.impl.PipelineExecutorTaskManagerImplHelper;
import org.guvnor.ala.registry.PipelineExecutorRegistry;
import org.guvnor.ala.registry.PipelineRegistry;
import org.junit.Assert;
import org.junit.Before;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;

public class PipelineExecutorTaskManagerImplTestBase {
    protected static final int CONFIG_EXECUTORS_SIZE = 5;
    protected static final int PIPELINE_STAGES_SIZE = 6;
    protected static final int PIPELINE_EVENT_LISTENERS = 7;
    protected static final String PIPELINE_ID = "PIPELINE_ID";
    protected static final String TASK_ID = "TASK_ID";
    protected static final String ERROR_MESSAGE = "ERROR_MESSAGE";
    @Mock
    protected Instance<ConfigExecutor> configExecutorsInstance;
    @Mock
    protected Instance<PipelineEventListener> eventListenersInstance;
    @Mock
    protected PipelineExecutorRegistry pipelineExecutorRegistry;
    protected ArgumentCaptor<PipelineExecutorTrace> pipelineExecutorTraceCaptor;
    protected PipelineExecutorTaskManagerImpl taskManager;
    protected PipelineExecutorTaskManagerImplHelper taskManagerHelper;
    @Mock
    protected ExecutorService executorService;
    @Mock
    protected PipelineExecutor pipelineExecutor;
    protected List<ConfigExecutor> configExecutors;
    protected List<PipelineEventListener> externalListeners;
    protected ArgumentCaptor<String> stringCaptor;
    protected ArgumentCaptor<PipelineExecutorTaskManagerImpl.TaskEntry> taskEntryCaptor;
    protected Pipeline pipeline;
    @Mock
    protected PipelineRegistry pipelineRegistry;
    protected List<Stage> stages;
    protected PipelineExecutorTaskDef taskDef;
    protected Input input;

    @Before
    public void setUp() {
        this.pipelineExecutorTraceCaptor = ArgumentCaptor.forClass(PipelineExecutorTrace.class);
        this.taskEntryCaptor = ArgumentCaptor.forClass(PipelineExecutorTaskManagerImpl.TaskEntry.class);
        this.stringCaptor = ArgumentCaptor.forClass(String.class);
        this.configExecutors = PipelineExecutorTaskManagerImplTestBase.mockConfigExecutors(5);
        Mockito.when((Object)this.configExecutorsInstance.iterator()).thenReturn(this.configExecutors.iterator());
        this.externalListeners = PipelineExecutorTaskManagerImplTestBase.mockEventListeners(7);
        Mockito.when((Object)this.eventListenersInstance.iterator()).thenReturn(this.externalListeners.iterator());
        this.taskManagerHelper = (PipelineExecutorTaskManagerImplHelper)Mockito.spy((Object)new PipelineExecutorTaskManagerImplHelper(this.configExecutorsInstance, this.eventListenersInstance));
        ((PipelineExecutorTaskManagerImplHelper)Mockito.doReturn((Object)this.executorService).when((Object)this.taskManagerHelper)).createExecutorService();
        ((PipelineExecutorTaskManagerImplHelper)Mockito.doReturn((Object)this.pipelineExecutor).when((Object)this.taskManagerHelper)).createPipelineExecutor();
        this.taskManager = (PipelineExecutorTaskManagerImpl)Mockito.spy((Object)new PipelineExecutorTaskManagerImpl(this.pipelineRegistry, this.configExecutorsInstance, this.eventListenersInstance, this.pipelineExecutorRegistry){
            {
                this.taskManagerHelper = PipelineExecutorTaskManagerImplTestBase.this.taskManagerHelper;
            }

            protected void init() {
                super.init();
                this.futureTaskMap = (Map)Mockito.spy((Object)this.futureTaskMap);
            }
        });
    }

    public static List<ConfigExecutor> mockConfigExecutors(int count) {
        ArrayList<ConfigExecutor> result = new ArrayList<ConfigExecutor>();
        for (int i = 0; i < count; ++i) {
            result.add((ConfigExecutor)Mockito.mock(ConfigExecutor.class));
        }
        return result;
    }

    public static List<Stage> mockStages(int count) {
        ArrayList<Stage> result = new ArrayList<Stage>();
        for (int i = 0; i < count; ++i) {
            Stage stage = (Stage)Mockito.mock(Stage.class);
            Mockito.when((Object)stage.getName()).thenReturn((Object)("Stage.name." + Integer.toString(i)));
            result.add(stage);
        }
        return result;
    }

    public static List<PipelineEventListener> mockEventListeners(int count) {
        ArrayList<PipelineEventListener> result = new ArrayList<PipelineEventListener>();
        for (int i = 0; i < count; ++i) {
            PipelineEventListener listener = (PipelineEventListener)Mockito.mock(PipelineEventListener.class);
            result.add(listener);
        }
        return result;
    }

    protected void assertHasSameInfo(PipelineExecutorTask expectedTask, PipelineExecutorTask task) {
        Assert.assertEquals((Object)expectedTask.getId(), (Object)task.getId());
        Assert.assertEquals((Object)expectedTask.getPipelineStatus(), (Object)task.getPipelineStatus());
        Assert.assertEquals((Object)expectedTask.getPipelineError(), (Object)task.getPipelineError());
        Assert.assertEquals((Object)expectedTask.getOutput(), (Object)task.getOutput());
        this.assertHasSameInfo(expectedTask.getTaskDef(), task.getTaskDef());
        expectedTask.getTaskDef().getStages().forEach(stage -> {
            Assert.assertEquals((Object)expectedTask.getStageStatus(stage), (Object)task.getStageStatus(stage));
            Assert.assertEquals((Object)expectedTask.getStageError(stage), (Object)task.getStageError(stage));
        });
    }

    protected void assertHasSameInfo(PipelineExecutorTaskDef expectedTaskDef, PipelineExecutorTaskDef taskDef) {
        Assert.assertEquals((Object)expectedTaskDef.getInput(), (Object)taskDef.getInput());
        Assert.assertEquals((Object)expectedTaskDef.getPipeline(), (Object)taskDef.getPipeline());
        Assert.assertEquals((Object)expectedTaskDef.getProviderId(), (Object)taskDef.getProviderId());
        Assert.assertEquals((Object)expectedTaskDef.getProviderType(), (Object)taskDef.getProviderType());
    }
}

