/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.backend.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.ala.services.api.backend.RuntimeProvisioningServiceBackend;
import org.guvnor.ala.ui.model.ProviderType;
import org.guvnor.ala.ui.model.ProviderTypeKey;
import org.guvnor.ala.ui.model.ProviderTypeStatus;
import org.guvnor.ala.ui.preferences.ProvisioningPreferences;
import org.guvnor.ala.ui.service.ProviderTypeService;
import org.guvnor.common.services.project.preferences.scope.GlobalPreferenceScope;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.soup.commons.validation.PortablePreconditions;

@Service
@ApplicationScoped
public class ProviderTypeServiceImpl
implements ProviderTypeService {
    private RuntimeProvisioningServiceBackend runtimeProvisioningService;
    private ProvisioningPreferences provisioningPreferences;
    private GlobalPreferenceScope globalPreferenceScope;

    public ProviderTypeServiceImpl() {
    }

    @Inject
    public ProviderTypeServiceImpl(RuntimeProvisioningServiceBackend runtimeProvisioningService, ProvisioningPreferences provisioningPreferences, GlobalPreferenceScope globalPreferenceScope) {
        this.runtimeProvisioningService = runtimeProvisioningService;
        this.provisioningPreferences = provisioningPreferences;
        this.globalPreferenceScope = globalPreferenceScope;
    }

    public Collection<ProviderType> getAvailableProviderTypes() {
        ArrayList<ProviderType> result = new ArrayList<ProviderType>();
        List providers = this.runtimeProvisioningService.getProviderTypes(Integer.valueOf(0), Integer.valueOf(100), "providerTypeName", true);
        if (providers != null) {
            providers.forEach(providerType -> result.add(new ProviderType(new ProviderTypeKey(providerType.getProviderTypeName(), providerType.getVersion()), providerType.getProviderTypeName())));
        }
        return result;
    }

    public ProviderType getProviderType(ProviderTypeKey providerTypeKey) {
        PortablePreconditions.checkNotNull((String)"providerTypeKey", (Object)providerTypeKey);
        return this.getAvailableProviderTypes().stream().filter(providerType -> ((ProviderTypeKey)providerType.getKey()).equals((Object)providerTypeKey)).findFirst().orElse(null);
    }

    public Collection<ProviderType> getEnabledProviderTypes() {
        return this.getProviderTypesStatus().entrySet().stream().filter(entry -> ProviderTypeStatus.ENABLED.equals(entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public void enableProviderTypes(Collection<ProviderType> providerTypes) {
        PortablePreconditions.checkNotEmpty((String)"providerTypes", providerTypes);
        providerTypes.forEach(providerType -> this.enableProviderType((ProviderType)providerType, true));
    }

    public void disableProviderType(ProviderType providerType) {
        PortablePreconditions.checkNotNull((String)"providerType", (Object)providerType);
        this.enableProviderType(providerType, false);
    }

    public Map<ProviderType, ProviderTypeStatus> getProviderTypesStatus() {
        HashMap<ProviderType, ProviderTypeStatus> result = new HashMap<ProviderType, ProviderTypeStatus>();
        this.readProviderTypeEnablements().forEach((providerType, isEnabled) -> result.put((ProviderType)providerType, Boolean.TRUE.equals(isEnabled) ? ProviderTypeStatus.ENABLED : ProviderTypeStatus.DISABLED));
        this.getAvailableProviderTypes().forEach(providerType -> {
            if (!result.containsKey(providerType)) {
                result.put((ProviderType)providerType, ProviderTypeStatus.DISABLED);
            }
        });
        return result;
    }

    private void enableProviderType(ProviderType providerType, boolean enable) {
        PortablePreconditions.checkNotNull((String)"providerType", (Object)providerType);
        Map<ProviderType, Boolean> result = this.readProviderTypeEnablements();
        result.put(providerType, enable);
        this.saveProviderTypeEnablements(result);
    }

    private Map<ProviderType, Boolean> readProviderTypeEnablements() {
        this.provisioningPreferences.load();
        Map result = this.provisioningPreferences.getProviderTypeEnablements();
        return result != null ? result : new HashMap();
    }

    private void saveProviderTypeEnablements(Map<ProviderType, Boolean> providerTypeEnablements) {
        this.provisioningPreferences.load();
        this.provisioningPreferences.setProviderTypeEnablements(providerTypeEnablements);
        this.provisioningPreferences.save(this.globalPreferenceScope.resolve());
    }
}

