/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.backend.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.ala.ui.service.SourceService;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.ProjectService;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.errai.security.shared.api.identity.User;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationManager;

@Service
@ApplicationScoped
public class SourceServiceImpl
implements SourceService {
    private OrganizationalUnitService organizationalUnitService;
    private RepositoryService repositoryService;
    private ProjectService<? extends Project> projectService;
    private AuthorizationManager authorizationManager;
    private User identity;

    public SourceServiceImpl() {
    }

    @Inject
    public SourceServiceImpl(OrganizationalUnitService organizationalUnitService, RepositoryService repositoryService, ProjectService<? extends Project> projectService, AuthorizationManager authorizationManager, User identity) {
        this.organizationalUnitService = organizationalUnitService;
        this.repositoryService = repositoryService;
        this.projectService = projectService;
        this.authorizationManager = authorizationManager;
        this.identity = identity;
    }

    public Collection<String> getOrganizationUnits() {
        return this.organizationalUnitService.getOrganizationalUnits().stream().map(OrganizationalUnit::getName).collect(Collectors.toList());
    }

    public Collection<String> getRepositories(String organizationalUnit) {
        PortablePreconditions.checkNotNull((String)"organizationalUnit", (Object)organizationalUnit);
        OrganizationalUnit ou = this.organizationalUnitService.getOrganizationalUnit(organizationalUnit);
        if (ou == null) {
            return new ArrayList<String>();
        }
        return this.organizationalUnitService.getOrganizationalUnit(organizationalUnit).getRepositories().stream().filter(repository -> this.authorizationManager.authorize((Resource)repository, this.identity)).map(Repository::getAlias).collect(Collectors.toList());
    }

    public Collection<String> getBranches(String repository) {
        PortablePreconditions.checkNotNull((String)"repository", (Object)repository);
        Repository repo = this.repositoryService.getRepository(repository);
        return repo != null ? repo.getBranches() : new ArrayList();
    }

    public Collection<Project> getProjects(String repositoryAlias, String branch) {
        PortablePreconditions.checkNotNull((String)"repositoryAlias", (Object)repositoryAlias);
        PortablePreconditions.checkNotNull((String)"branch", (Object)branch);
        Repository repo = this.repositoryService.getRepository(repositoryAlias);
        if (repo == null) {
            return new ArrayList<Project>();
        }
        return this.projectService.getProjects(repo, branch);
    }
}

