/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.ui.backend.service;

import java.util.Collection;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.ala.ui.model.Provider;
import org.guvnor.ala.ui.model.ProviderKey;
import org.guvnor.ala.ui.model.ProviderType;
import org.guvnor.ala.ui.model.ProviderTypeKey;
import org.guvnor.ala.ui.model.ProvidersInfo;
import org.guvnor.ala.ui.model.RuntimesInfo;
import org.guvnor.ala.ui.service.ProviderService;
import org.guvnor.ala.ui.service.ProviderTypeService;
import org.guvnor.ala.ui.service.ProvisioningScreensService;
import org.guvnor.ala.ui.service.RuntimeService;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.soup.commons.validation.PortablePreconditions;

@Service
@ApplicationScoped
public class ProvisioningScreensServiceImpl
implements ProvisioningScreensService {
    private ProviderTypeService providerTypeService;
    private ProviderService providerService;
    private RuntimeService runtimeService;

    public ProvisioningScreensServiceImpl() {
    }

    @Inject
    public ProvisioningScreensServiceImpl(ProviderTypeService providerTypeService, ProviderService providerService, RuntimeService runtimeService) {
        this.providerTypeService = providerTypeService;
        this.providerService = providerService;
        this.runtimeService = runtimeService;
    }

    public ProvidersInfo getProvidersInfo(ProviderTypeKey providerTypeKey) {
        PortablePreconditions.checkNotNull((String)"providerTypeKey", (Object)providerTypeKey);
        ProviderType providerType = this.providerTypeService.getProviderType(providerTypeKey);
        if (providerType == null) {
            return null;
        }
        Collection providersKey = this.providerService.getProvidersKey(providerType);
        return new ProvidersInfo(providerType, providersKey);
    }

    public RuntimesInfo getRuntimesInfo(ProviderKey providerKey) {
        PortablePreconditions.checkNotNull((String)"providerKey", (Object)providerKey);
        Provider provider = this.providerService.getProvider(providerKey);
        if (provider == null) {
            return null;
        }
        Collection items = this.runtimeService.getRuntimeItems(providerKey);
        return new RuntimesInfo(provider, items);
    }

    public boolean hasRuntimes(ProviderKey providerKey) {
        PortablePreconditions.checkNotNull((String)"providerKey", (Object)providerKey);
        return !this.runtimeService.getRuntimeItems(providerKey).isEmpty();
    }
}

