/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.command.client.impl;

import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kie.workbench.common.command.client.Command;
import org.kie.workbench.common.command.client.CommandListener;
import org.kie.workbench.common.command.client.CommandManager;
import org.kie.workbench.common.command.client.CommandResult;
import org.kie.workbench.common.command.client.HasCommandListener;
import org.kie.workbench.common.command.client.util.CommandUtils;

public class CommandManagerImpl<C, V>
implements CommandManager<C, V>,
HasCommandListener<CommandListener<C, V>> {
    private static Logger LOGGER = Logger.getLogger(CommandManagerImpl.class.getName());
    private CommandListener<C, V> listener = null;

    @Override
    public CommandResult<V> allow(C context, Command<C, V> command) {
        Objects.requireNonNull(command, "command");
        CommandManagerImpl.logCommand("ALLOW", command);
        CommandResult<V> result = command.allow(context);
        if (null != this.listener) {
            this.listener.onAllow(context, command, result);
        }
        CommandManagerImpl.logResult(result);
        return result;
    }

    @Override
    public CommandResult<V> execute(C context, Command<C, V> command) {
        Objects.requireNonNull(command, "command");
        CommandManagerImpl.logCommand("EXECUTE", command);
        CommandResult<V> result = command.execute(context);
        if (null != this.listener) {
            this.listener.onExecute(context, command, result);
        }
        CommandManagerImpl.logResult(result);
        return result;
    }

    @Override
    public CommandResult<V> undo(C context, Command<C, V> command) {
        CommandManagerImpl.logCommand("UNDO", command);
        CommandResult<V> result = command.undo(context);
        if (null != this.listener) {
            this.listener.onUndo(context, command, result);
        }
        CommandManagerImpl.logResult(result);
        return result;
    }

    @Override
    public void setCommandListener(CommandListener<C, V> listener) {
        this.listener = listener;
    }

    private static void logCommand(String type, Command<?, ?> command) {
        LOGGER.log(Level.FINE, "Evaluating (" + type + ") command [" + command + "]...");
    }

    private static void logResult(CommandResult<?> result) {
        LOGGER.log(Level.FINE, "Evaluation " + (CommandUtils.isError(result) ? "FAILED" : "SUCCESS") + " - Result [" + result + "]");
    }
}

