/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.dtable;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.kie.workbench.common.dmn.api.definition.v1_1.DecisionRule;
import org.kie.workbench.common.dmn.api.definition.v1_1.DecisionTable;
import org.kie.workbench.common.dmn.api.definition.v1_1.InputClause;
import org.kie.workbench.common.dmn.api.definition.v1_1.UnaryTests;
import org.kie.workbench.common.dmn.client.commands.VetoExecutionCommand;
import org.kie.workbench.common.dmn.client.commands.VetoUndoCommand;
import org.kie.workbench.common.dmn.client.commands.util.CommandUtils;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.DecisionTableUIModelMapper;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasGraphCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCommand;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.mvp.Command;

public class DeleteInputClauseCommand
extends AbstractCanvasGraphCommand
implements VetoExecutionCommand,
VetoUndoCommand {
    private final DecisionTable dtable;
    private final GridData uiModel;
    private final int uiColumnIndex;
    private final DecisionTableUIModelMapper uiModelMapper;
    private final Command executeCanvasOperation;
    private final Command undoCanvasOperation;
    private final InputClause oldInputClause;
    private final List<UnaryTests> oldColumnData;
    private final GridColumn<?> oldUiModelColumn;

    public DeleteInputClauseCommand(DecisionTable dtable, GridData uiModel, int uiColumnIndex, DecisionTableUIModelMapper uiModelMapper, Command executeCanvasOperation, Command undoCanvasOperation) {
        this.dtable = dtable;
        this.uiModel = uiModel;
        this.uiColumnIndex = uiColumnIndex;
        this.uiModelMapper = uiModelMapper;
        this.executeCanvasOperation = executeCanvasOperation;
        this.undoCanvasOperation = undoCanvasOperation;
        this.oldInputClause = (InputClause)dtable.getInput().get(uiColumnIndex - 1);
        this.oldColumnData = this.extractColumnData();
        this.oldUiModelColumn = (GridColumn)uiModel.getColumns().get(uiColumnIndex);
    }

    private List<UnaryTests> extractColumnData() {
        int clauseIndex = this.getInputClauseIndex();
        return this.dtable.getRule().stream().map(row -> (UnaryTests)row.getInputEntry().get(clauseIndex)).collect(Collectors.toList());
    }

    private int getInputClauseIndex() {
        return this.uiColumnIndex - 1;
    }

    protected org.kie.workbench.common.stunner.core.command.Command<GraphCommandExecutionContext, RuleViolation> newGraphCommand(AbstractCanvasHandler handler) {
        return new AbstractGraphCommand(){

            protected CommandResult<RuleViolation> check(GraphCommandExecutionContext gce) {
                return GraphCommandResultBuilder.SUCCESS;
            }

            public CommandResult<RuleViolation> execute(GraphCommandExecutionContext gce) {
                int clauseIndex = DeleteInputClauseCommand.this.getInputClauseIndex();
                DeleteInputClauseCommand.this.dtable.getRule().forEach(row -> {
                    UnaryTests cfr_ignored_0 = (UnaryTests)row.getInputEntry().remove(clauseIndex);
                });
                DeleteInputClauseCommand.this.dtable.getInput().remove(clauseIndex);
                return GraphCommandResultBuilder.SUCCESS;
            }

            public CommandResult<RuleViolation> undo(GraphCommandExecutionContext gce) {
                int clauseIndex = DeleteInputClauseCommand.this.getInputClauseIndex();
                DeleteInputClauseCommand.this.dtable.getInput().add(clauseIndex, DeleteInputClauseCommand.this.oldInputClause);
                IntStream.range(0, DeleteInputClauseCommand.this.dtable.getRule().size()).forEach(rowIndex -> {
                    UnaryTests value = (UnaryTests)DeleteInputClauseCommand.this.oldColumnData.get(rowIndex);
                    ((DecisionRule)DeleteInputClauseCommand.this.dtable.getRule().get(rowIndex)).getInputEntry().add(clauseIndex, value);
                });
                return GraphCommandResultBuilder.SUCCESS;
            }
        };
    }

    protected org.kie.workbench.common.stunner.core.command.Command<AbstractCanvasHandler, CanvasViolation> newCanvasCommand(AbstractCanvasHandler handler) {
        return new AbstractCanvasCommand(){

            public CommandResult<CanvasViolation> execute(AbstractCanvasHandler handler) {
                GridColumn gridColumn = (GridColumn)DeleteInputClauseCommand.this.uiModel.getColumns().get(DeleteInputClauseCommand.this.uiColumnIndex);
                DeleteInputClauseCommand.this.uiModel.deleteColumn(gridColumn);
                DeleteInputClauseCommand.this.updateParentInformation();
                DeleteInputClauseCommand.this.executeCanvasOperation.execute();
                return CanvasCommandResultBuilder.SUCCESS;
            }

            public CommandResult<CanvasViolation> undo(AbstractCanvasHandler handler) {
                DeleteInputClauseCommand.this.uiModel.insertColumn(DeleteInputClauseCommand.this.uiColumnIndex, DeleteInputClauseCommand.this.oldUiModelColumn);
                for (int rowIndex = 0; rowIndex < DeleteInputClauseCommand.this.dtable.getRule().size(); ++rowIndex) {
                    DeleteInputClauseCommand.this.uiModelMapper.fromDMNModel(rowIndex, DeleteInputClauseCommand.this.uiColumnIndex);
                }
                DeleteInputClauseCommand.this.updateParentInformation();
                DeleteInputClauseCommand.this.undoCanvasOperation.execute();
                return CanvasCommandResultBuilder.SUCCESS;
            }
        };
    }

    public void updateParentInformation() {
        CommandUtils.updateParentInformation(this.uiModel);
    }
}

