/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.dtable;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.kie.workbench.common.dmn.api.definition.v1_1.DecisionRule;
import org.kie.workbench.common.dmn.api.definition.v1_1.DecisionTable;
import org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression;
import org.kie.workbench.common.dmn.api.definition.v1_1.OutputClause;
import org.kie.workbench.common.dmn.client.commands.VetoExecutionCommand;
import org.kie.workbench.common.dmn.client.commands.VetoUndoCommand;
import org.kie.workbench.common.dmn.client.commands.util.CommandUtils;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.DecisionTableUIModelMapper;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasGraphCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCommand;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.mvp.Command;

public class DeleteOutputClauseCommand
extends AbstractCanvasGraphCommand
implements VetoExecutionCommand,
VetoUndoCommand {
    private final DecisionTable dtable;
    private final GridData uiModel;
    private final int uiColumnIndex;
    private final DecisionTableUIModelMapper uiModelMapper;
    private final Command executeCanvasOperation;
    private final Command undoCanvasOperation;
    private final OutputClause oldOutputClause;
    private final List<LiteralExpression> oldColumnData;
    private final GridColumn<?> oldUiModelColumn;

    public DeleteOutputClauseCommand(DecisionTable dtable, GridData uiModel, int uiColumnIndex, DecisionTableUIModelMapper uiModelMapper, Command executeCanvasOperation, Command undoCanvasOperation) {
        this.dtable = dtable;
        this.uiModel = uiModel;
        this.uiColumnIndex = uiColumnIndex;
        this.uiModelMapper = uiModelMapper;
        this.executeCanvasOperation = executeCanvasOperation;
        this.undoCanvasOperation = undoCanvasOperation;
        this.oldOutputClause = (OutputClause)dtable.getOutput().get(this.getOutputClauseIndex());
        this.oldColumnData = this.extractColumnData();
        this.oldUiModelColumn = (GridColumn)uiModel.getColumns().get(uiColumnIndex);
    }

    private List<LiteralExpression> extractColumnData() {
        int clauseIndex = this.getOutputClauseIndex();
        return this.dtable.getRule().stream().map(row -> (LiteralExpression)row.getOutputEntry().get(clauseIndex)).collect(Collectors.toList());
    }

    private int getOutputClauseIndex() {
        return this.uiColumnIndex - 1 - this.dtable.getInput().size();
    }

    protected org.kie.workbench.common.stunner.core.command.Command<GraphCommandExecutionContext, RuleViolation> newGraphCommand(AbstractCanvasHandler handler) {
        return new AbstractGraphCommand(){

            protected CommandResult<RuleViolation> check(GraphCommandExecutionContext gce) {
                return GraphCommandResultBuilder.SUCCESS;
            }

            public CommandResult<RuleViolation> execute(GraphCommandExecutionContext gce) {
                int clauseIndex = DeleteOutputClauseCommand.this.getOutputClauseIndex();
                DeleteOutputClauseCommand.this.dtable.getRule().forEach(row -> {
                    LiteralExpression cfr_ignored_0 = (LiteralExpression)row.getOutputEntry().remove(clauseIndex);
                });
                DeleteOutputClauseCommand.this.dtable.getOutput().remove(clauseIndex);
                return GraphCommandResultBuilder.SUCCESS;
            }

            public CommandResult<RuleViolation> undo(GraphCommandExecutionContext gce) {
                int clauseIndex = DeleteOutputClauseCommand.this.getOutputClauseIndex();
                DeleteOutputClauseCommand.this.dtable.getOutput().add(clauseIndex, DeleteOutputClauseCommand.this.oldOutputClause);
                IntStream.range(0, DeleteOutputClauseCommand.this.dtable.getRule().size()).forEach(rowIndex -> {
                    LiteralExpression value = (LiteralExpression)DeleteOutputClauseCommand.this.oldColumnData.get(rowIndex);
                    ((DecisionRule)DeleteOutputClauseCommand.this.dtable.getRule().get(rowIndex)).getOutputEntry().add(clauseIndex, value);
                });
                return GraphCommandResultBuilder.SUCCESS;
            }
        };
    }

    protected org.kie.workbench.common.stunner.core.command.Command<AbstractCanvasHandler, CanvasViolation> newCanvasCommand(AbstractCanvasHandler handler) {
        return new AbstractCanvasCommand(){

            public CommandResult<CanvasViolation> execute(AbstractCanvasHandler handler) {
                GridColumn gridColumn = (GridColumn)DeleteOutputClauseCommand.this.uiModel.getColumns().get(DeleteOutputClauseCommand.this.uiColumnIndex);
                DeleteOutputClauseCommand.this.uiModel.deleteColumn(gridColumn);
                DeleteOutputClauseCommand.this.updateParentInformation();
                DeleteOutputClauseCommand.this.executeCanvasOperation.execute();
                return CanvasCommandResultBuilder.SUCCESS;
            }

            public CommandResult<CanvasViolation> undo(AbstractCanvasHandler handler) {
                DeleteOutputClauseCommand.this.uiModel.insertColumn(DeleteOutputClauseCommand.this.uiColumnIndex, DeleteOutputClauseCommand.this.oldUiModelColumn);
                for (int rowIndex = 0; rowIndex < DeleteOutputClauseCommand.this.dtable.getRule().size(); ++rowIndex) {
                    DeleteOutputClauseCommand.this.uiModelMapper.fromDMNModel(rowIndex, DeleteOutputClauseCommand.this.uiColumnIndex);
                }
                DeleteOutputClauseCommand.this.updateParentInformation();
                DeleteOutputClauseCommand.this.undoCanvasOperation.execute();
                return CanvasCommandResultBuilder.SUCCESS;
            }
        };
    }

    public void updateParentInformation() {
        CommandUtils.updateParentInformation(this.uiModel);
    }
}

