/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.dtable;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.kie.workbench.common.dmn.api.definition.v1_1.DecisionRule;
import org.kie.workbench.common.dmn.api.definition.v1_1.DecisionTable;
import org.kie.workbench.common.dmn.client.commands.VetoExecutionCommand;
import org.kie.workbench.common.dmn.client.commands.VetoUndoCommand;
import org.kie.workbench.common.dmn.client.commands.util.CommandUtils;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridData;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasGraphCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCommand;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.mvp.Command;

public class MoveRowsCommand
extends AbstractCanvasGraphCommand
implements VetoExecutionCommand,
VetoUndoCommand {
    private final DecisionTable dtable;
    private final DMNGridData uiModel;
    private final int index;
    private final List<GridRow> rows;
    private final Command canvasOperation;
    private final int oldIndex;

    public MoveRowsCommand(DecisionTable dtable, DMNGridData uiModel, int index, List<GridRow> rows, Command canvasOperation) {
        this.dtable = dtable;
        this.uiModel = uiModel;
        this.index = index;
        this.rows = new ArrayList<GridRow>(rows);
        this.canvasOperation = canvasOperation;
        this.oldIndex = uiModel.getRows().indexOf(rows.get(0));
    }

    protected org.kie.workbench.common.stunner.core.command.Command<GraphCommandExecutionContext, RuleViolation> newGraphCommand(AbstractCanvasHandler context) {
        return new AbstractGraphCommand(){

            protected CommandResult<RuleViolation> check(GraphCommandExecutionContext context) {
                return GraphCommandResultBuilder.SUCCESS;
            }

            public CommandResult<RuleViolation> execute(GraphCommandExecutionContext context) {
                this.moveDecisionRules(MoveRowsCommand.this.index);
                return GraphCommandResultBuilder.SUCCESS;
            }

            public CommandResult<RuleViolation> undo(GraphCommandExecutionContext context) {
                this.moveDecisionRules(MoveRowsCommand.this.oldIndex);
                return GraphCommandResultBuilder.SUCCESS;
            }

            private void moveDecisionRules(int index) {
                List rulesToMove = MoveRowsCommand.this.rows.stream().map(r -> MoveRowsCommand.this.uiModel.getRows().indexOf(r)).map(i -> (DecisionRule)MoveRowsCommand.this.dtable.getRule().get((int)i)).collect(Collectors.toList());
                List rules = MoveRowsCommand.this.dtable.getRule();
                CommandUtils.moveRows(rules, rulesToMove, index);
            }
        };
    }

    protected org.kie.workbench.common.stunner.core.command.Command<AbstractCanvasHandler, CanvasViolation> newCanvasCommand(AbstractCanvasHandler context) {
        return new AbstractCanvasCommand(){

            public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context) {
                MoveRowsCommand.this.uiModel.moveRowsTo(MoveRowsCommand.this.index, MoveRowsCommand.this.rows);
                CommandUtils.updateRowNumbers((GridData)MoveRowsCommand.this.uiModel, IntStream.range(0, MoveRowsCommand.this.uiModel.getRowCount()));
                MoveRowsCommand.this.canvasOperation.execute();
                return CanvasCommandResultBuilder.SUCCESS;
            }

            public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
                MoveRowsCommand.this.uiModel.moveRowsTo(MoveRowsCommand.this.oldIndex, MoveRowsCommand.this.rows);
                CommandUtils.updateRowNumbers((GridData)MoveRowsCommand.this.uiModel, IntStream.range(0, MoveRowsCommand.this.uiModel.getRowCount()));
                MoveRowsCommand.this.canvasOperation.execute();
                return CanvasCommandResultBuilder.SUCCESS;
            }
        };
    }
}

