/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.function;

import java.util.Optional;
import org.kie.workbench.common.dmn.api.definition.v1_1.Expression;
import org.kie.workbench.common.dmn.api.definition.v1_1.FunctionDefinition;
import org.kie.workbench.common.dmn.client.commands.VetoExecutionCommand;
import org.kie.workbench.common.dmn.client.commands.VetoUndoCommand;
import org.kie.workbench.common.dmn.client.commands.util.CommandUtils;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.KindUtilities;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellValueTuple;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasGraphCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCommand;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.mvp.Command;

public class SetKindCommand
extends AbstractCanvasGraphCommand
implements VetoExecutionCommand,
VetoUndoCommand {
    private final GridCellValueTuple cellTuple;
    private final FunctionDefinition function;
    private final FunctionDefinition.Kind kind;
    private final Optional<Expression> expression;
    private final Command executeCanvasOperation;
    private final Command undoCanvasOperation;
    private final FunctionDefinition.Kind oldKind;
    private final Optional<Expression> oldExpression;
    private final Optional<GridCellValue<?>> oldCellValue;

    public SetKindCommand(GridCellValueTuple cellTuple, FunctionDefinition function, FunctionDefinition.Kind kind, Optional<Expression> expression, Command executeCanvasOperation, Command undoCanvasOperation) {
        this.cellTuple = cellTuple;
        this.function = function;
        this.kind = kind;
        this.expression = expression;
        this.executeCanvasOperation = executeCanvasOperation;
        this.undoCanvasOperation = undoCanvasOperation;
        this.oldKind = KindUtilities.getKind(function);
        this.oldExpression = Optional.ofNullable(function.getExpression());
        this.oldCellValue = CommandUtils.extractGridCellValue(cellTuple);
    }

    protected org.kie.workbench.common.stunner.core.command.Command<GraphCommandExecutionContext, RuleViolation> newGraphCommand(AbstractCanvasHandler handler) {
        return new AbstractGraphCommand(){

            protected CommandResult<RuleViolation> check(GraphCommandExecutionContext gce) {
                return GraphCommandResultBuilder.SUCCESS;
            }

            public CommandResult<RuleViolation> execute(GraphCommandExecutionContext gce) {
                KindUtilities.setKind(SetKindCommand.this.function, SetKindCommand.this.kind);
                SetKindCommand.this.function.setExpression((Expression)SetKindCommand.this.expression.orElse(null));
                return GraphCommandResultBuilder.SUCCESS;
            }

            public CommandResult<RuleViolation> undo(GraphCommandExecutionContext gce) {
                KindUtilities.setKind(SetKindCommand.this.function, SetKindCommand.this.oldKind);
                SetKindCommand.this.function.setExpression((Expression)SetKindCommand.this.oldExpression.orElse(null));
                return GraphCommandResultBuilder.SUCCESS;
            }
        };
    }

    protected org.kie.workbench.common.stunner.core.command.Command<AbstractCanvasHandler, CanvasViolation> newCanvasCommand(AbstractCanvasHandler handler) {
        return new AbstractCanvasCommand(){

            public CommandResult<CanvasViolation> execute(AbstractCanvasHandler handler) {
                GridData gridData = SetKindCommand.this.cellTuple.getGridWidget().getModel();
                gridData.setCellValue(SetKindCommand.this.cellTuple.getRowIndex(), SetKindCommand.this.cellTuple.getColumnIndex(), SetKindCommand.this.cellTuple.getValue());
                SetKindCommand.this.executeCanvasOperation.execute();
                return CanvasCommandResultBuilder.SUCCESS;
            }

            public CommandResult<CanvasViolation> undo(AbstractCanvasHandler handler) {
                if (SetKindCommand.this.oldCellValue.isPresent()) {
                    SetKindCommand.this.cellTuple.getGridWidget().getModel().setCellValue(SetKindCommand.this.cellTuple.getRowIndex(), SetKindCommand.this.cellTuple.getColumnIndex(), (GridCellValue)SetKindCommand.this.oldCellValue.get());
                } else {
                    SetKindCommand.this.cellTuple.getGridWidget().getModel().deleteCell(SetKindCommand.this.cellTuple.getRowIndex(), SetKindCommand.this.cellTuple.getColumnIndex());
                }
                SetKindCommand.this.undoCanvasOperation.execute();
                return CanvasCommandResultBuilder.SUCCESS;
            }
        };
    }
}

