/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.decision.factories;

import java.util.Map;
import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.soup.commons.util.Maps;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.v1_1.BusinessKnowledgeModel;
import org.kie.workbench.common.dmn.api.definition.v1_1.Context;
import org.kie.workbench.common.dmn.api.definition.v1_1.Decision;
import org.kie.workbench.common.dmn.api.definition.v1_1.DecisionTable;
import org.kie.workbench.common.dmn.api.definition.v1_1.Expression;
import org.kie.workbench.common.dmn.api.definition.v1_1.FunctionDefinition;
import org.kie.workbench.common.dmn.api.definition.v1_1.Invocation;
import org.kie.workbench.common.dmn.api.definition.v1_1.List;
import org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression;
import org.kie.workbench.common.dmn.api.definition.v1_1.Relation;
import org.kie.workbench.common.dmn.client.decision.DecisionNavigatorItem;
import org.kie.workbench.common.dmn.client.decision.DecisionNavigatorPresenter;
import org.kie.workbench.common.dmn.client.events.EditExpressionEvent;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasSelectionEvent;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.uberfire.mvp.Command;

@Dependent
public class DecisionNavigatorNestedItemFactory {
    private static final Map<Class<? extends Expression>, DecisionNavigatorItem.Type> ITEM_TYPE_BY_EXPRESSION = new Maps.Builder().put(Context.class, (Object)DecisionNavigatorItem.Type.CONTEXT).put(DecisionTable.class, (Object)DecisionNavigatorItem.Type.DECISION_TABLE).put(FunctionDefinition.class, (Object)DecisionNavigatorItem.Type.FUNCTION_DEFINITION).put(Invocation.class, (Object)DecisionNavigatorItem.Type.INVOCATION).put(List.class, (Object)DecisionNavigatorItem.Type.LIST).put(LiteralExpression.class, (Object)DecisionNavigatorItem.Type.LITERAL_EXPRESSION).put(Relation.class, (Object)DecisionNavigatorItem.Type.RELATION).build();
    private final SessionManager sessionManager;
    private final Event<EditExpressionEvent> editExpressionEvent;
    private final DecisionNavigatorPresenter decisionNavigatorPresenter;
    private final Event<CanvasSelectionEvent> canvasSelectionEvent;

    @Inject
    public DecisionNavigatorNestedItemFactory(SessionManager sessionManager, Event<EditExpressionEvent> editExpressionEvent, DecisionNavigatorPresenter decisionNavigatorPresenter, Event<CanvasSelectionEvent> canvasSelectionEvent) {
        this.sessionManager = sessionManager;
        this.editExpressionEvent = editExpressionEvent;
        this.decisionNavigatorPresenter = decisionNavigatorPresenter;
        this.canvasSelectionEvent = canvasSelectionEvent;
    }

    public DecisionNavigatorItem makeItem(Node<View, Edge> node) {
        String uuid = this.getUUID(node);
        DecisionNavigatorItem.Type type = this.getType(node);
        String label = this.getLabel(node);
        String parentUUID = node.getUUID();
        Command onClick = this.makeOnClickCommand(node, parentUUID);
        return new DecisionNavigatorItem(uuid, label, type, onClick, parentUUID);
    }

    public boolean hasNestedElement(Node<View, Edge> node) {
        return this.getOptionalHasExpression(node).isPresent() && this.getOptionalExpression(node).isPresent();
    }

    Command makeOnClickCommand(Node<View, Edge> node, String uuid) {
        return () -> {
            CanvasHandler canvas = this.decisionNavigatorPresenter.getHandler();
            this.canvasSelectionEvent.fire((Object)this.makeCanvasSelectionEvent(canvas, uuid));
            this.editExpressionEvent.fire((Object)this.makeEditExpressionEvent(node));
        };
    }

    CanvasSelectionEvent makeCanvasSelectionEvent(CanvasHandler canvas, String uuid) {
        return new CanvasSelectionEvent(canvas, uuid);
    }

    EditExpressionEvent makeEditExpressionEvent(Node<View, Edge> node) {
        ClientSession currentSession = this.sessionManager.getCurrentSession();
        Optional<HasName> hasName = Optional.of((HasName)this.getDefinition(node));
        HasExpression hasExpression = this.getHasExpression(node);
        return new EditExpressionEvent(currentSession, node.getUUID(), hasExpression, hasName);
    }

    String getUUID(Node<View, Edge> node) {
        Expression expression = this.getExpression(node);
        return expression.getId().getValue();
    }

    String getLabel(Node<View, Edge> node) {
        return this.getExpression(node).getClass().getSimpleName();
    }

    DecisionNavigatorItem.Type getType(Node<View, Edge> node) {
        return ITEM_TYPE_BY_EXPRESSION.get(this.getExpression(node).getClass());
    }

    Optional<HasExpression> getOptionalHasExpression(Node<View, Edge> node) {
        Object definition = this.getDefinition(node);
        Object expression = definition instanceof BusinessKnowledgeModel ? ((BusinessKnowledgeModel)definition).getEncapsulatedLogic() : (definition instanceof Decision ? (Decision)definition : null);
        return Optional.ofNullable(expression);
    }

    Optional<Expression> getOptionalExpression(Node<View, Edge> node) {
        return Optional.ofNullable(this.getExpression(node));
    }

    Expression getExpression(Node<View, Edge> node) {
        return this.getHasExpression(node).getExpression();
    }

    HasExpression getHasExpression(Node<View, Edge> node) {
        return this.getOptionalHasExpression(node).orElseThrow(RuntimeException::new);
    }

    Object getDefinition(Node<View, Edge> node) {
        return ((View)node.getContent()).getDefinition();
    }
}

