/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions;

import com.ait.lienzo.client.core.mediator.IMediator;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.types.Transform;
import com.google.gwt.dom.client.Document;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.ui.Widget;
import java.util.Optional;
import java.util.function.Supplier;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.common.client.dom.Anchor;
import org.jboss.errai.common.client.dom.Heading;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.v1_1.Expression;
import org.kie.workbench.common.dmn.api.qualifiers.DMNEditor;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionContainerGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionEditorView;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.session.DMNSession;
import org.kie.workbench.common.dmn.client.widgets.grid.BoundaryTransformMediator;
import org.kie.workbench.common.dmn.client.widgets.grid.ExpressionGridCache;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanel;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanelContainer;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.session.Session;
import org.kie.workbench.common.stunner.forms.client.event.RefreshFormPropertiesEvent;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.TransformMediator;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.impl.RestrictedMousePanMediator;
import org.uberfire.mvp.ParameterizedCommand;

@Templated
@Dependent
public class ExpressionEditorViewImpl
implements ExpressionEditorView {
    static final double VP_SCALE = 1.0;
    private ExpressionEditorView.Presenter presenter;
    @DataField(value="returnToDRG")
    private Anchor returnToDRG;
    @DataField(value="expressionType")
    private Heading expressionType;
    @DataField(value="dmn-table")
    private DMNGridPanelContainer gridPanelContainer;
    private TranslationService translationService;
    private ListSelectorView.Presenter listSelector;
    private SessionManager sessionManager;
    private SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    private Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier;
    private Event<RefreshFormPropertiesEvent> refreshFormPropertiesEvent;
    private DMNGridPanel gridPanel;
    private DMNGridLayer gridLayer;
    private CellEditorControlsView.Presenter cellEditorControls;
    private RestrictedMousePanMediator mousePanMediator;
    private ExpressionContainerGrid expressionContainerGrid;

    public ExpressionEditorViewImpl() {
    }

    @Inject
    public ExpressionEditorViewImpl(Anchor returnToDRG, @Named(value="h2") Heading expressionType, @DMNEditor DMNGridPanelContainer gridPanelContainer, TranslationService translationService, ListSelectorView.Presenter listSelector, SessionManager sessionManager, @Session SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, @DMNEditor Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier, Event<RefreshFormPropertiesEvent> refreshFormPropertiesEvent) {
        this.returnToDRG = returnToDRG;
        this.expressionType = expressionType;
        this.gridPanelContainer = gridPanelContainer;
        this.translationService = translationService;
        this.listSelector = listSelector;
        this.sessionManager = sessionManager;
        this.sessionCommandManager = sessionCommandManager;
        this.expressionEditorDefinitionsSupplier = expressionEditorDefinitionsSupplier;
        this.refreshFormPropertiesEvent = refreshFormPropertiesEvent;
    }

    public void init(ExpressionEditorView.Presenter presenter) {
        this.presenter = presenter;
    }

    public void bind(DMNSession session) {
        this.gridPanel = session.getGridPanel();
        this.gridLayer = session.getGridLayer();
        this.cellEditorControls = session.getCellEditorControls();
        this.mousePanMediator = session.getMousePanMediator();
        this.setupGridPanel();
        this.setupGridWidget();
        this.setupGridWidgetPanControl();
    }

    protected void setupGridPanel() {
        Transform transform = new Transform().scale(1.0);
        this.gridPanel.getElement().setId("dmn_container_" + Document.get().createUniqueId());
        this.gridPanel.getViewport().setTransform(transform);
        this.gridPanel.add(this.gridLayer);
        this.gridPanelContainer.clear();
        this.gridPanelContainer.setWidget((Widget)this.gridPanel);
    }

    protected void setupGridWidget() {
        this.expressionContainerGrid = new ExpressionContainerGrid(this.gridLayer, this.cellEditorControls, this.translationService, this.listSelector, this.sessionManager, this.sessionCommandManager, this.expressionEditorDefinitionsSupplier, this.getExpressionGridCacheSupplier(), (ParameterizedCommand<Optional<Expression>>)((ParameterizedCommand)this::setExpressionTypeText), (ParameterizedCommand<Optional<HasName>>)((ParameterizedCommand)this::setReturnToDRGText), this.refreshFormPropertiesEvent);
        this.gridLayer.removeAll();
        this.gridLayer.add((IPrimitive)this.expressionContainerGrid);
        this.gridLayer.select((GridWidget)this.expressionContainerGrid);
        this.gridLayer.enterPinnedMode((GridWidget)this.expressionContainerGrid, () -> {});
    }

    protected Supplier<ExpressionGridCache> getExpressionGridCacheSupplier() {
        return () -> ((DMNSession)this.sessionManager.getCurrentSession()).getExpressionGridCache();
    }

    protected void setupGridWidgetPanControl() {
        BoundaryTransformMediator defaultTransformMediator = new BoundaryTransformMediator((GridWidget)this.expressionContainerGrid);
        this.mousePanMediator.setTransformMediator((TransformMediator)defaultTransformMediator);
        this.mousePanMediator.setBatchDraw(true);
        this.gridLayer.setDefaultTransformMediator(defaultTransformMediator);
        this.gridPanel.getViewport().getMediators().push((IMediator)this.mousePanMediator);
    }

    @Override
    public void setExpression(String nodeUUID, HasExpression hasExpression, Optional<HasName> hasName) {
        this.expressionContainerGrid.setExpression(nodeUUID, hasExpression, hasName);
        this.setReturnToDRGText(hasName);
        this.setExpressionTypeText(Optional.ofNullable(hasExpression.getExpression()));
    }

    @Override
    public void setReturnToDRGText(Optional<HasName> hasName) {
        hasName.ifPresent(name -> this.returnToDRG.setTextContent(this.translationService.format("ExpressionEditor.ReturnToDRG", new Object[]{name.getName().getValue()})));
    }

    private void setExpressionTypeText(Optional<Expression> expression) {
        this.expressionType.setTextContent(expression.isPresent() ? expression.get().getClass().getSimpleName() : "<" + this.translationService.getTranslation("ExpressionEditor.UndefinedExpressionType") + ">");
    }

    @EventHandler(value={"returnToDRG"})
    void onClickReturnToDRG(ClickEvent event) {
        this.presenter.exit();
    }

    public void onResize() {
        this.gridPanelContainer.onResize();
    }
}

