/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.dtable;

import java.util.Optional;
import org.kie.workbench.common.dmn.api.definition.v1_1.DecisionTable;
import org.kie.workbench.common.dmn.api.definition.v1_1.InputClause;
import org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression;
import org.kie.workbench.common.dmn.api.definition.v1_1.OutputClause;
import org.kie.workbench.common.dmn.client.property.dmn.DefaultValueUtilities;

public class DecisionTableDefaultValueUtilities {
    public static final String INPUT_CLAUSE_PREFIX = "input-";
    public static final String INPUT_CLAUSE_UNARY_TEST_TEXT = "";
    public static final String OUTPUT_CLAUSE_PREFIX = "output-";
    public static final String OUTPUT_CLAUSE_EXPRESSION_TEXT = "";
    public static final String RULE_DESCRIPTION = "";

    public static String getNewInputClauseName(DecisionTable dtable) {
        return INPUT_CLAUSE_PREFIX + DecisionTableDefaultValueUtilities.getMaxUnusedInputClauseIndex(dtable);
    }

    private static int getMaxUnusedInputClauseIndex(DecisionTable dtable) {
        int maxIndex = 0;
        for (InputClause ic : dtable.getInput()) {
            Optional<Integer> index;
            LiteralExpression le = ic.getInputExpression();
            if (le == null || !(index = DefaultValueUtilities.extractIndex(le.getText(), INPUT_CLAUSE_PREFIX)).isPresent()) continue;
            maxIndex = Math.max(maxIndex, index.get());
        }
        return maxIndex + 1;
    }

    public static String getNewOutputClauseName(DecisionTable dtable) {
        return OUTPUT_CLAUSE_PREFIX + DecisionTableDefaultValueUtilities.getMaxUnusedOutputClauseIndex(dtable);
    }

    private static int getMaxUnusedOutputClauseIndex(DecisionTable dtable) {
        int maxIndex = 0;
        for (OutputClause oc : dtable.getOutput()) {
            Optional<Integer> index = DefaultValueUtilities.extractIndex(oc.getName(), OUTPUT_CLAUSE_PREFIX);
            if (!index.isPresent()) continue;
            maxIndex = Math.max(maxIndex, index.get());
        }
        return maxIndex + 1;
    }
}

